/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.dynamic.b;
import com.google.android.gms.internal.du;
import com.google.android.gms.maps.internal.r;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.GroundOverlayOptionsCreator;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.c;

public final class GroundOverlayOptions
implements SafeParcelable {
    public static final GroundOverlayOptionsCreator CREATOR = new GroundOverlayOptionsCreator();
    public static final float NO_DIMENSION = -1.0f;
    private final int kZ;
    private BitmapDescriptor yv;
    private LatLng yw;
    private float yx;
    private float yy;
    private LatLngBounds yz;
    private float yl;
    private float ys;
    private boolean yt = true;
    private float yA = 0.0f;
    private float yB = 0.5f;
    private float yC = 0.5f;

    GroundOverlayOptions(int versionCode, IBinder wrappedImage, LatLng location, float width, float height, LatLngBounds bounds, float bearing, float zIndex, boolean visible, float transparency, float anchorU, float anchorV) {
        this.kZ = versionCode;
        this.yv = new BitmapDescriptor(b.a.C(wrappedImage));
        this.yw = location;
        this.yx = width;
        this.yy = height;
        this.yz = bounds;
        this.yl = bearing;
        this.ys = zIndex;
        this.yt = visible;
        this.yA = transparency;
        this.yB = anchorU;
        this.yC = anchorV;
    }

    public GroundOverlayOptions() {
        this.kZ = 1;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (r.eh()) {
            c.a(this, out, flags);
        } else {
            GroundOverlayOptionsCreator.a(this, out, flags);
        }
    }

    public int describeContents() {
        return 0;
    }

    IBinder ej() {
        return this.yv.dP().asBinder();
    }

    public GroundOverlayOptions image(BitmapDescriptor image) {
        this.yv = image;
        return this;
    }

    public GroundOverlayOptions anchor(float u2, float v2) {
        this.yB = u2;
        this.yC = v2;
        return this;
    }

    public GroundOverlayOptions position(LatLng location, float width) {
        du.a(this.yz == null, "Position has already been set using positionFromBounds");
        du.b(location != null, "Location must be specified");
        du.b(width >= 0.0f, "Width must be non-negative");
        return this.a(location, width, -1.0f);
    }

    public GroundOverlayOptions position(LatLng location, float width, float height) {
        du.a(this.yz == null, "Position has already been set using positionFromBounds");
        du.b(location != null, "Location must be specified");
        du.b(width >= 0.0f, "Width must be non-negative");
        du.b(height >= 0.0f, "Height must be non-negative");
        return this.a(location, width, height);
    }

    private GroundOverlayOptions a(LatLng latLng, float f2, float f3) {
        this.yw = latLng;
        this.yx = f2;
        this.yy = f3;
        return this;
    }

    public GroundOverlayOptions positionFromBounds(LatLngBounds bounds) {
        du.a(this.yw == null, "Position has already been set using position: " + this.yw);
        this.yz = bounds;
        return this;
    }

    public GroundOverlayOptions bearing(float bearing) {
        this.yl = (bearing % 360.0f + 360.0f) % 360.0f;
        return this;
    }

    public GroundOverlayOptions zIndex(float zIndex) {
        this.ys = zIndex;
        return this;
    }

    public GroundOverlayOptions visible(boolean visible) {
        this.yt = visible;
        return this;
    }

    public GroundOverlayOptions transparency(float transparency) {
        du.b(transparency >= 0.0f && transparency <= 1.0f, "Transparency must be in the range [0..1]");
        this.yA = transparency;
        return this;
    }

    int getVersionCode() {
        return this.kZ;
    }

    public BitmapDescriptor getImage() {
        return this.yv;
    }

    public LatLng getLocation() {
        return this.yw;
    }

    public float getWidth() {
        return this.yx;
    }

    public float getHeight() {
        return this.yy;
    }

    public LatLngBounds getBounds() {
        return this.yz;
    }

    public float getBearing() {
        return this.yl;
    }

    public float getZIndex() {
        return this.ys;
    }

    public float getTransparency() {
        return this.yA;
    }

    public float getAnchorU() {
        return this.yB;
    }

    public float getAnchorV() {
        return this.yC;
    }

    public boolean isVisible() {
        return this.yt;
    }
}

