/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.util.AttributeSet;
import com.google.android.gms.R;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.GoogleMapOptionsCreator;
import com.google.android.gms.maps.a;
import com.google.android.gms.maps.internal.r;
import com.google.android.gms.maps.model.CameraPosition;

public final class GoogleMapOptions
implements SafeParcelable {
    public static final GoogleMapOptionsCreator CREATOR = new GoogleMapOptionsCreator();
    private final int kZ;
    private Boolean xF;
    private Boolean xG;
    private int xH = -1;
    private CameraPosition xI;
    private Boolean xJ;
    private Boolean xK;
    private Boolean xL;
    private Boolean xM;
    private Boolean xN;
    private Boolean xO;

    GoogleMapOptions(int versionCode, byte zOrderOnTop, byte useViewLifecycleInFragment, int mapType, CameraPosition camera, byte zoomControlsEnabled, byte compassEnabled, byte scrollGesturesEnabled, byte zoomGesturesEnabled, byte tiltGesturesEnabled, byte rotateGesturesEnabled) {
        this.kZ = versionCode;
        this.xF = com.google.android.gms.maps.internal.a.a(zOrderOnTop);
        this.xG = com.google.android.gms.maps.internal.a.a(useViewLifecycleInFragment);
        this.xH = mapType;
        this.xI = camera;
        this.xJ = com.google.android.gms.maps.internal.a.a(zoomControlsEnabled);
        this.xK = com.google.android.gms.maps.internal.a.a(compassEnabled);
        this.xL = com.google.android.gms.maps.internal.a.a(scrollGesturesEnabled);
        this.xM = com.google.android.gms.maps.internal.a.a(zoomGesturesEnabled);
        this.xN = com.google.android.gms.maps.internal.a.a(tiltGesturesEnabled);
        this.xO = com.google.android.gms.maps.internal.a.a(rotateGesturesEnabled);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (r.eh()) {
            a.a(this, out, flags);
        } else {
            GoogleMapOptionsCreator.a(this, out, flags);
        }
    }

    int getVersionCode() {
        return this.kZ;
    }

    byte dS() {
        return com.google.android.gms.maps.internal.a.c(this.xF);
    }

    byte dT() {
        return com.google.android.gms.maps.internal.a.c(this.xG);
    }

    byte dU() {
        return com.google.android.gms.maps.internal.a.c(this.xJ);
    }

    byte dV() {
        return com.google.android.gms.maps.internal.a.c(this.xK);
    }

    byte dW() {
        return com.google.android.gms.maps.internal.a.c(this.xL);
    }

    byte dX() {
        return com.google.android.gms.maps.internal.a.c(this.xM);
    }

    byte dY() {
        return com.google.android.gms.maps.internal.a.c(this.xN);
    }

    byte dZ() {
        return com.google.android.gms.maps.internal.a.c(this.xO);
    }

    public GoogleMapOptions() {
        this.kZ = 1;
    }

    public GoogleMapOptions zOrderOnTop(boolean zOrderOnTop) {
        this.xF = zOrderOnTop;
        return this;
    }

    public GoogleMapOptions useViewLifecycleInFragment(boolean useViewLifecycleInFragment) {
        this.xG = useViewLifecycleInFragment;
        return this;
    }

    public GoogleMapOptions mapType(int mapType) {
        this.xH = mapType;
        return this;
    }

    public GoogleMapOptions camera(CameraPosition camera) {
        this.xI = camera;
        return this;
    }

    public GoogleMapOptions zoomControlsEnabled(boolean enabled) {
        this.xJ = enabled;
        return this;
    }

    public GoogleMapOptions compassEnabled(boolean enabled) {
        this.xK = enabled;
        return this;
    }

    public GoogleMapOptions scrollGesturesEnabled(boolean enabled) {
        this.xL = enabled;
        return this;
    }

    public GoogleMapOptions zoomGesturesEnabled(boolean enabled) {
        this.xM = enabled;
        return this;
    }

    public GoogleMapOptions tiltGesturesEnabled(boolean enabled) {
        this.xN = enabled;
        return this;
    }

    public GoogleMapOptions rotateGesturesEnabled(boolean enabled) {
        this.xO = enabled;
        return this;
    }

    public Boolean getZOrderOnTop() {
        return this.xF;
    }

    public Boolean getUseViewLifecycleInFragment() {
        return this.xG;
    }

    public int getMapType() {
        return this.xH;
    }

    public CameraPosition getCamera() {
        return this.xI;
    }

    public Boolean getZoomControlsEnabled() {
        return this.xJ;
    }

    public Boolean getCompassEnabled() {
        return this.xK;
    }

    public Boolean getScrollGesturesEnabled() {
        return this.xL;
    }

    public Boolean getZoomGesturesEnabled() {
        return this.xM;
    }

    public Boolean getTiltGesturesEnabled() {
        return this.xN;
    }

    public Boolean getRotateGesturesEnabled() {
        return this.xO;
    }

    public static GoogleMapOptions createFromAttributes(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return null;
        }
        TypedArray typedArray = context.getResources().obtainAttributes(attrs, R.styleable.MapAttrs);
        GoogleMapOptions googleMapOptions = new GoogleMapOptions();
        if (typedArray.hasValue(0)) {
            googleMapOptions.mapType(typedArray.getInt(0, -1));
        }
        if (typedArray.hasValue(13)) {
            googleMapOptions.zOrderOnTop(typedArray.getBoolean(13, false));
        }
        if (typedArray.hasValue(12)) {
            googleMapOptions.useViewLifecycleInFragment(typedArray.getBoolean(12, false));
        }
        if (typedArray.hasValue(6)) {
            googleMapOptions.compassEnabled(typedArray.getBoolean(6, true));
        }
        if (typedArray.hasValue(7)) {
            googleMapOptions.rotateGesturesEnabled(typedArray.getBoolean(7, true));
        }
        if (typedArray.hasValue(8)) {
            googleMapOptions.scrollGesturesEnabled(typedArray.getBoolean(8, true));
        }
        if (typedArray.hasValue(9)) {
            googleMapOptions.tiltGesturesEnabled(typedArray.getBoolean(9, true));
        }
        if (typedArray.hasValue(11)) {
            googleMapOptions.zoomGesturesEnabled(typedArray.getBoolean(11, true));
        }
        if (typedArray.hasValue(10)) {
            googleMapOptions.zoomControlsEnabled(typedArray.getBoolean(10, true));
        }
        CameraPosition cameraPosition = CameraPosition.createFromAttributes(context, attrs);
        googleMapOptions.camera(cameraPosition);
        typedArray.recycle();
        return googleMapOptions;
    }
}

