/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.SystemClock;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.ds;
import com.google.android.gms.location.LocationRequestCreator;

public final class LocationRequest
implements SafeParcelable {
    public static final int PRIORITY_HIGH_ACCURACY = 100;
    public static final int PRIORITY_BALANCED_POWER_ACCURACY = 102;
    public static final int PRIORITY_LOW_POWER = 104;
    public static final int PRIORITY_NO_POWER = 105;
    private final int kZ;
    int mPriority;
    long tH;
    long tI;
    boolean tJ;
    long tA;
    int tK;
    float tL;
    public static final LocationRequestCreator CREATOR = new LocationRequestCreator();

    public static LocationRequest create() {
        return new LocationRequest();
    }

    public LocationRequest() {
        this.kZ = 1;
        this.mPriority = 102;
        this.tH = 3600000L;
        this.tI = 600000L;
        this.tJ = false;
        this.tA = Long.MAX_VALUE;
        this.tK = Integer.MAX_VALUE;
        this.tL = 0.0f;
    }

    public LocationRequest setPriority(int priority) {
        LocationRequest.aB(priority);
        this.mPriority = priority;
        return this;
    }

    public int getPriority() {
        return this.mPriority;
    }

    public LocationRequest setInterval(long millis) {
        LocationRequest.i(millis);
        this.tH = millis;
        if (!this.tJ) {
            this.tI = (long)((double)this.tH / 6.0);
        }
        return this;
    }

    public long getInterval() {
        return this.tH;
    }

    public LocationRequest setFastestInterval(long millis) {
        LocationRequest.i(millis);
        this.tJ = true;
        this.tI = millis;
        return this;
    }

    public long getFastestInterval() {
        return this.tI;
    }

    public LocationRequest setExpirationDuration(long millis) {
        long l2 = SystemClock.elapsedRealtime();
        this.tA = millis > Long.MAX_VALUE - l2 ? Long.MAX_VALUE : millis + l2;
        if (this.tA < 0L) {
            this.tA = 0L;
        }
        return this;
    }

    public LocationRequest setExpirationTime(long millis) {
        this.tA = millis;
        if (this.tA < 0L) {
            this.tA = 0L;
        }
        return this;
    }

    public long getExpirationTime() {
        return this.tA;
    }

    public LocationRequest setNumUpdates(int numUpdates) {
        if (numUpdates <= 0) {
            throw new IllegalArgumentException("invalid numUpdates: " + numUpdates);
        }
        this.tK = numUpdates;
        return this;
    }

    public int getNumUpdates() {
        return this.tK;
    }

    public LocationRequest setSmallestDisplacement(float smallestDisplacementMeters) {
        LocationRequest.a(smallestDisplacementMeters);
        this.tL = smallestDisplacementMeters;
        return this;
    }

    public float getSmallestDisplacement() {
        return this.tL;
    }

    private static void i(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("invalid interval: " + l2);
        }
    }

    private static void aB(int n2) {
        switch (n2) {
            case 100: 
            case 102: 
            case 104: 
            case 105: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid quality: " + n2);
            }
        }
    }

    private static void a(float f2) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("invalid displacement: " + f2);
        }
    }

    LocationRequest(int versionCode, int priority, long interval, long fastestInterval, boolean explicitFastestInterval, long expireAt, int numUpdates, float smallestDisplacement) {
        this.kZ = versionCode;
        this.mPriority = priority;
        this.tH = interval;
        this.tI = fastestInterval;
        this.tJ = explicitFastestInterval;
        this.tA = expireAt;
        this.tK = numUpdates;
        this.tL = smallestDisplacement;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        LocationRequestCreator.a(this, parcel, flags);
    }

    public static String aC(int n2) {
        switch (n2) {
            case 100: {
                return "PRIORITY_HIGH_ACCURACY";
            }
            case 102: {
                return "PRIORITY_BALANCED_POWER_ACCURACY";
            }
            case 104: {
                return "PRIORITY_LOW_POWER";
            }
            case 105: {
                return "PRIORITY_NO_POWER";
            }
        }
        return "???";
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Request[").append(LocationRequest.aC(this.mPriority));
        if (this.mPriority != 105) {
            stringBuilder.append(" requested=");
            stringBuilder.append(this.tH + "ms");
        }
        stringBuilder.append(" fastest=");
        stringBuilder.append(this.tI + "ms");
        if (this.tA != Long.MAX_VALUE) {
            long l2 = this.tA - SystemClock.elapsedRealtime();
            stringBuilder.append(" expireIn=");
            stringBuilder.append(l2 + "ms");
        }
        if (this.tK != Integer.MAX_VALUE) {
            stringBuilder.append(" num=").append(this.tK);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public int hashCode() {
        return ds.hashCode(this.mPriority, this.tH, this.tI, this.tJ, this.tA, this.tK, Float.valueOf(this.tL));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LocationRequest)) {
            return false;
        }
        LocationRequest locationRequest = (LocationRequest)object;
        return this.mPriority == locationRequest.mPriority && this.tH == locationRequest.tH && this.tI == locationRequest.tI && this.tJ == locationRequest.tJ && this.tA == locationRequest.tA && this.tK == locationRequest.tK && this.tL == locationRequest.tL;
    }

    int getVersionCode() {
        return this.kZ;
    }
}

