/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.SystemClock;
import com.google.android.gms.internal.fn;

public interface Geofence {
    public static final int GEOFENCE_TRANSITION_ENTER = 1;
    public static final int GEOFENCE_TRANSITION_EXIT = 2;
    public static final int GEOFENCE_TRANSITION_DWELL = 4;
    public static final long NEVER_EXPIRE = -1L;

    public String getRequestId();

    public static final class Builder {
        private String ty = null;
        private int tz = 0;
        private long tA = Long.MIN_VALUE;
        private short tB = (short)-1;
        private double tC;
        private double tD;
        private float tE;
        private int tF = 0;
        private int tG = -1;

        public Builder setRequestId(String requestId) {
            this.ty = requestId;
            return this;
        }

        public Builder setTransitionTypes(int transitionTypes) {
            this.tz = transitionTypes;
            return this;
        }

        public Builder setExpirationDuration(long durationMillis) {
            this.tA = durationMillis < 0L ? -1L : SystemClock.elapsedRealtime() + durationMillis;
            return this;
        }

        public Builder setCircularRegion(double latitude, double longitude, float radius) {
            this.tB = 1;
            this.tC = latitude;
            this.tD = longitude;
            this.tE = radius;
            return this;
        }

        public Builder setNotificationResponsiveness(int notificationResponsivenessMs) {
            this.tF = notificationResponsivenessMs;
            return this;
        }

        public Builder setLoiteringDelay(int loiteringDelayMs) {
            this.tG = loiteringDelayMs;
            return this;
        }

        public Geofence build() {
            if (this.ty == null) {
                throw new IllegalArgumentException("Request ID not set.");
            }
            if (this.tz == 0) {
                throw new IllegalArgumentException("Transitions types not set.");
            }
            if ((this.tz & 4) != 0 && this.tG < 0) {
                throw new IllegalArgumentException("Non-negative loitering delay needs to be set when transition types include GEOFENCE_TRANSITION_DWELLING.");
            }
            if (this.tA == Long.MIN_VALUE) {
                throw new IllegalArgumentException("Expiration not set.");
            }
            if (this.tB == -1) {
                throw new IllegalArgumentException("Geofence region not set.");
            }
            if (this.tF < 0) {
                throw new IllegalArgumentException("Notification responsiveness should be nonnegative.");
            }
            return new fn(this.ty, this.tz, 1, this.tC, this.tD, this.tE, this.tA, this.tF, this.tG);
        }
    }
}

