/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.content.Intent;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.du;
import com.google.android.gms.location.ActivityRecognitionResultCreator;
import com.google.android.gms.location.DetectedActivity;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityRecognitionResult
implements SafeParcelable {
    public static final String EXTRA_ACTIVITY_RESULT = "com.google.android.location.internal.EXTRA_ACTIVITY_RESULT";
    public static final ActivityRecognitionResultCreator CREATOR = new ActivityRecognitionResultCreator();
    private final int kZ;
    List<DetectedActivity> tt;
    long tu;
    long tv;

    public ActivityRecognitionResult(List<DetectedActivity> probableActivities, long time, long elapsedRealtimeMillis) {
        du.b(probableActivities != null && probableActivities.size() > 0, "Must have at least 1 detected activity");
        this.kZ = 1;
        this.tt = probableActivities;
        this.tu = time;
        this.tv = elapsedRealtimeMillis;
    }

    public ActivityRecognitionResult(DetectedActivity mostProbableActivity, long time, long elapsedRealtimeMillis) {
        this(Collections.singletonList(mostProbableActivity), time, elapsedRealtimeMillis);
    }

    public static boolean hasResult(Intent intent) {
        if (intent == null) {
            return false;
        }
        return intent.hasExtra(EXTRA_ACTIVITY_RESULT);
    }

    public static ActivityRecognitionResult extractResult(Intent intent) {
        if (!ActivityRecognitionResult.hasResult(intent)) {
            return null;
        }
        return (ActivityRecognitionResult)intent.getExtras().get(EXTRA_ACTIVITY_RESULT);
    }

    public DetectedActivity getMostProbableActivity() {
        return this.tt.get(0);
    }

    public int getActivityConfidence(int activityType) {
        for (DetectedActivity detectedActivity : this.tt) {
            if (detectedActivity.getType() != activityType) continue;
            return detectedActivity.getConfidence();
        }
        return 0;
    }

    public List<DetectedActivity> getProbableActivities() {
        return this.tt;
    }

    public long getTime() {
        return this.tu;
    }

    public long getElapsedRealtimeMillis() {
        return this.tv;
    }

    public String toString() {
        return "ActivityRecognitionResult [probableActivities=" + this.tt + ", timeMillis=" + this.tu + ", elapsedRealtimeMillis=" + this.tv + "]";
    }

    public ActivityRecognitionResult(int versionCode, List<DetectedActivity> probableActivities, long timeMillis, long elapsedRealtimeMillis) {
        this.kZ = 1;
        this.tt = probableActivities;
        this.tu = timeMillis;
        this.tv = elapsedRealtimeMillis;
    }

    public int getVersionCode() {
        return this.kZ;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        ActivityRecognitionResultCreator.a(this, out, flags);
    }
}

