/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.RemoteException;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesClient;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.internal.dk;
import com.google.android.gms.internal.dq;
import com.google.android.gms.internal.ek;
import com.google.android.gms.internal.gl;
import com.google.android.gms.internal.gm;
import com.google.android.gms.internal.gp;
import com.google.android.gms.internal.gs;
import com.google.android.gms.internal.gx;
import com.google.android.gms.internal.ha;
import com.google.android.gms.plus.PlusClient;
import com.google.android.gms.plus.model.moments.Moment;
import com.google.android.gms.plus.model.moments.MomentBuffer;
import com.google.android.gms.plus.model.people.Person;
import com.google.android.gms.plus.model.people.PersonBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class gq
extends dk<gp>
implements GooglePlayServicesClient {
    private Person zx;
    private gs zy;

    public void loadVisiblePeople(PlusClient.OnPeopleLoadedListener listener, String pageToken) {
        this.loadVisiblePeople(listener, 0, pageToken);
    }

    public gq(Context context, gs gs2, GooglePlayServicesClient.ConnectionCallbacks connectionCallbacks, GooglePlayServicesClient.OnConnectionFailedListener onConnectionFailedListener) {
        super(context, connectionCallbacks, onConnectionFailedListener, gs2.ew());
        this.zy = gs2;
    }

    public String getAccountName() {
        this.bB();
        try {
            return ((gp)this.bC()).getAccountName();
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public void writeMoment(Moment moment) {
        this.bB();
        try {
            ek ek2 = ek.a((gx)moment);
            ((gp)this.bC()).a(ek2);
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public void loadMoments(PlusClient.OnMomentsLoadedListener listener, int maxResults, String pageToken, Uri targetUrl, String type, String userId) {
        this.bB();
        a a2 = listener != null ? new a(listener) : null;
        try {
            ((gp)this.bC()).a(a2, maxResults, pageToken, targetUrl, type, userId);
        }
        catch (RemoteException remoteException) {
            a2.a(DataHolder.empty(8), null, null);
        }
    }

    public void loadMoments(PlusClient.OnMomentsLoadedListener listener) {
        this.loadMoments(listener, 20, null, null, null, "me");
    }

    public void removeMoment(String momentId) {
        this.bB();
        try {
            ((gp)this.bC()).removeMoment(momentId);
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public void loadVisiblePeople(PlusClient.OnPeopleLoadedListener listener, int orderBy, String pageToken) {
        this.bB();
        c c2 = new c(listener);
        try {
            ((gp)this.bC()).a(c2, 1, orderBy, -1, pageToken);
        }
        catch (RemoteException remoteException) {
            c2.a(DataHolder.empty(8), null);
        }
    }

    public void a(PlusClient.OnPeopleLoadedListener onPeopleLoadedListener, String[] stringArray) {
        this.a(onPeopleLoadedListener, Arrays.asList(stringArray));
    }

    public void a(PlusClient.OnPeopleLoadedListener onPeopleLoadedListener, Collection<String> collection) {
        this.bB();
        c c2 = new c(onPeopleLoadedListener);
        try {
            ((gp)this.bC()).a((gm)c2, new ArrayList<String>(collection));
        }
        catch (RemoteException remoteException) {
            c2.a(DataHolder.empty(8), null);
        }
    }

    public Person getCurrentPerson() {
        this.bB();
        return this.zx;
    }

    public void clearDefaultAccount() {
        this.bB();
        try {
            this.zx = null;
            ((gp)this.bC()).clearDefaultAccount();
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public void revokeAccessAndDisconnect(PlusClient.OnAccessRevokedListener listener) {
        this.bB();
        this.clearDefaultAccount();
        e e2 = new e(listener);
        try {
            ((gp)this.bC()).b(e2);
        }
        catch (RemoteException remoteException) {
            e2.b(8, null);
        }
    }

    public boolean aj(String string2) {
        return Arrays.asList(this.bA()).contains(string2);
    }

    protected gp av(IBinder iBinder) {
        return gp.a.au(iBinder);
    }

    @Override
    protected String an() {
        return "com.google.android.gms.plus.internal.IPlusService";
    }

    @Override
    protected String am() {
        return "com.google.android.gms.plus.service.START";
    }

    @Override
    protected void a(dq dq2, dk.d d2) throws RemoteException {
        Bundle bundle = new Bundle();
        bundle.putStringArray("request_visible_actions", this.zy.ex());
        dq2.a(d2, 4132500, this.zy.eA(), this.zy.ez(), this.bA(), this.zy.getAccountName(), bundle);
    }

    @Override
    protected void a(int n2, IBinder iBinder, Bundle bundle) {
        if (n2 == 0 && bundle != null && bundle.containsKey("loaded_person")) {
            this.zx = ha.g(bundle.getByteArray("loaded_person"));
        }
        super.a(n2, iBinder, bundle);
    }

    @Override
    protected /* synthetic */ IInterface p(IBinder iBinder) {
        return this.av(iBinder);
    }

    final class e
    extends gl {
        private final PlusClient.OnAccessRevokedListener zE;

        public e(PlusClient.OnAccessRevokedListener onAccessRevokedListener) {
            this.zE = onAccessRevokedListener;
        }

        public void b(int n2, Bundle bundle) {
            PendingIntent pendingIntent = null;
            if (bundle != null) {
                pendingIntent = (PendingIntent)bundle.getParcelable("pendingIntent");
            }
            ConnectionResult connectionResult = new ConnectionResult(n2, pendingIntent);
            gq.this.a(new f(this.zE, connectionResult));
        }
    }

    final class c
    extends gl {
        private final PlusClient.OnPeopleLoadedListener zD;

        public c(PlusClient.OnPeopleLoadedListener onPeopleLoadedListener) {
            this.zD = onPeopleLoadedListener;
        }

        public void a(DataHolder dataHolder, String string2) {
            ConnectionResult connectionResult;
            PendingIntent pendingIntent = null;
            if (dataHolder.getMetadata() != null) {
                pendingIntent = (PendingIntent)dataHolder.getMetadata().getParcelable("pendingIntent");
            }
            if (!(connectionResult = new ConnectionResult(dataHolder.getStatusCode(), pendingIntent)).isSuccess() && dataHolder != null) {
                if (!dataHolder.isClosed()) {
                    dataHolder.close();
                }
                dataHolder = null;
            }
            gq.this.a(new d(this.zD, connectionResult, dataHolder, string2));
        }
    }

    final class a
    extends gl {
        private final PlusClient.OnMomentsLoadedListener zz;

        public a(PlusClient.OnMomentsLoadedListener onMomentsLoadedListener) {
            this.zz = onMomentsLoadedListener;
        }

        public void a(DataHolder dataHolder, String string2, String string3) {
            ConnectionResult connectionResult;
            PendingIntent pendingIntent = null;
            if (dataHolder.getMetadata() != null) {
                pendingIntent = (PendingIntent)dataHolder.getMetadata().getParcelable("pendingIntent");
            }
            if (!(connectionResult = new ConnectionResult(dataHolder.getStatusCode(), pendingIntent)).isSuccess() && dataHolder != null) {
                if (!dataHolder.isClosed()) {
                    dataHolder.close();
                }
                dataHolder = null;
            }
            gq.this.a(new b(this.zz, connectionResult, dataHolder, string2, string3));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class f
    extends dk.b<PlusClient.OnAccessRevokedListener> {
        private final ConnectionResult zB;

        public f(PlusClient.OnAccessRevokedListener onAccessRevokedListener, ConnectionResult connectionResult) {
            super(onAccessRevokedListener);
            this.zB = connectionResult;
        }

        protected void a(PlusClient.OnAccessRevokedListener onAccessRevokedListener) {
            gq.this.disconnect();
            if (onAccessRevokedListener != null) {
                onAccessRevokedListener.onAccessRevoked(this.zB);
            }
        }

        @Override
        protected void aQ() {
        }

        @Override
        protected /* synthetic */ void b(Object object) {
            this.a((PlusClient.OnAccessRevokedListener)object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class d
    extends dk.c<PlusClient.OnPeopleLoadedListener> {
        private final ConnectionResult zB;
        private final String oi;

        public d(PlusClient.OnPeopleLoadedListener onPeopleLoadedListener, ConnectionResult connectionResult, DataHolder dataHolder, String string2) {
            super(onPeopleLoadedListener, dataHolder);
            this.zB = connectionResult;
            this.oi = string2;
        }

        @Override
        protected void a(PlusClient.OnPeopleLoadedListener onPeopleLoadedListener, DataHolder dataHolder) {
            onPeopleLoadedListener.onPeopleLoaded(this.zB, dataHolder != null ? new PersonBuffer(dataHolder) : null, this.oi);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class b
    extends dk.c<PlusClient.OnMomentsLoadedListener> {
        private final ConnectionResult zB;
        private final String oi;
        private final String zC;

        public b(PlusClient.OnMomentsLoadedListener onMomentsLoadedListener, ConnectionResult connectionResult, DataHolder dataHolder, String string2, String string3) {
            super(onMomentsLoadedListener, dataHolder);
            this.zB = connectionResult;
            this.oi = string2;
            this.zC = string3;
        }

        @Override
        protected void a(PlusClient.OnMomentsLoadedListener onMomentsLoadedListener, DataHolder dataHolder) {
            onMomentsLoadedListener.onMomentsLoaded(this.zB, dataHolder != null ? new MomentBuffer(dataHolder) : null, this.oi, this.zC);
        }
    }
}

