/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.location.Location;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.GooglePlayServicesClient;
import com.google.android.gms.internal.dg;
import com.google.android.gms.internal.dk;
import com.google.android.gms.internal.dq;
import com.google.android.gms.internal.du;
import com.google.android.gms.internal.fj;
import com.google.android.gms.internal.fk;
import com.google.android.gms.internal.fl;
import com.google.android.gms.internal.fn;
import com.google.android.gms.internal.fp;
import com.google.android.gms.location.LocationClient;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationStatusCodes;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class fm
extends dk<fk> {
    private final fp<fk> tM = new c();
    private final fl tS;
    private final HashMap tT = new HashMap();
    private final String tU;

    public fm(Context context, GooglePlayServicesClient.ConnectionCallbacks connectionCallbacks, GooglePlayServicesClient.OnConnectionFailedListener onConnectionFailedListener, String string2) {
        super(context, connectionCallbacks, onConnectionFailedListener, new String[0]);
        this.tS = new fl(context, this.tM);
        this.tU = string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        fl fl2 = this.tS;
        synchronized (fl2) {
            if (this.isConnected()) {
                this.tS.removeAllListeners();
                this.tS.dq();
            }
            super.disconnect();
        }
    }

    @Override
    protected String am() {
        return "com.google.android.location.internal.GoogleLocationManagerService.START";
    }

    @Override
    protected String an() {
        return "com.google.android.gms.location.internal.IGoogleLocationManagerService";
    }

    public void requestActivityUpdates(long detectionIntervalMillis, PendingIntent callbackIntent) {
        this.bB();
        du.f(callbackIntent);
        du.b(detectionIntervalMillis >= 0L, "detectionIntervalMillis must be >= 0");
        try {
            ((fk)this.bC()).a(detectionIntervalMillis, true, callbackIntent);
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public void removeActivityUpdates(PendingIntent callbackIntent) {
        this.bB();
        du.f(callbackIntent);
        try {
            ((fk)this.bC()).removeActivityUpdates(callbackIntent);
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public void addGeofences(List<fn> geofences, PendingIntent pendingIntent, LocationClient.OnAddGeofencesResultListener listener) {
        this.bB();
        du.b(geofences != null && geofences.size() > 0, "At least one geofence must be specified.");
        du.c(pendingIntent, "PendingIntent must be specified.");
        du.c(listener, "OnAddGeofencesResultListener not provided.");
        try {
            b b2 = listener == null ? null : new b(listener, this);
            ((fk)this.bC()).a(geofences, pendingIntent, b2, this.getContext().getPackageName());
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public void removeGeofences(PendingIntent pendingIntent, LocationClient.OnRemoveGeofencesResultListener listener) {
        this.bB();
        du.c(pendingIntent, "PendingIntent must be specified.");
        du.c(listener, "OnRemoveGeofencesResultListener not provided.");
        try {
            b b2 = listener == null ? null : new b(listener, this);
            ((fk)this.bC()).a(pendingIntent, (fj)b2, this.getContext().getPackageName());
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public void removeGeofences(List<String> geofenceRequestIds, LocationClient.OnRemoveGeofencesResultListener listener) {
        this.bB();
        du.b(geofenceRequestIds != null && geofenceRequestIds.size() > 0, "geofenceRequestIds can't be null nor empty.");
        du.c(listener, "OnRemoveGeofencesResultListener not provided.");
        String[] stringArray = geofenceRequestIds.toArray(new String[0]);
        try {
            b b2 = listener == null ? null : new b(listener, this);
            ((fk)this.bC()).a(stringArray, (fj)b2, this.getContext().getPackageName());
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public Location getLastLocation() {
        return this.tS.getLastLocation();
    }

    public void requestLocationUpdates(LocationRequest request, LocationListener listener) {
        this.requestLocationUpdates(request, listener, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestLocationUpdates(LocationRequest request, LocationListener listener, Looper looper) {
        fl fl2 = this.tS;
        synchronized (fl2) {
            this.tS.requestLocationUpdates(request, listener, looper);
        }
    }

    public void requestLocationUpdates(LocationRequest request, PendingIntent callbackIntent) {
        this.tS.requestLocationUpdates(request, callbackIntent);
    }

    public void removeLocationUpdates(LocationListener listener) {
        this.tS.removeLocationUpdates(listener);
    }

    public void removeLocationUpdates(PendingIntent callbackIntent) {
        this.tS.removeLocationUpdates(callbackIntent);
    }

    public void setMockMode(boolean isMockMode) {
        this.tS.setMockMode(isMockMode);
    }

    public void setMockLocation(Location mockLocation) {
        this.tS.setMockLocation(mockLocation);
    }

    protected fk J(IBinder iBinder) {
        return fk.a.I(iBinder);
    }

    @Override
    protected void a(dq dq2, dk.d d2) throws RemoteException {
        Bundle bundle = new Bundle();
        bundle.putString("client_name", this.tU);
        dq2.e(d2, 4132500, this.getContext().getPackageName(), bundle);
    }

    @Override
    protected /* synthetic */ IInterface p(IBinder iBinder) {
        return this.J(iBinder);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class d
    extends dk.b<LocationClient.OnRemoveGeofencesResultListener> {
        private final int ka;
        private final String[] tV;
        private final PendingIntent mPendingIntent;
        private final int ua;

        public d(int n2, LocationClient.OnRemoveGeofencesResultListener onRemoveGeofencesResultListener, int n3, String[] stringArray) {
            super(onRemoveGeofencesResultListener);
            dg.n(n2 == 2);
            this.ua = n2;
            this.ka = LocationStatusCodes.aD(n3);
            this.tV = stringArray;
            this.mPendingIntent = null;
        }

        public d(int n2, LocationClient.OnRemoveGeofencesResultListener onRemoveGeofencesResultListener, int n3, PendingIntent pendingIntent) {
            super(onRemoveGeofencesResultListener);
            dg.n(n2 == 1);
            this.ua = n2;
            this.ka = LocationStatusCodes.aD(n3);
            this.mPendingIntent = pendingIntent;
            this.tV = null;
        }

        protected void a(LocationClient.OnRemoveGeofencesResultListener onRemoveGeofencesResultListener) {
            if (onRemoveGeofencesResultListener != null) {
                switch (this.ua) {
                    case 1: {
                        onRemoveGeofencesResultListener.onRemoveGeofencesByPendingIntentResult(this.ka, this.mPendingIntent);
                        break;
                    }
                    case 2: {
                        onRemoveGeofencesResultListener.onRemoveGeofencesByRequestIdsResult(this.ka, this.tV);
                        break;
                    }
                    default: {
                        Log.wtf((String)"LocationClientImpl", (String)("Unsupported action: " + this.ua));
                    }
                }
            }
        }

        @Override
        protected void aQ() {
        }

        @Override
        protected /* synthetic */ void b(Object object) {
            this.a((LocationClient.OnRemoveGeofencesResultListener)object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class a
    extends dk.b<LocationClient.OnAddGeofencesResultListener> {
        private final int ka;
        private final String[] tV;

        public a(LocationClient.OnAddGeofencesResultListener onAddGeofencesResultListener, int n2, String[] stringArray) {
            super(onAddGeofencesResultListener);
            this.ka = LocationStatusCodes.aD(n2);
            this.tV = stringArray;
        }

        protected void a(LocationClient.OnAddGeofencesResultListener onAddGeofencesResultListener) {
            if (onAddGeofencesResultListener != null) {
                onAddGeofencesResultListener.onAddGeofencesResult(this.ka, this.tV);
            }
        }

        @Override
        protected void aQ() {
        }

        @Override
        protected /* synthetic */ void b(Object object) {
            this.a((LocationClient.OnAddGeofencesResultListener)object);
        }
    }

    private static final class b
    extends fj.a {
        private LocationClient.OnAddGeofencesResultListener tX;
        private LocationClient.OnRemoveGeofencesResultListener tY;
        private fm tZ;

        public b(LocationClient.OnAddGeofencesResultListener onAddGeofencesResultListener, fm fm2) {
            this.tX = onAddGeofencesResultListener;
            this.tY = null;
            this.tZ = fm2;
        }

        public b(LocationClient.OnRemoveGeofencesResultListener onRemoveGeofencesResultListener, fm fm2) {
            this.tY = onRemoveGeofencesResultListener;
            this.tX = null;
            this.tZ = fm2;
        }

        public void onAddGeofencesResult(int statusCode, String[] geofenceRequestIds) throws RemoteException {
            if (this.tZ == null) {
                Log.wtf((String)"LocationClientImpl", (String)"onAddGeofenceResult called multiple times");
                return;
            }
            fm fm2 = this.tZ;
            fm2.getClass();
            this.tZ.a(fm2.new a(this.tX, statusCode, geofenceRequestIds));
            this.tZ = null;
            this.tX = null;
            this.tY = null;
        }

        public void onRemoveGeofencesByRequestIdsResult(int statusCode, String[] geofenceRequestIds) {
            if (this.tZ == null) {
                Log.wtf((String)"LocationClientImpl", (String)"onRemoveGeofencesByRequestIdsResult called multiple times");
                return;
            }
            fm fm2 = this.tZ;
            fm2.getClass();
            this.tZ.a(fm2.new d(2, this.tY, statusCode, geofenceRequestIds));
            this.tZ = null;
            this.tX = null;
            this.tY = null;
        }

        public void onRemoveGeofencesByPendingIntentResult(int statusCode, PendingIntent pendingIntent) {
            if (this.tZ == null) {
                Log.wtf((String)"LocationClientImpl", (String)"onRemoveGeofencesByPendingIntentResult called multiple times");
                return;
            }
            fm fm2 = this.tZ;
            fm2.getClass();
            this.tZ.a(fm2.new d(1, this.tY, statusCode, pendingIntent));
            this.tZ = null;
            this.tX = null;
            this.tY = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class c
    implements fp<fk> {
        private c() {
        }

        @Override
        public void bB() {
            fm.this.bB();
        }

        public fk dr() {
            return (fk)fm.this.bC();
        }

        @Override
        public /* synthetic */ IInterface bC() {
            return this.dr();
        }
    }
}

