/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.content.ContentProviderClient;
import android.content.Context;
import android.location.Location;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.internal.du;
import com.google.android.gms.internal.fk;
import com.google.android.gms.internal.fp;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.a;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class fl {
    private final fp<fk> tM;
    private final Context mContext;
    private ContentProviderClient tN = null;
    private boolean tO = false;
    private HashMap<LocationListener, b> tP = new HashMap();

    public fl(Context context, fp<fk> fp2) {
        this.mContext = context;
        this.tM = fp2;
    }

    public Location getLastLocation() {
        this.tM.bB();
        try {
            return this.tM.bC().dp();
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestLocationUpdates(LocationRequest request, LocationListener listener, Looper looper) {
        this.tM.bB();
        if (looper == null) {
            du.c(Looper.myLooper(), "Can't create handler inside thread that has not called Looper.prepare()");
        }
        HashMap<LocationListener, b> hashMap = this.tP;
        synchronized (hashMap) {
            b b2 = this.tP.get(listener);
            if (b2 == null) {
                b2 = new b(listener, looper);
            }
            this.tP.put(listener, b2);
            try {
                this.tM.bC().a(request, b2, this.mContext.getPackageName());
            }
            catch (RemoteException remoteException) {
                throw new IllegalStateException(remoteException);
            }
        }
    }

    public void requestLocationUpdates(LocationRequest request, PendingIntent callbackIntent) {
        this.tM.bB();
        try {
            this.tM.bC().a(request, callbackIntent);
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocationUpdates(LocationListener listener) {
        this.tM.bB();
        du.c(listener, "Invalid null listener");
        HashMap<LocationListener, b> hashMap = this.tP;
        synchronized (hashMap) {
            b b2 = this.tP.remove(listener);
            if (this.tN != null && this.tP.isEmpty()) {
                this.tN.release();
                this.tN = null;
            }
            if (b2 != null) {
                b2.release();
                try {
                    this.tM.bC().a(b2);
                }
                catch (RemoteException remoteException) {
                    throw new IllegalStateException(remoteException);
                }
            }
        }
    }

    public void removeLocationUpdates(PendingIntent callbackIntent) {
        this.tM.bB();
        try {
            this.tM.bC().a(callbackIntent);
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public void setMockMode(boolean isMockMode) {
        this.tM.bB();
        try {
            this.tM.bC().setMockMode(isMockMode);
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
        this.tO = isMockMode;
    }

    public void setMockLocation(Location mockLocation) {
        this.tM.bB();
        try {
            this.tM.bC().setMockLocation(mockLocation);
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllListeners() {
        try {
            HashMap<LocationListener, b> hashMap = this.tP;
            synchronized (hashMap) {
                for (b b2 : this.tP.values()) {
                    if (b2 == null) continue;
                    this.tM.bC().a(b2);
                }
                this.tP.clear();
            }
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public void dq() {
        if (this.tO) {
            this.setMockMode(false);
        }
    }

    private static class a
    extends Handler {
        private final LocationListener tQ;

        public a(LocationListener locationListener) {
            this.tQ = locationListener;
        }

        public a(LocationListener locationListener, Looper looper) {
            super(looper);
            this.tQ = locationListener;
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    Location location = new Location((Location)msg.obj);
                    this.tQ.onLocationChanged(location);
                    break;
                }
                default: {
                    Log.e((String)"LocationClientHelper", (String)"unknown message in LocationHandler.handleMessage");
                }
            }
        }
    }

    private static class b
    extends a.a {
        private Handler tR;

        b(LocationListener locationListener, Looper looper) {
            this.tR = looper == null ? new a(locationListener) : new a(locationListener, looper);
        }

        public void onLocationChanged(Location location) {
            if (this.tR == null) {
                Log.e((String)"LocationClientHelper", (String)"Received a location in client after calling removeLocationUpdates.");
                return;
            }
            Message message = Message.obtain();
            message.what = 1;
            message.obj = location;
            this.tR.sendMessage(message);
        }

        public void release() {
            this.tR = null;
        }
    }
}

