/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.Intent;
import android.net.LocalSocket;
import android.net.LocalSocketAddress;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcelable;
import android.os.RemoteException;
import android.view.View;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesClient;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.a;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameBuffer;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerBuffer;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.achievement.AchievementBuffer;
import com.google.android.gms.games.achievement.b;
import com.google.android.gms.games.c;
import com.google.android.gms.games.f;
import com.google.android.gms.games.leaderboard.Leaderboard;
import com.google.android.gms.games.leaderboard.LeaderboardBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import com.google.android.gms.games.leaderboard.LeaderboardScoreBuffer;
import com.google.android.gms.games.leaderboard.h;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.InvitationBuffer;
import com.google.android.gms.games.multiplayer.OnInvitationReceivedListener;
import com.google.android.gms.games.multiplayer.ParticipantResult;
import com.google.android.gms.games.multiplayer.ParticipantUtils;
import com.google.android.gms.games.multiplayer.c;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessage;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessageReceivedListener;
import com.google.android.gms.games.multiplayer.realtime.RealTimeSocket;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.RoomConfig;
import com.google.android.gms.games.multiplayer.realtime.RoomStatusUpdateListener;
import com.google.android.gms.games.multiplayer.realtime.RoomUpdateListener;
import com.google.android.gms.games.multiplayer.realtime.a;
import com.google.android.gms.games.multiplayer.turnbased.LoadMatchesResponse;
import com.google.android.gms.games.multiplayer.turnbased.OnTurnBasedMatchUpdateReceivedListener;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchBuffer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchConfig;
import com.google.android.gms.games.multiplayer.turnbased.b;
import com.google.android.gms.internal.dk;
import com.google.android.gms.internal.dq;
import com.google.android.gms.internal.du;
import com.google.android.gms.internal.ew;
import com.google.android.gms.internal.ez;
import com.google.android.gms.internal.fa;
import com.google.android.gms.internal.fb;
import com.google.android.gms.internal.fc;
import com.google.android.gms.internal.fd;
import com.google.android.gms.internal.fe;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ex
extends dk<fc>
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener {
    private final String qM;
    private final String jD;
    private final Map<String, fe> qN;
    private PlayerEntity qO;
    private GameEntity qP;
    private final fd qQ;
    private boolean qR = false;
    private boolean qI = false;
    private int qJ;
    private final Binder qS;
    private final long qT;
    private final boolean qU;

    public ex(Context context, String string2, String string3, GooglePlayServicesClient.ConnectionCallbacks connectionCallbacks, GooglePlayServicesClient.OnConnectionFailedListener onConnectionFailedListener, String[] stringArray, int n2, View view, boolean bl2, boolean bl3, int n3) {
        super(context, connectionCallbacks, onConnectionFailedListener, stringArray);
        this.qM = string2;
        this.jD = du.f(string3);
        this.qS = new Binder();
        this.qN = new HashMap<String, fe>();
        this.qQ = fd.a(this, n2);
        this.setViewForPopups(view);
        this.qI = bl3;
        this.qJ = n3;
        this.qT = this.hashCode();
        this.qU = bl2;
        this.registerConnectionCallbacks(this);
        this.registerConnectionFailedListener(this);
    }

    @Override
    public void onConnected(Bundle connectionHint) {
        if (this.qR) {
            this.qQ.cZ();
            this.qR = false;
        }
    }

    @Override
    public void onDisconnected() {
    }

    @Override
    public void onConnectionFailed(ConnectionResult result) {
        this.qR = false;
    }

    public void setGravityForPopups(int gravity) {
        this.qQ.setGravity(gravity);
    }

    public void setViewForPopups(View gamesContentView) {
        this.qQ.e(gamesContentView);
    }

    @Override
    protected void a(String ... stringArray) {
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string2 = stringArray[i2];
            if (string2.equals("https://www.googleapis.com/auth/games")) {
                bl2 = true;
                continue;
            }
            if (!string2.equals("https://www.googleapis.com/auth/games.firstparty")) continue;
            bl3 = true;
        }
        if (bl3) {
            du.a(!bl2, String.format("Cannot have both %s and %s!", "https://www.googleapis.com/auth/games", "https://www.googleapis.com/auth/games.firstparty"));
        } else {
            du.a(bl2, String.format("Games APIs requires %s to function.", "https://www.googleapis.com/auth/games"));
        }
    }

    @Override
    public void connect() {
        this.cL();
        super.connect();
    }

    @Override
    public void disconnect() {
        this.qR = false;
        if (this.isConnected()) {
            try {
                fc fc2 = (fc)this.bC();
                fc2.cN();
                fc2.f(this.qT);
            }
            catch (RemoteException remoteException) {
                fa.a("GamesClientImpl", "Failed to notify client disconnect.");
            }
        }
        this.cM();
        super.disconnect();
    }

    @Override
    protected String am() {
        return "com.google.android.gms.games.service.START";
    }

    @Override
    protected String an() {
        return "com.google.android.gms.games.internal.IGamesService";
    }

    protected fc D(IBinder iBinder) {
        return fc.a.F(iBinder);
    }

    @Override
    public Bundle bc() {
        try {
            Bundle bundle = ((fc)this.bC()).bc();
            if (bundle != null) {
                bundle.setClassLoader(ex.class.getClassLoader());
            }
            return bundle;
        }
        catch (RemoteException remoteException) {
            fa.a("GamesClientImpl", "service died");
            return null;
        }
    }

    private void cL() {
        this.qO = null;
    }

    @Override
    protected void a(dq dq2, dk.d d2) throws RemoteException {
        String string2 = this.getContext().getResources().getConfiguration().locale.toString();
        Bundle bundle = new Bundle();
        bundle.putBoolean("com.google.android.gms.games.key.isHeadless", this.qU);
        bundle.putBoolean("com.google.android.gms.games.key.showConnectingPopup", this.qI);
        bundle.putInt("com.google.android.gms.games.key.connectingPopupGravity", this.qJ);
        dq2.a(d2, 4132500, this.getContext().getPackageName(), this.jD, this.bA(), this.qM, this.qQ.db(), string2, bundle);
    }

    public String getCurrentAccountName() {
        try {
            return ((fc)this.bC()).getCurrentAccountName();
        }
        catch (RemoteException remoteException) {
            fa.a("GamesClientImpl", "service died");
            return null;
        }
    }

    public String getCurrentPlayerId() {
        try {
            return ((fc)this.bC()).getCurrentPlayerId();
        }
        catch (RemoteException remoteException) {
            fa.a("GamesClientImpl", "service died");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Player getCurrentPlayer() {
        this.bB();
        ex ex2 = this;
        synchronized (ex2) {
            if (this.qO == null) {
                try {
                    PlayerBuffer playerBuffer = new PlayerBuffer(((fc)this.bC()).cV());
                    try {
                        if (playerBuffer.getCount() > 0) {
                            this.qO = (PlayerEntity)playerBuffer.get(0).freeze();
                        }
                        Object var4_4 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_5 = null;
                        playerBuffer.close();
                        throw throwable;
                    }
                    playerBuffer.close();
                    {
                    }
                }
                catch (RemoteException remoteException) {
                    fa.a("GamesClientImpl", "service died");
                }
            }
        }
        return this.qO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Game getCurrentGame() {
        this.bB();
        ex ex2 = this;
        synchronized (ex2) {
            if (this.qP == null) {
                try {
                    GameBuffer gameBuffer = new GameBuffer(((fc)this.bC()).cX());
                    try {
                        if (gameBuffer.getCount() > 0) {
                            this.qP = (GameEntity)gameBuffer.get(0).freeze();
                        }
                        Object var4_4 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_5 = null;
                        gameBuffer.close();
                        throw throwable;
                    }
                    gameBuffer.close();
                    {
                    }
                }
                catch (RemoteException remoteException) {
                    fa.a("GamesClientImpl", "service died");
                }
            }
        }
        return this.qP;
    }

    public void a(a.c<f.a> c2, String string2) {
        try {
            ((fc)this.bC()).c((fb)new ak(c2), string2);
        }
        catch (RemoteException remoteException) {
            fa.a("GamesClientImpl", "service died");
        }
    }

    public void a(a.c<f.a> c2, int n2, boolean bl2, boolean bl3) {
        try {
            ((fc)this.bC()).a((fb)new ak(c2), n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            fa.a("GamesClientImpl", "service died");
        }
    }

    public Intent getAllLeaderboardsIntent() {
        this.bB();
        Intent intent = new Intent("com.google.android.gms.games.VIEW_LEADERBOARDS");
        intent.putExtra("com.google.android.gms.games.GAME_PACKAGE_NAME", this.qM);
        intent.addFlags(0x4000000);
        return ez.c(intent);
    }

    public Intent getLeaderboardIntent(String leaderboardId) {
        this.bB();
        Intent intent = new Intent("com.google.android.gms.games.VIEW_LEADERBOARD_SCORES");
        intent.putExtra("com.google.android.gms.games.LEADERBOARD_ID", leaderboardId);
        intent.addFlags(0x4000000);
        return ez.c(intent);
    }

    public void a(a.c<h.a> c2, boolean bl2) {
        try {
            ((fc)this.bC()).c((fb)new t(c2), bl2);
        }
        catch (RemoteException remoteException) {
            fa.a("GamesClientImpl", "service died");
        }
    }

    public void a(a.c<h.a> c2, String string2, boolean bl2) {
        try {
            ((fc)this.bC()).c((fb)new t(c2), string2, bl2);
        }
        catch (RemoteException remoteException) {
            fa.a("GamesClientImpl", "service died");
        }
    }

    public void a(a.c<h.b> c2, String string2, String string3, int n2, int n3) {
        try {
            ((fc)this.bC()).a((fb)new ai(c2), string2, string3, n2, n3);
        }
        catch (RemoteException remoteException) {
            fa.a("GamesClientImpl", "service died");
        }
    }

    public void a(a.c<h.c> c2, String string2, int n2, int n3, int n4, boolean bl2) {
        try {
            ((fc)this.bC()).a(new r(c2), string2, n2, n3, n4, bl2);
        }
        catch (RemoteException remoteException) {
            fa.a("GamesClientImpl", "service died");
        }
    }

    public void b(a.c<h.c> c2, String string2, int n2, int n3, int n4, boolean bl2) {
        try {
            ((fc)this.bC()).b(new r(c2), string2, n2, n3, n4, bl2);
        }
        catch (RemoteException remoteException) {
            fa.a("GamesClientImpl", "service died");
        }
    }

    public void a(a.c<h.c> c2, LeaderboardScoreBuffer leaderboardScoreBuffer, int n2, int n3) {
        try {
            ((fc)this.bC()).a((fb)new r(c2), leaderboardScoreBuffer.de().df(), n2, n3);
        }
        catch (RemoteException remoteException) {
            fa.a("GamesClientImpl", "service died");
        }
    }

    public void a(a.c<h.d> c2, String string2, long l2, String string3) {
        try {
            aw aw2 = c2 == null ? null : new aw(c2);
            ((fc)this.bC()).a((fb)aw2, string2, l2, string3);
        }
        catch (RemoteException remoteException) {
            fa.a("GamesClientImpl", "service died");
        }
    }

    public Intent getAchievementsIntent() {
        this.bB();
        Intent intent = new Intent("com.google.android.gms.games.VIEW_ACHIEVEMENTS");
        intent.addFlags(0x4000000);
        return ez.c(intent);
    }

    public void b(a.c<b.a> c2, boolean bl2) {
        try {
            ((fc)this.bC()).b((fb)new f(c2), bl2);
        }
        catch (RemoteException remoteException) {
            fa.a("GamesClientImpl", "service died");
        }
    }

    public void b(a.c<b.b> c2, String string2) {
        try {
            d d2 = c2 == null ? null : new d(c2);
            ((fc)this.bC()).a((fb)d2, string2, this.qQ.db(), this.qQ.da());
        }
        catch (RemoteException remoteException) {
            fa.a("GamesClientImpl", "service died");
        }
    }

    public void c(a.c<b.b> c2, String string2) {
        try {
            d d2 = c2 == null ? null : new d(c2);
            ((fc)this.bC()).b((fb)d2, string2, this.qQ.db(), this.qQ.da());
        }
        catch (RemoteException remoteException) {
            fa.a("GamesClientImpl", "service died");
        }
    }

    public void a(a.c<b.b> c2, String string2, int n2) {
        try {
            d d2 = c2 == null ? null : new d(c2);
            ((fc)this.bC()).a((fb)d2, string2, n2, this.qQ.db(), this.qQ.da());
        }
        catch (RemoteException remoteException) {
            fa.a("GamesClientImpl", "service died");
        }
    }

    public void b(a.c<b.b> c2, String string2, int n2) {
        try {
            d d2 = c2 == null ? null : new d(c2);
            ((fc)this.bC()).b((fb)d2, string2, n2, this.qQ.db(), this.qQ.da());
        }
        catch (RemoteException remoteException) {
            fa.a("GamesClientImpl", "service died");
        }
    }

    public Intent getMatchInboxIntent() {
        this.bB();
        Intent intent = new Intent("com.google.android.gms.games.SHOW_MULTIPLAYER_INBOX");
        intent.putExtra("com.google.android.gms.games.GAME_PACKAGE_NAME", this.qM);
        return ez.c(intent);
    }

    public Intent getInvitationInboxIntent() {
        this.bB();
        Intent intent = new Intent("com.google.android.gms.games.SHOW_INVITATIONS");
        intent.putExtra("com.google.android.gms.games.GAME_PACKAGE_NAME", this.qM);
        return ez.c(intent);
    }

    public void registerInvitationListener(OnInvitationReceivedListener listener) {
        try {
            l l2 = new l(listener);
            ((fc)this.bC()).a((fb)l2, this.qT);
        }
        catch (RemoteException remoteException) {
            fa.a("GamesClientImpl", "service died");
        }
    }

    public void unregisterInvitationListener() {
        try {
            ((fc)this.bC()).g(this.qT);
        }
        catch (RemoteException remoteException) {
            fa.a("GamesClientImpl", "service died");
        }
    }

    public void registerMatchUpdateListener(OnTurnBasedMatchUpdateReceivedListener listener) {
        try {
            x x2 = new x(listener);
            ((fc)this.bC()).b((fb)x2, this.qT);
        }
        catch (RemoteException remoteException) {
            fa.a("GamesClientImpl", "service died");
        }
    }

    public void unregisterMatchUpdateListener() {
        try {
            ((fc)this.bC()).h(this.qT);
        }
        catch (RemoteException remoteException) {
            fa.a("GamesClientImpl", "service died");
        }
    }

    public Intent getSelectPlayersIntent(int minPlayers, int maxPlayers, boolean allowAutomatch) {
        this.bB();
        Intent intent = new Intent("com.google.android.gms.games.SELECT_PLAYERS");
        intent.putExtra("com.google.android.gms.games.MIN_SELECTIONS", minPlayers);
        intent.putExtra("com.google.android.gms.games.MAX_SELECTIONS", maxPlayers);
        intent.putExtra("com.google.android.gms.games.SHOW_AUTOMATCH", allowAutomatch);
        return ez.c(intent);
    }

    public Intent getPlayerSearchIntent() {
        this.bB();
        Intent intent = new Intent("com.google.android.gms.games.PLAYER_SEARCH");
        return ez.c(intent);
    }

    public Intent getRealTimeWaitingRoomIntent(Room room, int minParticipantsToStart) {
        this.bB();
        Intent intent = new Intent("com.google.android.gms.games.SHOW_REAL_TIME_WAITING_ROOM");
        du.c(room, "Room parameter must not be null");
        intent.putExtra("room", (Parcelable)room.freeze());
        du.a(minParticipantsToStart >= 0, "minParticipantsToStart must be >= 0");
        intent.putExtra("com.google.android.gms.games.MIN_PARTICIPANTS_TO_START", minParticipantsToStart);
        return ez.c(intent);
    }

    public Intent getSettingsIntent() {
        this.bB();
        Intent intent = new Intent("com.google.android.gms.games.SHOW_SETTINGS");
        intent.putExtra("com.google.android.gms.games.GAME_PACKAGE_NAME", this.qM);
        intent.addFlags(0x4000000);
        return ez.c(intent);
    }

    public void d(a.c<c.a> c2) {
        try {
            ((fc)this.bC()).d(new j(c2));
        }
        catch (RemoteException remoteException) {
            fa.a("GamesClientImpl", "service died");
        }
    }

    public void b(a.c<Status> c2) {
        try {
            ((fc)this.bC()).a(new au(c2));
        }
        catch (RemoteException remoteException) {
            fa.a("GamesClientImpl", "service died");
        }
    }

    public String getAppId() {
        try {
            return ((fc)this.bC()).getAppId();
        }
        catch (RemoteException remoteException) {
            fa.a("GamesClientImpl", "service died");
            return null;
        }
    }

    public void e(a.c<c.a> c2) {
        try {
            ((fc)this.bC()).e(new o(c2));
        }
        catch (RemoteException remoteException) {
            fa.a("GamesClientImpl", "service died");
        }
    }

    public void h(String string2, int n2) {
        try {
            ((fc)this.bC()).h(string2, n2);
        }
        catch (RemoteException remoteException) {
            fa.a("GamesClientImpl", "service died");
        }
    }

    public void i(String string2, int n2) {
        try {
            ((fc)this.bC()).i(string2, n2);
        }
        catch (RemoteException remoteException) {
            fa.a("GamesClientImpl", "service died");
        }
    }

    public void a(a.c<b.b> c2, TurnBasedMatchConfig turnBasedMatchConfig) {
        try {
            ((fc)this.bC()).a((fb)new bb(c2), turnBasedMatchConfig.getVariant(), turnBasedMatchConfig.getMinPlayers(), turnBasedMatchConfig.getInvitedPlayerIds(), turnBasedMatchConfig.getAutoMatchCriteria());
        }
        catch (RemoteException remoteException) {
            fa.a("GamesClientImpl", "service died");
        }
    }

    public void d(a.c<b.b> c2, String string2) {
        try {
            ((fc)this.bC()).n(new bb(c2), string2);
        }
        catch (RemoteException remoteException) {
            fa.a("GamesClientImpl", "service died");
        }
    }

    public void e(a.c<b.b> c2, String string2) {
        try {
            ((fc)this.bC()).o(new bb(c2), string2);
        }
        catch (RemoteException remoteException) {
            fa.a("GamesClientImpl", "service died");
        }
    }

    public int getMaxTurnBasedMatchDataSize() {
        int n2 = 2;
        try {
            n2 = ((fc)this.bC()).getMaxTurnBasedMatchDataSize();
        }
        catch (RemoteException remoteException) {
            fa.a("GamesClientImpl", "service died");
        }
        return n2;
    }

    public void a(a.c<b.f> c2, String string2, byte[] byArray, String string3, ParticipantResult[] participantResultArray) {
        try {
            ((fc)this.bC()).a((fb)new bh(c2), string2, byArray, string3, participantResultArray);
        }
        catch (RemoteException remoteException) {
            fa.a("GamesClientImpl", "service died");
        }
    }

    public void a(a.c<b.f> c2, String string2, byte[] byArray, ParticipantResult[] participantResultArray) {
        try {
            ((fc)this.bC()).a((fb)new bh(c2), string2, byArray, participantResultArray);
        }
        catch (RemoteException remoteException) {
            fa.a("GamesClientImpl", "service died");
        }
    }

    public void f(a.c<b.c> c2, String string2) {
        try {
            ((fc)this.bC()).q(new bd(c2), string2);
        }
        catch (RemoteException remoteException) {
            fa.a("GamesClientImpl", "service died");
        }
    }

    public void a(a.c<b.c> c2, String string2, String string3) {
        try {
            ((fc)this.bC()).d((fb)new bd(c2), string2, string3);
        }
        catch (RemoteException remoteException) {
            fa.a("GamesClientImpl", "service died");
        }
    }

    public void g(a.c<b.a> c2, String string2) {
        try {
            ((fc)this.bC()).p(new az(c2), string2);
        }
        catch (RemoteException remoteException) {
            fa.a("GamesClientImpl", "service died");
        }
    }

    public void dismissTurnBasedMatch(String matchId) {
        try {
            ((fc)this.bC()).X(matchId);
        }
        catch (RemoteException remoteException) {
            fa.a("GamesClientImpl", "service died");
        }
    }

    public void a(a.c<b.e> c2, int[] nArray) {
        try {
            ((fc)this.bC()).a((fb)new bj(c2), nArray);
        }
        catch (RemoteException remoteException) {
            fa.a("GamesClientImpl", "service died");
        }
    }

    public void h(a.c<b.d> c2, String string2) {
        try {
            ((fc)this.bC()).r(new bf(c2), string2);
        }
        catch (RemoteException remoteException) {
            fa.a("GamesClientImpl", "service died");
        }
    }

    public void createRoom(RoomConfig config) {
        try {
            aq aq2 = new aq(config.getRoomUpdateListener(), config.getRoomStatusUpdateListener(), config.getMessageReceivedListener());
            ((fc)this.bC()).a((fb)aq2, (IBinder)this.qS, config.getVariant(), config.getInvitedPlayerIds(), config.getAutoMatchCriteria(), config.isSocketEnabled(), this.qT);
        }
        catch (RemoteException remoteException) {
            fa.a("GamesClientImpl", "service died");
        }
    }

    public void joinRoom(RoomConfig config) {
        try {
            aq aq2 = new aq(config.getRoomUpdateListener(), config.getRoomStatusUpdateListener(), config.getMessageReceivedListener());
            ((fc)this.bC()).a((fb)aq2, (IBinder)this.qS, config.getInvitationId(), config.isSocketEnabled(), this.qT);
        }
        catch (RemoteException remoteException) {
            fa.a("GamesClientImpl", "service died");
        }
    }

    public void leaveRoom(RoomUpdateListener listener, String roomId) {
        try {
            ((fc)this.bC()).e(new aq(listener), roomId);
            this.cM();
        }
        catch (RemoteException remoteException) {
            fa.a("GamesClientImpl", "service died");
        }
    }

    public int a(a.a a2, byte[] byArray, String string2, String string3) {
        try {
            return ((fc)this.bC()).a((fb)new an(a2), byArray, string2, string3);
        }
        catch (RemoteException remoteException) {
            fa.a("GamesClientImpl", "service died");
            return -1;
        }
    }

    public int a(byte[] byArray, String string2, String[] stringArray) {
        du.c(stringArray, "Participant IDs must not be null");
        try {
            return ((fc)this.bC()).b(byArray, string2, stringArray);
        }
        catch (RemoteException remoteException) {
            fa.a("GamesClientImpl", "service died");
            return -1;
        }
    }

    public int sendUnreliableRealTimeMessageToAll(byte[] messageData, String roomId) {
        try {
            return ((fc)this.bC()).b(messageData, roomId, null);
        }
        catch (RemoteException remoteException) {
            fa.a("GamesClientImpl", "service died");
            return -1;
        }
    }

    public RealTimeSocket getRealTimeSocketForParticipant(String roomId, String participantId) {
        if (participantId == null || !ParticipantUtils.Y(participantId)) {
            throw new IllegalArgumentException("Bad participant ID");
        }
        fe fe2 = this.qN.get(participantId);
        if (fe2 == null || fe2.isClosed()) {
            return this.R(participantId);
        }
        return fe2;
    }

    private fe R(String string2) {
        try {
            String string3 = ((fc)this.bC()).T(string2);
            if (string3 == null) {
                return null;
            }
            LocalSocket localSocket = new LocalSocket();
            try {
                localSocket.connect(new LocalSocketAddress(string3));
            }
            catch (IOException iOException) {
                fa.b("GamesClientImpl", "connect() call failed on socket: " + iOException.getMessage());
                return null;
            }
            fe fe2 = new fe(localSocket, string2);
            this.qN.put(string2, fe2);
            return fe2;
        }
        catch (RemoteException remoteException) {
            fa.b("GamesClientImpl", "Unable to create socket. Service died.");
            return null;
        }
    }

    public void clearNotifications(int notificationTypes) {
        try {
            ((fc)this.bC()).clearNotifications(notificationTypes);
        }
        catch (RemoteException remoteException) {
            fa.a("GamesClientImpl", "service died");
        }
    }

    private void cM() {
        for (fe fe2 : this.qN.values()) {
            try {
                fe2.close();
            }
            catch (IOException iOException) {
                fa.a("GamesClientImpl", "IOException:", iOException);
            }
        }
        this.qN.clear();
    }

    public void a(IBinder iBinder, Bundle bundle) {
        if (this.isConnected()) {
            try {
                ((fc)this.bC()).a(iBinder, bundle);
            }
            catch (RemoteException remoteException) {
                fa.a("GamesClientImpl", "service died");
            }
        }
    }

    public void cN() {
        if (this.isConnected()) {
            try {
                ((fc)this.bC()).cN();
            }
            catch (RemoteException remoteException) {
                fa.a("GamesClientImpl", "service died");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Room D(DataHolder dataHolder) {
        com.google.android.gms.games.multiplayer.realtime.b b2 = new com.google.android.gms.games.multiplayer.realtime.b(dataHolder);
        Room room = null;
        try {
            if (b2.getCount() > 0) {
                room = (Room)((Room)b2.get(0)).freeze();
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            b2.close();
            throw throwable;
        }
        b2.close();
        return room;
    }

    @Override
    protected void a(int n2, IBinder iBinder, Bundle bundle) {
        if (n2 == 0 && bundle != null) {
            this.qR = bundle.getBoolean("show_welcome_popup");
        }
        super.a(n2, iBinder, bundle);
    }

    @Override
    protected /* synthetic */ IInterface p(IBinder iBinder) {
        return this.D(iBinder);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class av
    extends dk.b<a.c<Status>> {
        private final Status jP;

        public av(a.c<Status> c2, Status status) {
            super(c2);
            this.jP = status;
        }

        public void c(a.c<Status> c2) {
            c2.a(this.jP);
        }

        @Override
        protected void aQ() {
        }

        @Override
        public /* synthetic */ void b(Object object) {
            this.c((a.c)object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class am
    extends dk.b<a.a> {
        private final int ka;
        private final String rp;
        private final int rq;

        am(a.a a2, int n2, int n3, String string2) {
            super(a2);
            this.ka = n2;
            this.rq = n3;
            this.rp = string2;
        }

        public void a(a.a a2) {
            if (a2 != null) {
                a2.onRealTimeMessageSent(this.ka, this.rq, this.rp);
            }
        }

        @Override
        protected void aQ() {
        }

        @Override
        public /* synthetic */ void b(Object object) {
            this.a((a.a)object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class z
    extends dk.b<RealTimeMessageReceivedListener> {
        private final RealTimeMessage rl;

        z(RealTimeMessageReceivedListener realTimeMessageReceivedListener, RealTimeMessage realTimeMessage) {
            super(realTimeMessageReceivedListener);
            this.rl = realTimeMessage;
        }

        public void a(RealTimeMessageReceivedListener realTimeMessageReceivedListener) {
            if (realTimeMessageReceivedListener != null) {
                realTimeMessageReceivedListener.onRealTimeMessageReceived(this.rl);
            }
        }

        @Override
        protected void aQ() {
        }

        @Override
        public /* synthetic */ void b(Object object) {
            this.a((RealTimeMessageReceivedListener)object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ab
    extends dk.b<RoomStatusUpdateListener> {
        private final String rm;

        ab(RoomStatusUpdateListener roomStatusUpdateListener, String string2) {
            super(roomStatusUpdateListener);
            this.rm = string2;
        }

        public void a(RoomStatusUpdateListener roomStatusUpdateListener) {
            if (roomStatusUpdateListener != null) {
                roomStatusUpdateListener.onP2PDisconnected(this.rm);
            }
        }

        @Override
        protected void aQ() {
        }

        @Override
        public /* synthetic */ void b(Object object) {
            this.a((RoomStatusUpdateListener)object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class aa
    extends dk.b<RoomStatusUpdateListener> {
        private final String rm;

        aa(RoomStatusUpdateListener roomStatusUpdateListener, String string2) {
            super(roomStatusUpdateListener);
            this.rm = string2;
        }

        public void a(RoomStatusUpdateListener roomStatusUpdateListener) {
            if (roomStatusUpdateListener != null) {
                roomStatusUpdateListener.onP2PConnected(this.rm);
            }
        }

        @Override
        protected void aQ() {
        }

        @Override
        public /* synthetic */ void b(Object object) {
            this.a((RoomStatusUpdateListener)object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ae
    extends a {
        ae(RoomStatusUpdateListener roomStatusUpdateListener, DataHolder dataHolder, String[] stringArray) {
            super(roomStatusUpdateListener, dataHolder, stringArray);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersDisconnected(room, arrayList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ac
    extends a {
        ac(RoomStatusUpdateListener roomStatusUpdateListener, DataHolder dataHolder, String[] stringArray) {
            super(roomStatusUpdateListener, dataHolder, stringArray);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersConnected(room, arrayList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ad
    extends a {
        ad(RoomStatusUpdateListener roomStatusUpdateListener, DataHolder dataHolder, String[] stringArray) {
            super(roomStatusUpdateListener, dataHolder, stringArray);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerDeclined(room, arrayList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ah
    extends a {
        ah(RoomStatusUpdateListener roomStatusUpdateListener, DataHolder dataHolder, String[] stringArray) {
            super(roomStatusUpdateListener, dataHolder, stringArray);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerLeft(room, arrayList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ag
    extends a {
        ag(RoomStatusUpdateListener roomStatusUpdateListener, DataHolder dataHolder, String[] stringArray) {
            super(roomStatusUpdateListener, dataHolder, stringArray);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerJoined(room, arrayList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class af
    extends a {
        af(RoomStatusUpdateListener roomStatusUpdateListener, DataHolder dataHolder, String[] stringArray) {
            super(roomStatusUpdateListener, dataHolder, stringArray);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerInvitedToRoom(room, arrayList);
        }
    }

    final class i
    extends c {
        i(RoomStatusUpdateListener roomStatusUpdateListener, DataHolder dataHolder) {
            super(roomStatusUpdateListener, dataHolder);
        }

        public void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onDisconnectedFromRoom(room);
        }
    }

    final class h
    extends c {
        h(RoomStatusUpdateListener roomStatusUpdateListener, DataHolder dataHolder) {
            super(roomStatusUpdateListener, dataHolder);
        }

        public void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onConnectedToRoom(room);
        }
    }

    final class ap
    extends c {
        ap(RoomStatusUpdateListener roomStatusUpdateListener, DataHolder dataHolder) {
            super(roomStatusUpdateListener, dataHolder);
        }

        public void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomAutoMatching(room);
        }
    }

    final class as
    extends c {
        as(RoomStatusUpdateListener roomStatusUpdateListener, DataHolder dataHolder) {
            super(roomStatusUpdateListener, dataHolder);
        }

        public void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomConnecting(room);
        }
    }

    final class ar
    extends b {
        ar(RoomUpdateListener roomUpdateListener, DataHolder dataHolder) {
            super(roomUpdateListener, dataHolder);
        }

        public void a(RoomUpdateListener roomUpdateListener, Room room, int n2) {
            roomUpdateListener.onRoomConnected(n2, room);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class v
    extends dk.b<RoomUpdateListener> {
        private final int ka;
        private final String rh;

        v(RoomUpdateListener roomUpdateListener, int n2, String string2) {
            super(roomUpdateListener);
            this.ka = n2;
            this.rh = string2;
        }

        public void a(RoomUpdateListener roomUpdateListener) {
            roomUpdateListener.onLeftRoom(this.ka, this.rh);
        }

        @Override
        protected void aQ() {
        }

        @Override
        public /* synthetic */ void b(Object object) {
            this.a((RoomUpdateListener)object);
        }
    }

    final class q
    extends b {
        public q(RoomUpdateListener roomUpdateListener, DataHolder dataHolder) {
            super(roomUpdateListener, dataHolder);
        }

        public void a(RoomUpdateListener roomUpdateListener, Room room, int n2) {
            roomUpdateListener.onJoinedRoom(n2, room);
        }
    }

    final class at
    extends b {
        public at(RoomUpdateListener roomUpdateListener, DataHolder dataHolder) {
            super(roomUpdateListener, dataHolder);
        }

        public void a(RoomUpdateListener roomUpdateListener, Room room, int n2) {
            roomUpdateListener.onRoomCreated(n2, room);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class a
    extends c {
        private final ArrayList<String> qV;

        a(RoomStatusUpdateListener roomStatusUpdateListener, DataHolder dataHolder, String[] stringArray) {
            super(roomStatusUpdateListener, dataHolder);
            this.qV = new ArrayList();
            int n2 = stringArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.qV.add(stringArray[i2]);
            }
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            this.a(roomStatusUpdateListener, room, this.qV);
        }

        protected abstract void a(RoomStatusUpdateListener var1, Room var2, ArrayList<String> var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class c
    extends dk.c<RoomStatusUpdateListener> {
        c(RoomStatusUpdateListener roomStatusUpdateListener, DataHolder dataHolder) {
            super(roomStatusUpdateListener, dataHolder);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, DataHolder dataHolder) {
            this.a(roomStatusUpdateListener, ex.this.D(dataHolder));
        }

        protected abstract void a(RoomStatusUpdateListener var1, Room var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class b
    extends dk.c<RoomUpdateListener> {
        b(RoomUpdateListener roomUpdateListener, DataHolder dataHolder) {
            super(roomUpdateListener, dataHolder);
        }

        @Override
        protected void a(RoomUpdateListener roomUpdateListener, DataHolder dataHolder) {
            this.a(roomUpdateListener, ex.this.D(dataHolder), dataHolder.getStatusCode());
        }

        protected abstract void a(RoomUpdateListener var1, Room var2, int var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ba
    extends dk.b<a.c<b.a>>
    implements b.a {
        private final Status jP;
        private final String rx;

        ba(a.c<b.a> c2, Status status, String string2) {
            super(c2);
            this.jP = status;
            this.rx = string2;
        }

        public void c(a.c<b.a> c2) {
            c2.a(this);
        }

        @Override
        protected void aQ() {
        }

        @Override
        public Status getStatus() {
            return this.jP;
        }

        @Override
        public String getMatchId() {
            return this.rx;
        }

        @Override
        public /* synthetic */ void b(Object object) {
            this.c((a.c)object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class be
    extends ay<a.c<b.c>>
    implements b.c {
        be(a.c<b.c> c2, DataHolder dataHolder) {
            super(ex.this, c2, dataHolder);
        }

        @Override
        protected void f(a.c<b.c> c2) {
            c2.a(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class bi
    extends ay<a.c<b.f>>
    implements b.f {
        bi(a.c<b.f> c2, DataHolder dataHolder) {
            super(ex.this, c2, dataHolder);
        }

        @Override
        protected void f(a.c<b.f> c2) {
            c2.a(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class bc
    extends ay<a.c<b.b>>
    implements b.b {
        bc(a.c<b.b> c2, DataHolder dataHolder) {
            super(ex.this, c2, dataHolder);
        }

        @Override
        protected void f(a.c<b.b> c2) {
            c2.a(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class bg
    extends ay<a.c<b.d>>
    implements b.d {
        bg(a.c<b.d> c2, DataHolder dataHolder) {
            super(ex.this, c2, dataHolder);
        }

        @Override
        protected void f(a.c<b.d> c2) {
            c2.a(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class ay<T extends a.c<?>>
    extends ao<T> {
        final TurnBasedMatch rk;
        final /* synthetic */ ex qW;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ay(T t2, DataHolder dataHolder) {
            this.qW = var1_1;
            super((ex)var1_1, t2, dataHolder);
            TurnBasedMatchBuffer turnBasedMatchBuffer = new TurnBasedMatchBuffer(dataHolder);
            try {
                this.rk = turnBasedMatchBuffer.getCount() > 0 ? (TurnBasedMatch)((TurnBasedMatch)turnBasedMatchBuffer.get(0)).freeze() : null;
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                turnBasedMatchBuffer.close();
                throw throwable;
            }
            turnBasedMatchBuffer.close();
        }

        @Override
        protected void a(T t2, DataHolder dataHolder) {
            this.f(t2);
        }

        abstract void f(T var1);

        public TurnBasedMatch cT() {
            return this.rk;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ax
    extends ao<a.c<h.d>>
    implements h.d {
        private final com.google.android.gms.games.leaderboard.i rv;

        public ax(a.c<h.d> c2, DataHolder dataHolder) {
            super(ex.this, c2, dataHolder);
            this.rv = new com.google.android.gms.games.leaderboard.i(dataHolder);
        }

        @Override
        public void a(a.c<h.d> c2, DataHolder dataHolder) {
            c2.a(this);
        }

        @Override
        public com.google.android.gms.games.leaderboard.i cS() {
            return this.rv;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class al
    extends ao<a.c<f.a>>
    implements f.a {
        private final PlayerBuffer ro;

        al(a.c<f.a> c2, DataHolder dataHolder) {
            super(ex.this, c2, dataHolder);
            this.ro = new PlayerBuffer(dataHolder);
        }

        @Override
        protected void a(a.c<f.a> c2, DataHolder dataHolder) {
            c2.a(this);
        }

        @Override
        public PlayerBuffer cJ() {
            return this.ro;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class bk
    extends dk.b<a.c<b.e>>
    implements b.e {
        private final Status jP;
        private final Bundle rD;
        private final LoadMatchesResponse rE;

        bk(a.c<b.e> c2, Status status, Bundle bundle) {
            super(c2);
            this.jP = status;
            this.rD = bundle;
            this.rE = new LoadMatchesResponse(bundle);
        }

        protected void c(a.c<b.e> c2) {
            c2.a(this);
        }

        @Override
        protected void aQ() {
            this.release();
        }

        @Override
        public Status getStatus() {
            return this.jP;
        }

        @Override
        public void release() {
            for (String string2 : this.rD.keySet()) {
                DataHolder dataHolder = (DataHolder)this.rD.getParcelable(string2);
                if (dataHolder == null) continue;
                dataHolder.close();
            }
        }

        @Override
        public LoadMatchesResponse cU() {
            return this.rE;
        }

        @Override
        protected /* synthetic */ void b(Object object) {
            this.c((a.c)object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class w
    extends dk.b<OnTurnBasedMatchUpdateReceivedListener> {
        private final String ri;

        w(OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener, String string2) {
            super(onTurnBasedMatchUpdateReceivedListener);
            this.ri = string2;
        }

        protected void a(OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener) {
            onTurnBasedMatchUpdateReceivedListener.onTurnBasedMatchRemoved(this.ri);
        }

        @Override
        protected void aQ() {
        }

        @Override
        protected /* synthetic */ void b(Object object) {
            this.a((OnTurnBasedMatchUpdateReceivedListener)object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class y
    extends dk.b<OnTurnBasedMatchUpdateReceivedListener> {
        private final TurnBasedMatch rk;

        y(OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener, TurnBasedMatch turnBasedMatch) {
            super(onTurnBasedMatchUpdateReceivedListener);
            this.rk = turnBasedMatch;
        }

        protected void a(OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener) {
            onTurnBasedMatchUpdateReceivedListener.onTurnBasedMatchReceived(this.rk);
        }

        @Override
        protected void aQ() {
        }

        @Override
        protected /* synthetic */ void b(Object object) {
            this.a((OnTurnBasedMatchUpdateReceivedListener)object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class n
    extends dk.b<OnInvitationReceivedListener> {
        private final String rc;

        n(OnInvitationReceivedListener onInvitationReceivedListener, String string2) {
            super(onInvitationReceivedListener);
            this.rc = string2;
        }

        protected void a(OnInvitationReceivedListener onInvitationReceivedListener) {
            onInvitationReceivedListener.onInvitationRemoved(this.rc);
        }

        @Override
        protected void aQ() {
        }

        @Override
        protected /* synthetic */ void b(Object object) {
            this.a((OnInvitationReceivedListener)object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class m
    extends dk.b<OnInvitationReceivedListener> {
        private final Invitation rb;

        m(OnInvitationReceivedListener onInvitationReceivedListener, Invitation invitation) {
            super(onInvitationReceivedListener);
            this.rb = invitation;
        }

        protected void a(OnInvitationReceivedListener onInvitationReceivedListener) {
            onInvitationReceivedListener.onInvitationReceived(this.rb);
        }

        @Override
        protected void aQ() {
        }

        @Override
        protected /* synthetic */ void b(Object object) {
            this.a((OnInvitationReceivedListener)object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class p
    extends ao<a.c<c.a>>
    implements c.a {
        private final InvitationBuffer rd;

        p(a.c<c.a> c2, DataHolder dataHolder) {
            super(ex.this, c2, dataHolder);
            this.rd = new InvitationBuffer(dataHolder);
        }

        @Override
        protected void a(a.c<c.a> c2, DataHolder dataHolder) {
            c2.a(this);
        }

        @Override
        public InvitationBuffer getInvitations() {
            return this.rd;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class aj
    extends dk.c<a.c<h.b>>
    implements h.b {
        private final Status jP;
        private final com.google.android.gms.games.leaderboard.d rn;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        aj(a.c<h.b> c2, DataHolder dataHolder) {
            super(c2, dataHolder);
            this.jP = new Status(dataHolder.getStatusCode());
            LeaderboardScoreBuffer leaderboardScoreBuffer = new LeaderboardScoreBuffer(dataHolder);
            try {
                this.rn = leaderboardScoreBuffer.getCount() > 0 ? (com.google.android.gms.games.leaderboard.d)leaderboardScoreBuffer.get(0).freeze() : null;
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                leaderboardScoreBuffer.close();
                throw throwable;
            }
            leaderboardScoreBuffer.close();
        }

        @Override
        protected void a(a.c<h.b> c2, DataHolder dataHolder) {
            c2.a(this);
        }

        @Override
        public Status getStatus() {
            return this.jP;
        }

        @Override
        public LeaderboardScore cR() {
            return this.rn;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class s
    extends ao<a.c<h.c>>
    implements h.c {
        private final com.google.android.gms.games.leaderboard.a re;
        private final LeaderboardScoreBuffer rf;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        s(a.c<h.c> c2, DataHolder dataHolder, DataHolder dataHolder2) {
            super(ex.this, c2, dataHolder2);
            LeaderboardBuffer leaderboardBuffer = new LeaderboardBuffer(dataHolder);
            try {
                this.re = leaderboardBuffer.getCount() > 0 ? (com.google.android.gms.games.leaderboard.a)((Leaderboard)leaderboardBuffer.get(0)).freeze() : null;
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                leaderboardBuffer.close();
                throw throwable;
            }
            leaderboardBuffer.close();
            this.rf = new LeaderboardScoreBuffer(dataHolder2);
        }

        @Override
        protected void a(a.c<h.c> c2, DataHolder dataHolder) {
            c2.a(this);
        }

        @Override
        public Leaderboard cO() {
            return this.re;
        }

        @Override
        public LeaderboardScoreBuffer cP() {
            return this.rf;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class u
    extends ao<a.c<h.a>>
    implements h.a {
        private final LeaderboardBuffer rg;

        u(a.c<h.a> c2, DataHolder dataHolder) {
            super(ex.this, c2, dataHolder);
            this.rg = new LeaderboardBuffer(dataHolder);
        }

        @Override
        protected void a(a.c<h.a> c2, DataHolder dataHolder) {
            c2.a(this);
        }

        @Override
        public LeaderboardBuffer cQ() {
            return this.rg;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class k
    extends ao<a.c<c.a>>
    implements c.a {
        private final GameBuffer qZ;

        k(a.c<c.a> c2, DataHolder dataHolder) {
            super(ex.this, c2, dataHolder);
            this.qZ = new GameBuffer(dataHolder);
        }

        @Override
        protected void a(a.c<c.a> c2, DataHolder dataHolder) {
            c2.a(this);
        }

        @Override
        public GameBuffer cI() {
            return this.qZ;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class e
    extends dk.b<a.c<b.b>>
    implements b.b {
        private final Status jP;
        private final String qX;

        e(a.c<b.b> c2, int n2, String string2) {
            super(c2);
            this.jP = new Status(n2);
            this.qX = string2;
        }

        protected void c(a.c<b.b> c2) {
            c2.a(this);
        }

        @Override
        protected void aQ() {
        }

        @Override
        public Status getStatus() {
            return this.jP;
        }

        @Override
        public String getAchievementId() {
            return this.qX;
        }

        @Override
        protected /* synthetic */ void b(Object object) {
            this.c((a.c)object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class g
    extends ao<a.c<b.a>>
    implements b.a {
        private final AchievementBuffer qY;

        g(a.c<b.a> c2, DataHolder dataHolder) {
            super(ex.this, c2, dataHolder);
            this.qY = new AchievementBuffer(dataHolder);
        }

        @Override
        protected void a(a.c<b.a> c2, DataHolder dataHolder) {
            c2.a(this);
        }

        @Override
        public AchievementBuffer cK() {
            return this.qY;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class ao<R extends a.c<?>>
    extends dk.c<R>
    implements Releasable,
    Result {
        final Status jP;
        final DataHolder lb;
        final /* synthetic */ ex qW;

        public ao(R r2, DataHolder dataHolder) {
            this.qW = var1_1;
            super(r2, dataHolder);
            this.jP = new Status(dataHolder.getStatusCode());
            this.lb = dataHolder;
        }

        @Override
        public Status getStatus() {
            return this.jP;
        }

        @Override
        public void release() {
            if (this.lb != null) {
                this.lb.close();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class au
    extends ew {
        private final a.c<Status> jN;

        public au(a.c<Status> c2) {
            this.jN = du.c(c2, "Holder must not be null");
        }

        @Override
        public void onSignOutComplete() {
            Status status = new Status(0);
            ex.this.a(new av(this.jN, status));
        }
    }

    final class an
    extends ew {
        final a.a rr;

        public an(a.a a2) {
            this.rr = a2;
        }

        public void b(int n2, int n3, String string2) {
            ex.this.a(new am(this.rr, n2, n3, string2));
        }
    }

    final class aq
    extends ew {
        private final RoomUpdateListener rs;
        private final RoomStatusUpdateListener rt;
        private final RealTimeMessageReceivedListener ru;

        public aq(RoomUpdateListener roomUpdateListener) {
            this.rs = du.c(roomUpdateListener, "Callbacks must not be null");
            this.rt = null;
            this.ru = null;
        }

        public aq(RoomUpdateListener roomUpdateListener, RoomStatusUpdateListener roomStatusUpdateListener, RealTimeMessageReceivedListener realTimeMessageReceivedListener) {
            this.rs = du.c(roomUpdateListener, "Callbacks must not be null");
            this.rt = roomStatusUpdateListener;
            this.ru = realTimeMessageReceivedListener;
        }

        public void s(DataHolder dataHolder) {
            ex.this.a(new at(this.rs, dataHolder));
        }

        public void t(DataHolder dataHolder) {
            ex.this.a(new q(this.rs, dataHolder));
        }

        public void onLeftRoom(int statusCode, String externalRoomId) {
            ex.this.a(new v(this.rs, statusCode, externalRoomId));
        }

        public void w(DataHolder dataHolder) {
            ex.this.a(new ar(this.rs, dataHolder));
        }

        public void u(DataHolder dataHolder) {
            ex.this.a(new as(this.rt, dataHolder));
        }

        public void v(DataHolder dataHolder) {
            ex.this.a(new ap(this.rt, dataHolder));
        }

        public void x(DataHolder dataHolder) {
            ex.this.a(new h(this.rt, dataHolder));
        }

        public void y(DataHolder dataHolder) {
            ex.this.a(new i(this.rt, dataHolder));
        }

        public void e(DataHolder dataHolder, String[] stringArray) {
            ex.this.a(new ac(this.rt, dataHolder, stringArray));
        }

        public void f(DataHolder dataHolder, String[] stringArray) {
            ex.this.a(new ae(this.rt, dataHolder, stringArray));
        }

        public void a(DataHolder dataHolder, String[] stringArray) {
            ex.this.a(new af(this.rt, dataHolder, stringArray));
        }

        public void b(DataHolder dataHolder, String[] stringArray) {
            ex.this.a(new ag(this.rt, dataHolder, stringArray));
        }

        public void c(DataHolder dataHolder, String[] stringArray) {
            ex.this.a(new ah(this.rt, dataHolder, stringArray));
        }

        public void d(DataHolder dataHolder, String[] stringArray) {
            ex.this.a(new ad(this.rt, dataHolder, stringArray));
        }

        public void onP2PConnected(String participantId) {
            ex.this.a(new aa(this.rt, participantId));
        }

        public void onP2PDisconnected(String participantId) {
            ex.this.a(new ab(this.rt, participantId));
        }

        public void onRealTimeMessageReceived(RealTimeMessage message) {
            ex.this.a(new z(this.ru, message));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class az
    extends ew {
        private final a.c<b.a> rw;

        public az(a.c<b.a> c2) {
            this.rw = du.c(c2, "Holder must not be null");
        }

        @Override
        public void onTurnBasedMatchCanceled(int statusCode, String matchId) {
            Status status = new Status(statusCode);
            ex.this.a(new ba(this.rw, status, matchId));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class bd
    extends ew {
        private final a.c<b.c> rz;

        public bd(a.c<b.c> c2) {
            this.rz = du.c(c2, "Holder must not be null");
        }

        @Override
        public void o(DataHolder dataHolder) {
            ex.this.a(new be(this.rz, dataHolder));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class bh
    extends ew {
        private final a.c<b.f> rB;

        public bh(a.c<b.f> c2) {
            this.rB = du.c(c2, "Holder must not be null");
        }

        @Override
        public void n(DataHolder dataHolder) {
            ex.this.a(new bi(this.rB, dataHolder));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class bb
    extends ew {
        private final a.c<b.b> ry;

        public bb(a.c<b.b> c2) {
            this.ry = du.c(c2, "Holder must not be null");
        }

        @Override
        public void m(DataHolder dataHolder) {
            ex.this.a(new bc(this.ry, dataHolder));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class bf
    extends ew {
        private final a.c<b.d> rA;

        public bf(a.c<b.d> c2) {
            this.rA = du.c(c2, "Holder must not be null");
        }

        @Override
        public void l(DataHolder dataHolder) {
            ex.this.a(new bg(this.rA, dataHolder));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class bj
    extends ew {
        private final a.c<b.e> rC;

        public bj(a.c<b.e> c2) {
            this.rC = du.c(c2, "Holder must not be null");
        }

        @Override
        public void a(int n2, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = new Status(n2);
            ex.this.a(new bk(this.rC, status, bundle));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class aw
    extends ew {
        private final a.c<h.d> jN;

        public aw(a.c<h.d> c2) {
            this.jN = du.c(c2, "Holder must not be null");
        }

        @Override
        public void d(DataHolder dataHolder) {
            ex.this.a(new ax(this.jN, dataHolder));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ak
    extends ew {
        private final a.c<f.a> jN;

        ak(a.c<f.a> c2) {
            this.jN = du.c(c2, "Holder must not be null");
        }

        @Override
        public void e(DataHolder dataHolder) {
            ex.this.a(new al(this.jN, dataHolder));
        }
    }

    final class x
    extends ew {
        private final OnTurnBasedMatchUpdateReceivedListener rj;

        x(OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener) {
            this.rj = onTurnBasedMatchUpdateReceivedListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void p(DataHolder dataHolder) {
            TurnBasedMatchBuffer turnBasedMatchBuffer = new TurnBasedMatchBuffer(dataHolder);
            TurnBasedMatch turnBasedMatch = null;
            try {
                if (turnBasedMatchBuffer.getCount() > 0) {
                    turnBasedMatch = (TurnBasedMatch)((TurnBasedMatch)turnBasedMatchBuffer.get(0)).freeze();
                }
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                turnBasedMatchBuffer.close();
                throw throwable;
            }
            turnBasedMatchBuffer.close();
            if (turnBasedMatch != null) {
                ex.this.a(new y(this.rj, turnBasedMatch));
            }
        }

        public void onTurnBasedMatchRemoved(String matchId) {
            ex.this.a(new w(this.rj, matchId));
        }
    }

    final class l
    extends ew {
        private final OnInvitationReceivedListener ra;

        l(OnInvitationReceivedListener onInvitationReceivedListener) {
            this.ra = onInvitationReceivedListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void k(DataHolder dataHolder) {
            InvitationBuffer invitationBuffer = new InvitationBuffer(dataHolder);
            Invitation invitation = null;
            try {
                if (invitationBuffer.getCount() > 0) {
                    invitation = (Invitation)((Invitation)invitationBuffer.get(0)).freeze();
                }
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                invitationBuffer.close();
                throw throwable;
            }
            invitationBuffer.close();
            if (invitation != null) {
                ex.this.a(new m(this.ra, invitation));
            }
        }

        public void onInvitationRemoved(String invitationId) {
            ex.this.a(new n(this.ra, invitationId));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class o
    extends ew {
        private final a.c<c.a> jN;

        o(a.c<c.a> c2) {
            this.jN = du.c(c2, "Holder must not be null");
        }

        @Override
        public void j(DataHolder dataHolder) {
            ex.this.a(new p(this.jN, dataHolder));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ai
    extends ew {
        private final a.c<h.b> jN;

        ai(a.c<h.b> c2) {
            this.jN = du.c(c2, "Holder must not be null");
        }

        @Override
        public void C(DataHolder dataHolder) {
            ex.this.a(new aj(this.jN, dataHolder));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class r
    extends ew {
        private final a.c<h.c> jN;

        r(a.c<h.c> c2) {
            this.jN = du.c(c2, "Holder must not be null");
        }

        @Override
        public void a(DataHolder dataHolder, DataHolder dataHolder2) {
            ex.this.a(new s(this.jN, dataHolder, dataHolder2));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class t
    extends ew {
        private final a.c<h.a> jN;

        t(a.c<h.a> c2) {
            this.jN = du.c(c2, "Holder must not be null");
        }

        @Override
        public void c(DataHolder dataHolder) {
            ex.this.a(new u(this.jN, dataHolder));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class j
    extends ew {
        private final a.c<c.a> jN;

        j(a.c<c.a> c2) {
            this.jN = du.c(c2, "Holder must not be null");
        }

        @Override
        public void g(DataHolder dataHolder) {
            ex.this.a(new k(this.jN, dataHolder));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class d
    extends ew {
        private final a.c<b.b> jN;

        d(a.c<b.b> c2) {
            this.jN = du.c(c2, "Holder must not be null");
        }

        @Override
        public void onAchievementUpdated(int statusCode, String achievementId) {
            ex.this.a(new e(this.jN, statusCode, achievementId));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class f
    extends ew {
        private final a.c<b.a> jN;

        f(a.c<b.a> c2) {
            this.jN = du.c(c2, "Holder must not be null");
        }

        @Override
        public void b(DataHolder dataHolder) {
            ex.this.a(new g(this.jN, dataHolder));
        }
    }
}

