/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class dy<K, V> {
    private final LinkedHashMap<K, V> nk;
    private int size;
    private int nl;
    private int nm;
    private int nn;
    private int no;
    private int np;
    private int nq;

    public dy(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("maxSize <= 0");
        }
        this.nl = n2;
        this.nk = new LinkedHashMap(0, 0.75f, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final V get(K key) {
        Object object;
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        dy<K, V> dy2 = this;
        synchronized (dy2) {
            object = this.nk.get(key);
            if (object != null) {
                ++this.np;
                return object;
            }
            ++this.nq;
        }
        dy2 = this.create(key);
        if (dy2 == null) {
            return null;
        }
        dy dy3 = this;
        synchronized (dy3) {
            ++this.nn;
            object = this.nk.put(key, dy2);
            if (object != null) {
                this.nk.put(key, object);
            } else {
                this.size += this.d(key, dy2);
            }
        }
        if (object != null) {
            this.entryRemoved(false, key, dy2, object);
            return object;
        }
        this.trimToSize(this.nl);
        return (V)dy2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final V put(K key, V value) {
        V v2;
        if (key == null || value == null) {
            throw new NullPointerException("key == null || value == null");
        }
        dy dy2 = this;
        synchronized (dy2) {
            ++this.nm;
            this.size += this.d(key, value);
            v2 = this.nk.put(key, value);
            if (v2 != null) {
                this.size -= this.d(key, v2);
            }
        }
        if (v2 != null) {
            this.entryRemoved(false, key, v2, value);
        }
        this.trimToSize(this.nl);
        return v2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimToSize(int maxSize) {
        while (true) {
            V v2;
            K k2;
            dy dy2 = this;
            synchronized (dy2) {
                if (this.size < 0 || this.nk.isEmpty() && this.size != 0) {
                    throw new IllegalStateException(this.getClass().getName() + ".sizeOf() is reporting inconsistent results!");
                }
                if (this.size <= maxSize || this.nk.isEmpty()) {
                    break;
                }
                Map.Entry<K, V> entry = this.nk.entrySet().iterator().next();
                k2 = entry.getKey();
                v2 = entry.getValue();
                this.nk.remove(k2);
                this.size -= this.d(k2, v2);
                ++this.no;
            }
            this.entryRemoved(true, k2, v2, null);
        }
    }

    protected void entryRemoved(boolean evicted, K key, V oldValue, V newValue) {
    }

    protected V create(K key) {
        return null;
    }

    private int d(K k2, V v2) {
        int n2 = this.sizeOf(k2, v2);
        if (n2 < 0) {
            throw new IllegalStateException("Negative size: " + k2 + "=" + v2);
        }
        return n2;
    }

    protected int sizeOf(K key, V value) {
        return 1;
    }

    public final void evictAll() {
        this.trimToSize(-1);
    }

    public final synchronized int size() {
        return this.size;
    }

    public final synchronized String toString() {
        int n2 = this.np + this.nq;
        int n3 = n2 != 0 ? 100 * this.np / n2 : 0;
        return String.format("LruCache[maxSize=%d,hits=%d,misses=%d,hitRate=%d%%]", this.nl, this.np, this.nq, n3);
    }
}

