/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesClient;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.internal.dl;
import com.google.android.gms.internal.dm;
import com.google.android.gms.internal.dp;
import com.google.android.gms.internal.dq;
import com.google.android.gms.internal.du;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class dk<T extends IInterface>
implements GooglePlayServicesClient,
Api.a,
dl.b {
    private final Context mContext;
    final Handler mHandler;
    private T mA;
    private final ArrayList<b<?>> mB = new ArrayList();
    private e mC;
    private final String[] jC;
    boolean mD = false;
    boolean mE = false;
    private final dl kB;
    private final Object mF = new Object();
    public static final String[] mG = new String[]{"service_esmobile", "service_googleme"};

    protected dk(Context context, GooglePlayServicesClient.ConnectionCallbacks connectionCallbacks, GooglePlayServicesClient.OnConnectionFailedListener onConnectionFailedListener, String ... stringArray) {
        this.mContext = du.f(context);
        this.kB = new dl(context, this, null);
        this.mHandler = new a(context.getMainLooper());
        this.a(stringArray);
        this.jC = stringArray;
        this.registerConnectionCallbacks(du.f(connectionCallbacks));
        this.registerConnectionFailedListener(du.f(onConnectionFailedListener));
    }

    protected void a(String ... stringArray) {
    }

    protected abstract String am();

    protected abstract String an();

    protected abstract T p(IBinder var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() {
        this.mD = true;
        Object object = this.mF;
        synchronized (object) {
            this.mE = true;
        }
        int n2 = GooglePlayServicesUtil.isGooglePlayServicesAvailable(this.mContext);
        if (n2 != 0) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, (Object)n2));
            return;
        }
        if (this.mC != null) {
            Log.e((String)"GmsClient", (String)"Calling connect() while still connected, missing disconnect().");
            this.mA = null;
            dm.s(this.mContext).b(this.am(), this.mC);
        }
        this.mC = new e();
        boolean bl2 = dm.s(this.mContext).a(this.am(), this.mC);
        if (!bl2) {
            Log.e((String)"GmsClient", (String)("unable to connect to service: " + this.am()));
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, (Object)9));
            return;
        }
    }

    @Override
    public boolean isConnected() {
        return this.mA != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnecting() {
        Object object = this.mF;
        synchronized (object) {
            return this.mE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        this.mD = false;
        ArrayList<b<?>> arrayList = this.mF;
        synchronized (arrayList) {
            this.mE = false;
        }
        arrayList = this.mB;
        synchronized (arrayList) {
            int n2 = this.mB.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.mB.get(i2).bE();
            }
            this.mB.clear();
        }
        this.mA = null;
        if (this.mC != null) {
            dm.s(this.mContext).b(this.am(), this.mC);
            this.mC = null;
        }
    }

    public final Context getContext() {
        return this.mContext;
    }

    public final String[] bA() {
        return this.jC;
    }

    protected final void u(IBinder iBinder) {
        try {
            dq dq2 = dq.a.w(iBinder);
            this.a(dq2, new d(this));
        }
        catch (RemoteException remoteException) {
            Log.w((String)"GmsClient", (String)"service died");
        }
    }

    protected abstract void a(dq var1, d var2) throws RemoteException;

    protected void a(int n2, IBinder iBinder, Bundle bundle) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1, (Object)new f(n2, iBinder, bundle)));
    }

    protected final void bB() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected. Call connect() and wait for onConnected() to be called.");
        }
    }

    @Override
    public Bundle bc() {
        return null;
    }

    protected final T bC() {
        this.bB();
        return this.mA;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void a(b<?> b2) {
        ArrayList<b<?>> arrayList = this.mB;
        synchronized (arrayList) {
            this.mB.add(b2);
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(2, b2));
    }

    @Override
    public boolean bb() {
        return this.mD;
    }

    public void registerConnectionCallbacks(GoogleApiClient.ConnectionCallbacks listener) {
        this.kB.registerConnectionCallbacks(listener);
    }

    public void registerConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener listener) {
        this.kB.registerConnectionFailedListener(listener);
    }

    @Override
    public void registerConnectionCallbacks(GooglePlayServicesClient.ConnectionCallbacks listener) {
        this.kB.registerConnectionCallbacks(listener);
    }

    @Override
    public boolean isConnectionCallbacksRegistered(GooglePlayServicesClient.ConnectionCallbacks listener) {
        return this.kB.isConnectionCallbacksRegistered(listener);
    }

    @Override
    public void unregisterConnectionCallbacks(GooglePlayServicesClient.ConnectionCallbacks listener) {
        this.kB.unregisterConnectionCallbacks(listener);
    }

    @Override
    public void registerConnectionFailedListener(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        this.kB.registerConnectionFailedListener(listener);
    }

    @Override
    public boolean isConnectionFailedListenerRegistered(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        return this.kB.isConnectionFailedListenerRegistered(listener);
    }

    @Override
    public void unregisterConnectionFailedListener(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        this.kB.unregisterConnectionFailedListener(listener);
    }

    public static final class d
    extends dp.a {
        private dk mJ;

        public d(dk dk2) {
            this.mJ = dk2;
        }

        public void b(int n2, IBinder iBinder, Bundle bundle) {
            du.c("onPostInitComplete can be called only once per call to getServiceFromBroker", this.mJ);
            this.mJ.a(n2, iBinder, bundle);
            this.mJ = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class f
    extends b<Boolean> {
        public final int statusCode;
        public final Bundle mK;
        public final IBinder mL;

        public f(int n2, IBinder iBinder, Bundle bundle) {
            super(true);
            this.statusCode = n2;
            this.mL = iBinder;
            this.mK = bundle;
        }

        @Override
        protected void b(Boolean bl2) {
            if (bl2 == null) {
                return;
            }
            switch (this.statusCode) {
                case 0: {
                    String string2 = null;
                    try {
                        string2 = this.mL.getInterfaceDescriptor();
                        if (dk.this.an().equals(string2)) {
                            dk.this.mA = dk.this.p(this.mL);
                            if (dk.this.mA != null) {
                                dk.this.kB.bF();
                                return;
                            }
                        }
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    dm.s(dk.this.mContext).b(dk.this.am(), dk.this.mC);
                    dk.this.mC = null;
                    dk.this.mA = null;
                    dk.this.kB.a(new ConnectionResult(8, null));
                    break;
                }
                case 10: {
                    throw new IllegalStateException("A fatal developer error has occurred. Check the logs for further information.");
                }
                default: {
                    PendingIntent pendingIntent = null;
                    if (this.mK != null) {
                        pendingIntent = (PendingIntent)this.mK.getParcelable("pendingIntent");
                    }
                    if (dk.this.mC != null) {
                        dm.s(dk.this.mContext).b(dk.this.am(), dk.this.mC);
                        dk.this.mC = null;
                    }
                    dk.this.mA = null;
                    dk.this.kB.a(new ConnectionResult(this.statusCode, pendingIntent));
                }
            }
        }

        @Override
        protected void aQ() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class c<TListener>
    extends b<TListener> {
        private final DataHolder lb;

        public c(TListener TListener, DataHolder dataHolder) {
            super(TListener);
            this.lb = dataHolder;
        }

        @Override
        protected final void b(TListener TListener) {
            this.a(TListener, this.lb);
        }

        protected abstract void a(TListener var1, DataHolder var2);

        @Override
        protected void aQ() {
            if (this.lb != null) {
                this.lb.close();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class b<TListener> {
        private TListener mListener;
        private boolean mI;

        public b(TListener TListener) {
            this.mListener = TListener;
            this.mI = false;
        }

        protected abstract void b(TListener var1);

        protected abstract void aQ();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void bD() {
            TListener TListener;
            b b2 = this;
            synchronized (b2) {
                TListener = this.mListener;
                if (this.mI) {
                    Log.w((String)"GmsClient", (String)("Callback proxy " + this + " being reused. This is not safe."));
                }
            }
            if (TListener != null) {
                try {
                    this.b(TListener);
                }
                catch (RuntimeException runtimeException) {
                    this.aQ();
                    throw runtimeException;
                }
            } else {
                this.aQ();
            }
            b2 = this;
            synchronized (b2) {
                this.mI = true;
            }
            this.unregister();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregister() {
            this.bE();
            ArrayList arrayList = dk.this.mB;
            synchronized (arrayList) {
                dk.this.mB.remove(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void bE() {
            b b2 = this;
            synchronized (b2) {
                this.mListener = null;
            }
        }
    }

    final class a
    extends Handler {
        public a(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            if (msg.what == 1 && !dk.this.isConnecting()) {
                b b2 = (b)msg.obj;
                b2.aQ();
                b2.unregister();
                return;
            }
            Object object = dk.this.mF;
            synchronized (object) {
                dk.this.mE = false;
            }
            if (msg.what == 3) {
                dk.this.kB.a(new ConnectionResult((Integer)msg.obj, null));
                return;
            }
            if (msg.what == 2 && !dk.this.isConnected()) {
                object = (b)msg.obj;
                ((b)object).aQ();
                ((b)object).unregister();
                return;
            }
            if (msg.what == 2 || msg.what == 1) {
                object = (b)msg.obj;
                ((b)object).bD();
                return;
            }
            Log.wtf((String)"GmsClient", (String)"Don't know how to handle this message.");
        }
    }

    final class e
    implements ServiceConnection {
        e() {
        }

        public void onServiceConnected(ComponentName component, IBinder binder) {
            dk.this.u(binder);
        }

        public void onServiceDisconnected(ComponentName component) {
            dk.this.mA = null;
            dk.this.kB.bG();
        }
    }
}

