/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Message;
import android.view.View;
import android.webkit.ConsoleMessage;
import android.webkit.JsPromptResult;
import android.webkit.JsResult;
import android.webkit.WebChromeClient;
import android.webkit.WebStorage;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.google.android.gms.internal.bk;
import com.google.android.gms.internal.cs;
import com.google.android.gms.internal.cv;

public class cx
extends WebChromeClient {
    private final cv gu;

    private static boolean a(Context context, String string2, String string3, String string4, JsResult jsResult, JsPromptResult jsPromptResult, boolean bl2) {
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setTitle((CharSequence)string2);
        if (bl2) {
            cx.a(context, builder, string3, string4, jsPromptResult);
        } else {
            cx.a(builder, string3, jsResult);
        }
        return true;
    }

    private static void a(AlertDialog.Builder builder, String string2, final JsResult jsResult) {
        builder.setMessage((CharSequence)string2).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                jsResult.confirm();
            }
        }).setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                jsResult.cancel();
            }
        }).setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                jsResult.cancel();
            }
        }).create().show();
    }

    private static void a(Context context, AlertDialog.Builder builder, String string2, String string3, final JsPromptResult jsPromptResult) {
        LinearLayout linearLayout = new LinearLayout(context);
        linearLayout.setOrientation(1);
        TextView textView = new TextView(context);
        textView.setText((CharSequence)string2);
        final EditText editText = new EditText(context);
        editText.setText((CharSequence)string3);
        linearLayout.addView((View)textView);
        linearLayout.addView((View)editText);
        builder.setView((View)linearLayout).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                jsPromptResult.confirm(editText.getText().toString());
            }
        }).setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                jsPromptResult.cancel();
            }
        }).setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                jsPromptResult.cancel();
            }
        }).create().show();
    }

    public cx(cv cv2) {
        this.gu = cv2;
    }

    public final boolean onCreateWindow(WebView view, boolean isDialog, boolean isUserGesture, Message resultMsg) {
        WebView.WebViewTransport webViewTransport = (WebView.WebViewTransport)resultMsg.obj;
        WebView webView = new WebView(view.getContext());
        webView.setWebViewClient((WebViewClient)this.gu.aB());
        webViewTransport.setWebView(webView);
        resultMsg.sendToTarget();
        return true;
    }

    public final void onCloseWindow(WebView webView) {
        if (!(webView instanceof cv)) {
            cs.v("Tried to close a WebView that wasn't an AdWebView.");
            return;
        }
        bk bk2 = ((cv)webView).aA();
        if (bk2 == null) {
            cs.v("Tried to close an AdWebView not associated with an overlay.");
            return;
        }
        bk2.close();
    }

    public final boolean onConsoleMessage(ConsoleMessage consoleMessage) {
        String string2 = "JS: " + consoleMessage.message() + " (" + consoleMessage.sourceId() + ":" + consoleMessage.lineNumber() + ")";
        switch (consoleMessage.messageLevel()) {
            case ERROR: {
                cs.s(string2);
                break;
            }
            case WARNING: {
                cs.v(string2);
                break;
            }
            case LOG: 
            case TIP: {
                cs.t(string2);
                break;
            }
            case DEBUG: {
                cs.r(string2);
                break;
            }
            default: {
                cs.t(string2);
            }
        }
        return super.onConsoleMessage(consoleMessage);
    }

    public final void onExceededDatabaseQuota(String url, String databaseIdentifier, long currentQuota, long estimatedSize, long totalUsedQuota, WebStorage.QuotaUpdater quotaUpdater) {
        long l2;
        long l3 = 0x500000L - totalUsedQuota;
        if (l3 <= 0L) {
            quotaUpdater.updateQuota(currentQuota);
            return;
        }
        if (currentQuota == 0L) {
            l2 = estimatedSize <= l3 && estimatedSize <= 0x100000L ? estimatedSize : 0L;
        } else if (estimatedSize == 0L) {
            long l4 = Math.min(131072L, l3);
            l2 = Math.min(currentQuota + l4, 0x100000L);
        } else {
            long l5 = Math.min(0x100000L - currentQuota, l3);
            l2 = estimatedSize <= l5 ? currentQuota + estimatedSize : currentQuota;
        }
        quotaUpdater.updateQuota(l2);
    }

    public final void onHideCustomView() {
        bk bk2 = this.gu.aA();
        if (bk2 == null) {
            cs.v("Could not get ad overlay when hiding custom view.");
            return;
        }
        bk2.X();
    }

    public final boolean onJsAlert(WebView webView, String url, String message, JsResult result) {
        return cx.a(webView.getContext(), url, message, null, result, null, false);
    }

    public final boolean onJsBeforeUnload(WebView webView, String url, String message, JsResult result) {
        return cx.a(webView.getContext(), url, message, null, result, null, false);
    }

    public final boolean onJsConfirm(WebView webView, String url, String message, JsResult result) {
        return cx.a(webView.getContext(), url, message, null, result, null, false);
    }

    public final boolean onJsPrompt(WebView webView, String url, String message, String defaultValue, JsPromptResult result) {
        return cx.a(webView.getContext(), url, message, defaultValue, null, result, true);
    }

    public final void onReachedMaxAppCacheSize(long spaceNeeded, long totalUsedQuota, WebStorage.QuotaUpdater quotaUpdater) {
        long l2 = 0x500000L - totalUsedQuota;
        long l3 = spaceNeeded + 131072L;
        if (l2 < l3) {
            quotaUpdater.updateQuota(0L);
        } else {
            quotaUpdater.updateQuota(l3);
        }
    }

    public final void onShowCustomView(View view, WebChromeClient.CustomViewCallback customViewCallback) {
        this.a(view, -1, customViewCallback);
    }

    protected final void a(View view, int n2, WebChromeClient.CustomViewCallback customViewCallback) {
        bk bk2 = this.gu.aA();
        if (bk2 == null) {
            cs.v("Could not get ad overlay when showing custom view.");
            customViewCallback.onCustomViewHidden();
            return;
        }
        bk2.a(view, customViewCallback);
        bk2.setRequestedOrientation(n2);
    }
}

