/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.MutableContextWrapper;
import android.net.Uri;
import android.os.Build;
import android.view.MotionEvent;
import android.view.View;
import android.webkit.DownloadListener;
import android.webkit.WebSettings;
import android.webkit.WebView;
import com.google.android.gms.internal.bk;
import com.google.android.gms.internal.cn;
import com.google.android.gms.internal.co;
import com.google.android.gms.internal.cp;
import com.google.android.gms.internal.cs;
import com.google.android.gms.internal.ct;
import com.google.android.gms.internal.cw;
import com.google.android.gms.internal.cx;
import com.google.android.gms.internal.cy;
import com.google.android.gms.internal.cz;
import com.google.android.gms.internal.h;
import com.google.android.gms.internal.x;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class cv
extends WebView
implements DownloadListener {
    private final cw iJ;
    private final a iK;
    private final Object fx = new Object();
    private final h hc;
    private final ct iL;
    private bk iM;
    private x fU;
    private boolean iN;
    private boolean iO;

    public static cv a(Context context, x x2, boolean bl2, boolean bl3, h h2, ct ct2) {
        a a2 = new a(context);
        return new cv(a2, x2, bl2, bl3, h2, ct2);
    }

    private cv(a a2, x x2, boolean bl2, boolean bl3, h h2, ct ct2) {
        super((Context)a2);
        this.iK = a2;
        this.fU = x2;
        this.iN = bl2;
        this.hc = h2;
        this.iL = ct2;
        this.setBackgroundColor(0);
        WebSettings webSettings = this.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setSavePassword(false);
        webSettings.setSupportMultipleWindows(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        cn.a((Context)a2, ct2.iF, webSettings);
        if (Build.VERSION.SDK_INT >= 17) {
            cp.a(this.getContext(), webSettings);
        } else if (Build.VERSION.SDK_INT >= 11) {
            co.a(this.getContext(), webSettings);
        }
        this.setDownloadListener(this);
        this.iJ = Build.VERSION.SDK_INT >= 11 ? new cy(this, bl3) : new cw(this, bl3);
        this.setWebViewClient(this.iJ);
        if (Build.VERSION.SDK_INT >= 14) {
            this.setWebChromeClient(new cz(this));
        } else if (Build.VERSION.SDK_INT >= 11) {
            this.setWebChromeClient(new cx(this));
        }
        this.aF();
    }

    public void a(String string2, Map<String, ?> map) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("javascript:AFMA_ReceiveMessage('");
        stringBuilder.append(string2);
        stringBuilder.append("'");
        if (map != null) {
            try {
                String string3 = cn.m(map).toString();
                stringBuilder.append(",");
                stringBuilder.append(string3);
            }
            catch (JSONException jSONException) {
                cs.v("Could not convert AFMA event parameters to JSON.");
                return;
            }
        }
        stringBuilder.append(");");
        cs.u("Dispatching AFMA event: " + stringBuilder);
        this.loadUrl(stringBuilder.toString());
    }

    public void ay() {
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.iL.iF);
        this.a("onhide", hashMap);
    }

    public void az() {
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.iL.iF);
        this.a("onshow", hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public bk aA() {
        Object object = this.fx;
        synchronized (object) {
            return this.iM;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public x y() {
        Object object = this.fx;
        synchronized (object) {
            return this.fU;
        }
    }

    public cw aB() {
        return this.iJ;
    }

    public h aC() {
        return this.hc;
    }

    public ct aD() {
        return this.iL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean aE() {
        Object object = this.fx;
        synchronized (object) {
            return this.iN;
        }
    }

    public void onDownloadStart(String url, String userAgent, String contentDisposition, String mimeType, long size) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setDataAndType(Uri.parse((String)url), mimeType);
            this.getContext().startActivity(intent);
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            cs.r("Couldn't find an Activity to view url/mimetype: " + url + " / " + mimeType);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.hc != null) {
            this.hc.a(event);
        }
        return super.onTouchEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        Object object = this.fx;
        synchronized (object) {
            if (this.isInEditMode() || this.iN) {
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
                return;
            }
            int n2 = View.MeasureSpec.getMode((int)widthMeasureSpec);
            int n3 = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int n4 = View.MeasureSpec.getMode((int)heightMeasureSpec);
            int n5 = View.MeasureSpec.getSize((int)heightMeasureSpec);
            int n6 = Integer.MAX_VALUE;
            if (n2 == Integer.MIN_VALUE || n2 == 0x40000000) {
                n6 = n3;
            }
            int n7 = Integer.MAX_VALUE;
            if (n4 == Integer.MIN_VALUE || n4 == 0x40000000) {
                n7 = n5;
            }
            if (this.fU.widthPixels > n6 || this.fU.heightPixels > n7) {
                cs.v("Not enough space to show ad. Needs " + this.fU.widthPixels + "x" + this.fU.heightPixels + " pixels, but only has " + n3 + "x" + n5 + " pixels.");
                if (this.getVisibility() != 8) {
                    this.setVisibility(4);
                }
                this.setMeasuredDimension(0, 0);
            } else {
                if (this.getVisibility() != 8) {
                    this.setVisibility(0);
                }
                this.setMeasuredDimension(this.fU.widthPixels, this.fU.heightPixels);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(Context context, x x2) {
        Object object = this.fx;
        synchronized (object) {
            this.iK.setBaseContext(context);
            this.iM = null;
            this.fU = x2;
            this.iN = false;
            cn.b(this);
            this.loadUrl("about:blank");
            this.iJ.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(bk bk2) {
        Object object = this.fx;
        synchronized (object) {
            this.iM = bk2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(x x2) {
        Object object = this.fx;
        synchronized (object) {
            this.fU = x2;
            this.requestLayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void l(boolean bl2) {
        Object object = this.fx;
        synchronized (object) {
            this.iN = bl2;
            this.aF();
        }
    }

    public void setContext(Context context) {
        this.iK.setBaseContext(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void aF() {
        Object object = this.fx;
        synchronized (object) {
            if (this.iN || this.fU.eG) {
                if (Build.VERSION.SDK_INT < 14) {
                    cs.r("Disabling hardware acceleration on an overlay.");
                    this.aG();
                } else {
                    cs.r("Enabling hardware acceleration on an overlay.");
                    this.aH();
                }
            } else if (Build.VERSION.SDK_INT < 18) {
                cs.r("Disabling hardware acceleration on an AdView.");
                this.aG();
            } else {
                cs.r("Enabling hardware acceleration on an AdView.");
                this.aH();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void aG() {
        Object object = this.fx;
        synchronized (object) {
            if (!this.iO && Build.VERSION.SDK_INT >= 11) {
                co.c((View)this);
            }
            this.iO = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void aH() {
        Object object = this.fx;
        synchronized (object) {
            if (this.iO && Build.VERSION.SDK_INT >= 11) {
                co.d((View)this);
            }
            this.iO = false;
        }
    }

    private static class a
    extends MutableContextWrapper {
        private Activity iP;
        private Context iQ;

        public a(Context context) {
            super(context);
            this.setBaseContext(context);
        }

        public void setBaseContext(Context base) {
            this.iQ = base.getApplicationContext();
            this.iP = base instanceof Activity ? (Activity)base : null;
            super.setBaseContext(this.iQ);
        }

        public void startActivity(Intent intent) {
            if (this.iP != null) {
                this.iP.startActivity(intent);
            } else {
                intent.setFlags(0x10000000);
                this.iQ.startActivity(intent);
            }
        }
    }
}

