/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.webkit.WebSettings;
import android.webkit.WebView;
import com.google.android.gms.internal.co;
import com.google.android.gms.internal.cp;
import com.google.android.gms.internal.cq;
import com.google.android.gms.internal.cr;
import com.google.android.gms.internal.cs;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class cn {
    private static final Object hA = new Object();
    private static boolean iz = true;
    private static String iA;
    private static boolean iB;

    public static void a(Context context, String string2, boolean bl2, HttpURLConnection httpURLConnection) {
        httpURLConnection.setConnectTimeout(60000);
        httpURLConnection.setInstanceFollowRedirects(bl2);
        httpURLConnection.setReadTimeout(60000);
        httpURLConnection.setRequestProperty("User-Agent", cn.b(context, string2));
        httpURLConnection.setUseCaches(false);
    }

    public static boolean h(Context context) {
        Intent intent = new Intent();
        intent.setClassName(context, "com.google.android.gms.ads.AdActivity");
        PackageManager packageManager = context.getPackageManager();
        ResolveInfo resolveInfo = packageManager.resolveActivity(intent, 65536);
        boolean bl2 = true;
        if (resolveInfo == null || resolveInfo.activityInfo == null) {
            cs.v("Could not find com.google.android.gms.ads.AdActivity, please make sure it is declared in AndroidManifest.xml.");
            bl2 = false;
        } else {
            String string2 = "com.google.android.gms.ads.AdActivity requires the android:configChanges value to contain \"%s\".";
            if ((resolveInfo.activityInfo.configChanges & 0x10) == 0) {
                cs.v(String.format(string2, "keyboard"));
                bl2 = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x20) == 0) {
                cs.v(String.format(string2, "keyboardHidden"));
                bl2 = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x80) == 0) {
                cs.v(String.format(string2, "orientation"));
                bl2 = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x100) == 0) {
                cs.v(String.format(string2, "screenLayout"));
                bl2 = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x200) == 0) {
                cs.v(String.format(string2, "uiMode"));
                bl2 = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x400) == 0) {
                cs.v(String.format(string2, "screenSize"));
                bl2 = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x800) == 0) {
                cs.v(String.format(string2, "smallestScreenSize"));
                bl2 = false;
            }
        }
        return bl2;
    }

    public static boolean a(PackageManager packageManager, String string2, String string3) {
        return packageManager.checkPermission(string3, string2) == 0;
    }

    public static boolean as() {
        return iz;
    }

    public static int at() {
        return Build.VERSION.SDK_INT >= 9 ? 6 : 0;
    }

    public static int au() {
        return Build.VERSION.SDK_INT >= 9 ? 7 : 1;
    }

    public static void a(Context context, String string2, List<String> list) {
        for (String string3 : list) {
            new cq(context, string2, string3).start();
        }
    }

    public static String a(Readable readable) throws IOException {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        CharBuffer charBuffer = CharBuffer.allocate(2048);
        while ((n2 = readable.read(charBuffer)) != -1) {
            charBuffer.flip();
            stringBuilder.append(charBuffer, 0, n2);
        }
        return stringBuilder.toString();
    }

    public static void i(Context context) {
        if (iB) {
            return;
        }
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.USER_PRESENT");
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        context.getApplicationContext().registerReceiver((BroadcastReceiver)new a(), intentFilter);
        iB = true;
    }

    public static void a(Context context, String string2, WebSettings webSettings) {
        webSettings.setUserAgentString(cn.b(context, string2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String b(final Context context, String string2) {
        Object object = hA;
        synchronized (object) {
            if (iA != null) {
                return iA;
            }
            if (Build.VERSION.SDK_INT >= 17) {
                iA = cp.getDefaultUserAgent(context);
            } else if (!cr.ax()) {
                cr.iE.post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Object object = hA;
                        synchronized (object) {
                            iA = cn.j(context);
                            hA.notifyAll();
                        }
                    }
                });
                while (iA == null) {
                    try {
                        hA.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        return iA;
                    }
                }
            } else {
                iA = cn.j(context);
            }
            iA = iA + " (Mobile; " + string2 + ")";
            return iA;
        }
    }

    private static String j(Context context) {
        return new WebView(context).getSettings().getUserAgentString();
    }

    public static String o(String string2) {
        return Uri.parse((String)string2).buildUpon().query(null).build().toString();
    }

    public static JSONObject m(Map<String, ?> map) throws JSONException {
        try {
            JSONObject jSONObject = new JSONObject();
            for (String string2 : map.keySet()) {
                cn.a(jSONObject, string2, map.get(string2));
            }
            return jSONObject;
        }
        catch (ClassCastException classCastException) {
            throw new JSONException("Could not convert map to JSON: " + classCastException.getMessage());
        }
    }

    private static JSONObject a(Bundle bundle) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        for (String string2 : bundle.keySet()) {
            cn.a(jSONObject, string2, bundle.get(string2));
        }
        return jSONObject;
    }

    private static JSONArray a(Collection<?> collection) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        for (Object obj : collection) {
            cn.a(jSONArray, obj);
        }
        return jSONArray;
    }

    private static JSONArray a(Object[] objectArray) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        for (Object object : objectArray) {
            cn.a(jSONArray, object);
        }
        return jSONArray;
    }

    private static void a(JSONArray jSONArray, Object object) throws JSONException {
        if (object instanceof Bundle) {
            jSONArray.put((Object)cn.a((Bundle)object));
        } else if (object instanceof Map) {
            Map map = (Map)object;
            jSONArray.put((Object)cn.m(map));
        } else if (object instanceof Collection) {
            jSONArray.put((Object)cn.a((Collection)object));
        } else if (object instanceof Object[]) {
            jSONArray.put((Object)cn.a((Object[])object));
        } else {
            jSONArray.put(object);
        }
    }

    private static void a(JSONObject jSONObject, String string2, Object object) throws JSONException {
        if (object instanceof Bundle) {
            jSONObject.put(string2, (Object)cn.a((Bundle)object));
        } else if (object instanceof Map) {
            Map map = (Map)object;
            jSONObject.put(string2, (Object)cn.m(map));
        } else if (object instanceof Collection) {
            jSONObject.put(string2 != null ? string2 : "null", (Object)cn.a((Collection)object));
        } else if (object instanceof Object[]) {
            jSONObject.put(string2, (Object)cn.a(Arrays.asList((Object[])object)));
        } else {
            jSONObject.put(string2, object);
        }
    }

    public static void a(WebView webView) {
        if (Build.VERSION.SDK_INT >= 11) {
            co.a(webView);
        }
    }

    public static void b(WebView webView) {
        if (Build.VERSION.SDK_INT >= 11) {
            co.b(webView);
        }
    }

    static {
        iB = false;
    }

    private static final class a
    extends BroadcastReceiver {
        private a() {
        }

        public void onReceive(Context context, Intent intent) {
            if ("android.intent.action.USER_PRESENT".equals(intent.getAction())) {
                iz = true;
            } else if ("android.intent.action.SCREEN_OFF".equals(intent.getAction())) {
                iz = false;
            }
        }
    }
}

