/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.graphics.Color;
import android.location.Location;
import android.text.TextUtils;
import com.google.android.gms.internal.ai;
import com.google.android.gms.internal.bz;
import com.google.android.gms.internal.cb;
import com.google.android.gms.internal.ce;
import com.google.android.gms.internal.ci;
import com.google.android.gms.internal.cn;
import com.google.android.gms.internal.cs;
import com.google.android.gms.internal.v;
import com.google.android.gms.internal.x;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class cf {
    private static final SimpleDateFormat hH = new SimpleDateFormat("yyyyMMdd");

    public static String a(bz bz2, ci ci2, Location location) {
        try {
            CharSequence charSequence;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            if (bz2.ho != null) {
                hashMap.put("ad_pos", bz2.ho);
            }
            cf.a(hashMap, bz2.hp);
            hashMap.put("format", bz2.em.eF);
            if (bz2.em.width == -1) {
                hashMap.put("smart_w", "full");
            }
            if (bz2.em.height == -2) {
                hashMap.put("smart_h", "auto");
            }
            if (bz2.em.eH != null) {
                charSequence = new StringBuilder();
                for (x x2 : bz2.em.eH) {
                    if (charSequence.length() != 0) {
                        charSequence.append("|");
                    }
                    charSequence.append(x2.width == -1 ? (int)((float)x2.widthPixels / ci2.im) : x2.width);
                    charSequence.append("x");
                    charSequence.append(x2.height == -2 ? (int)((float)x2.heightPixels / ci2.im) : x2.height);
                }
                hashMap.put("sz", charSequence);
            }
            hashMap.put("slotname", bz2.adUnitId);
            hashMap.put("pn", bz2.applicationInfo.packageName);
            if (bz2.hq != null) {
                hashMap.put("vc", bz2.hq.versionCode);
            }
            hashMap.put("ms", bz2.hr);
            hashMap.put("seq_num", bz2.hs);
            hashMap.put("session_id", bz2.ht);
            hashMap.put("js", bz2.ej.iF);
            cf.a(hashMap, ci2);
            if (bz2.hp.versionCode >= 2 && bz2.hp.eE != null) {
                cf.a(hashMap, bz2.hp.eE);
            }
            if (cs.n(2)) {
                charSequence = cn.m(hashMap).toString(2);
                cs.u("Ad Request JSON: " + (String)charSequence);
            }
            return cn.m(hashMap).toString();
        }
        catch (JSONException jSONException) {
            cs.v("Problem serializing ad request to JSON: " + jSONException.getMessage());
            return null;
        }
    }

    private static void a(HashMap<String, Object> hashMap, v v2) {
        if (v2.ex != -1L) {
            hashMap.put("cust_age", hH.format(new Date(v2.ex)));
        }
        if (v2.extras != null) {
            hashMap.put("extras", v2.extras);
        }
        if (v2.ey != -1) {
            hashMap.put("cust_gender", v2.ey);
        }
        if (v2.ez != null) {
            hashMap.put("kw", v2.ez);
        }
        if (v2.tagForChildDirectedTreatment != -1) {
            hashMap.put("tag_for_child_directed_treatment", v2.tagForChildDirectedTreatment);
        }
        if (v2.eA) {
            hashMap.put("adtest", "on");
        }
        if (v2.versionCode >= 2) {
            if (v2.eB) {
                hashMap.put("d_imp_hdr", 1);
            }
            if (!TextUtils.isEmpty((CharSequence)v2.eC)) {
                hashMap.put("ppid", v2.eC);
            }
            if (v2.eD != null) {
                cf.a(hashMap, v2.eD);
            }
        }
    }

    private static void a(HashMap<String, Object> hashMap, ci ci2) {
        hashMap.put("am", ci2.hW);
        hashMap.put("cog", cf.j(ci2.hX));
        hashMap.put("coh", cf.j(ci2.hY));
        if (!TextUtils.isEmpty((CharSequence)ci2.hZ)) {
            hashMap.put("carrier", ci2.hZ);
        }
        hashMap.put("gl", ci2.ia);
        if (ci2.ib) {
            hashMap.put("simulator", 1);
        }
        hashMap.put("ma", cf.j(ci2.ic));
        hashMap.put("sp", cf.j(ci2.id));
        hashMap.put("hl", ci2.ie);
        if (!TextUtils.isEmpty((CharSequence)ci2.if)) {
            hashMap.put("mv", ci2.if);
        }
        hashMap.put("muv", ci2.ig);
        if (ci2.ih != -2) {
            hashMap.put("cnt", ci2.ih);
        }
        hashMap.put("gnt", ci2.ii);
        hashMap.put("pt", ci2.ij);
        hashMap.put("rm", ci2.ik);
        hashMap.put("riv", ci2.il);
        hashMap.put("u_sd", Float.valueOf(ci2.im));
        hashMap.put("sh", ci2.io);
        hashMap.put("sw", ci2.in);
    }

    private static void a(HashMap<String, Object> hashMap, Location location) {
        HashMap<String, Number> hashMap2 = new HashMap<String, Number>();
        Float f2 = Float.valueOf(location.getAccuracy() * 1000.0f);
        Long l2 = location.getTime() * 1000L;
        Long l3 = (long)(location.getLatitude() * 1.0E7);
        Long l4 = (long)(location.getLongitude() * 1.0E7);
        hashMap2.put("radius", f2);
        hashMap2.put("lat", l3);
        hashMap2.put("long", l4);
        hashMap2.put("time", l2);
        hashMap.put("uule", hashMap2);
    }

    private static void a(HashMap<String, Object> hashMap, ai ai2) {
        String string2;
        String string3;
        if (Color.alpha((int)ai2.eZ) != 0) {
            hashMap.put("acolor", cf.m(ai2.eZ));
        }
        if (Color.alpha((int)ai2.backgroundColor) != 0) {
            hashMap.put("bgcolor", cf.m(ai2.backgroundColor));
        }
        if (Color.alpha((int)ai2.fa) != 0 && Color.alpha((int)ai2.fb) != 0) {
            hashMap.put("gradientto", cf.m(ai2.fa));
            hashMap.put("gradientfrom", cf.m(ai2.fb));
        }
        if (Color.alpha((int)ai2.fc) != 0) {
            hashMap.put("bcolor", cf.m(ai2.fc));
        }
        hashMap.put("bthick", Integer.toString(ai2.fd));
        switch (ai2.fe) {
            case 0: {
                string3 = "none";
                break;
            }
            case 1: {
                string3 = "dashed";
                break;
            }
            case 2: {
                string3 = "dotted";
                break;
            }
            case 3: {
                string3 = "solid";
                break;
            }
            default: {
                string3 = null;
            }
        }
        if (string3 != null) {
            hashMap.put("btype", string3);
        }
        switch (ai2.ff) {
            case 2: {
                string2 = "dark";
                break;
            }
            case 0: {
                string2 = "light";
                break;
            }
            case 1: {
                string2 = "medium";
                break;
            }
            default: {
                string2 = null;
            }
        }
        if (string2 != null) {
            hashMap.put("callbuttoncolor", string2);
        }
        if (ai2.fg != null) {
            hashMap.put("channel", ai2.fg);
        }
        if (Color.alpha((int)ai2.fh) != 0) {
            hashMap.put("dcolor", cf.m(ai2.fh));
        }
        if (ai2.fi != null) {
            hashMap.put("font", ai2.fi);
        }
        if (Color.alpha((int)ai2.fj) != 0) {
            hashMap.put("hcolor", cf.m(ai2.fj));
        }
        hashMap.put("headersize", Integer.toString(ai2.fk));
        if (ai2.fl != null) {
            hashMap.put("q", ai2.fl);
        }
    }

    private static Integer j(boolean bl2) {
        return bl2 ? 1 : 0;
    }

    private static String m(int n2) {
        return String.format(Locale.US, "#%06x", n2 & 0xFFFFFF);
    }

    public static cb a(Context context, bz bz2, String string2) {
        try {
            List<String> list;
            List<String> list2;
            List<String> list3;
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.optString("ad_base_url", null);
            String string4 = jSONObject.optString("ad_url", null);
            String string5 = jSONObject.optString("ad_size", null);
            String string6 = jSONObject.optString("ad_html", null);
            long l2 = jSONObject.has("interstitial_timeout") ? (long)(jSONObject.getDouble("interstitial_timeout") * 1000.0) : -1L;
            String string7 = jSONObject.optString("orientation", null);
            int n2 = -1;
            if ("portrait".equals(string7)) {
                n2 = cn.au();
            } else if ("landscape".equals(string7)) {
                n2 = cn.at();
            }
            cb cb2 = null;
            if (!TextUtils.isEmpty((CharSequence)string6)) {
                if (TextUtils.isEmpty((CharSequence)string3)) {
                    cs.v("Could not parse the mediation config: Missing required ad_base_url field");
                    return new cb(0);
                }
            } else if (!TextUtils.isEmpty((CharSequence)string4)) {
                cb2 = ce.a(context, bz2.ej.iF, string4);
                string3 = cb2.gK;
                string6 = cb2.hu;
            } else {
                cs.v("Could not parse the mediation config: Missing required ad_html or ad_url field.");
                return new cb(0);
            }
            JSONArray jSONArray = jSONObject.optJSONArray("click_urls");
            List<String> list4 = list3 = cb2 == null ? null : cb2.fK;
            if (jSONArray != null) {
                if (list3 == null) {
                    list3 = new LinkedList<String>();
                }
                for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                    list3.add(jSONArray.getString(i2));
                }
            }
            JSONArray jSONArray2 = jSONObject.optJSONArray("impression_urls");
            List<String> list5 = list2 = cb2 == null ? null : cb2.fL;
            if (jSONArray2 != null) {
                if (list2 == null) {
                    list2 = new LinkedList<String>();
                }
                for (int i3 = 0; i3 < jSONArray2.length(); ++i3) {
                    list2.add(jSONArray2.getString(i3));
                }
            }
            JSONArray jSONArray3 = jSONObject.optJSONArray("manual_impression_urls");
            List<String> list6 = list = cb2 == null ? null : cb2.hy;
            if (jSONArray3 != null) {
                if (list == null) {
                    list = new LinkedList<String>();
                }
                for (int i4 = 0; i4 < jSONArray3.length(); ++i4) {
                    list.add(jSONArray3.getString(i4));
                }
            }
            if (cb2 != null) {
                if (cb2.orientation != -1) {
                    n2 = cb2.orientation;
                }
                if (cb2.hv > 0L) {
                    l2 = cb2.hv;
                }
            }
            return new cb(string3, string6, list3, list2, l2, false, -1L, list, -1L, n2, string5);
        }
        catch (JSONException jSONException) {
            cs.v("Could not parse the mediation config: " + jSONException.getMessage());
            return new cb(0);
        }
    }
}

