/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.os.Bundle;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchEntityCreator;
import com.google.android.gms.internal.ds;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TurnBasedMatchEntity
implements SafeParcelable,
TurnBasedMatch {
    public static final TurnBasedMatchEntityCreator CREATOR = new TurnBasedMatchEntityCreator();
    private final int kZ;
    private final GameEntity sq;
    private final String ri;
    private final String sS;
    private final long sr;
    private final String tb;
    private final long tc;
    private final String td;
    private final int te;
    private final int sv;
    private final int tf;
    private final byte[] tg;
    private final ArrayList<ParticipantEntity> su;
    private final String th;
    private final byte[] ti;
    private final int tj;
    private final Bundle sO;
    private final int tk;
    private final boolean tl;

    public TurnBasedMatchEntity(TurnBasedMatch match) {
        this.kZ = 2;
        this.sq = new GameEntity(match.getGame());
        this.ri = match.getMatchId();
        this.sS = match.getCreatorId();
        this.sr = match.getCreationTimestamp();
        this.tb = match.getLastUpdaterId();
        this.tc = match.getLastUpdatedTimestamp();
        this.td = match.getPendingParticipantId();
        this.te = match.getStatus();
        this.tk = match.getTurnStatus();
        this.sv = match.getVariant();
        this.tf = match.getVersion();
        this.th = match.getRematchId();
        this.tj = match.getMatchNumber();
        this.sO = match.getAutoMatchCriteria();
        this.tl = match.isLocallyModified();
        byte[] byArray = match.getData();
        if (byArray == null) {
            this.tg = null;
        } else {
            this.tg = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.tg, 0, byArray.length);
        }
        byte[] byArray2 = match.getPreviousMatchData();
        if (byArray2 == null) {
            this.ti = null;
        } else {
            this.ti = new byte[byArray2.length];
            System.arraycopy(byArray2, 0, this.ti, 0, byArray2.length);
        }
        ArrayList arrayList = match.getParticipants();
        int n2 = arrayList.size();
        this.su = new ArrayList(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.su.add((ParticipantEntity)((Participant)arrayList.get(i2)).freeze());
        }
    }

    TurnBasedMatchEntity(int versionCode, GameEntity game, String matchId, String creatorId, long creationTimestamp, String lastUpdaterId, long lastUpdatedTimestamp, String pendingParticipantId, int matchStatus, int variant, int version, byte[] data, ArrayList<ParticipantEntity> participants, String rematchId, byte[] previousData, int matchNumber, Bundle autoMatchCriteria, int turnStatus, boolean isLocallyModified) {
        this.kZ = versionCode;
        this.sq = game;
        this.ri = matchId;
        this.sS = creatorId;
        this.sr = creationTimestamp;
        this.tb = lastUpdaterId;
        this.tc = lastUpdatedTimestamp;
        this.td = pendingParticipantId;
        this.te = matchStatus;
        this.tk = turnStatus;
        this.sv = variant;
        this.tf = version;
        this.tg = data;
        this.su = participants;
        this.th = rematchId;
        this.ti = previousData;
        this.tj = matchNumber;
        this.sO = autoMatchCriteria;
        this.tl = isLocallyModified;
    }

    public int getVersionCode() {
        return this.kZ;
    }

    @Override
    public Game getGame() {
        return this.sq;
    }

    @Override
    public String getMatchId() {
        return this.ri;
    }

    @Override
    public String getCreatorId() {
        return this.sS;
    }

    @Override
    public long getCreationTimestamp() {
        return this.sr;
    }

    @Override
    public String getLastUpdaterId() {
        return this.tb;
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.tc;
    }

    @Override
    public String getPendingParticipantId() {
        return this.td;
    }

    @Override
    public int getStatus() {
        return this.te;
    }

    @Override
    public int getTurnStatus() {
        return this.tk;
    }

    @Override
    public int getVariant() {
        return this.sv;
    }

    @Override
    public byte[] getData() {
        return this.tg;
    }

    @Override
    public int getVersion() {
        return this.tf;
    }

    @Override
    public String getRematchId() {
        return this.th;
    }

    @Override
    public byte[] getPreviousMatchData() {
        return this.ti;
    }

    @Override
    public int getMatchNumber() {
        return this.tj;
    }

    @Override
    public Bundle getAutoMatchCriteria() {
        return this.sO;
    }

    @Override
    public int getAvailableAutoMatchSlots() {
        if (this.sO == null) {
            return 0;
        }
        return this.sO.getInt("max_automatch_players");
    }

    @Override
    public boolean canRematch() {
        return this.te == 2 && this.th == null;
    }

    @Override
    public boolean isLocallyModified() {
        return this.tl;
    }

    @Override
    public int getParticipantStatus(String participantId) {
        return TurnBasedMatchEntity.a((TurnBasedMatch)this, participantId);
    }

    @Override
    public ArrayList<String> getParticipantIds() {
        return TurnBasedMatchEntity.c(this);
    }

    @Override
    public String getParticipantId(String playerId) {
        return TurnBasedMatchEntity.b(this, playerId);
    }

    @Override
    public Participant getParticipant(String participantId) {
        return TurnBasedMatchEntity.c(this, participantId);
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.su);
    }

    @Override
    public TurnBasedMatch freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return TurnBasedMatchEntity.a(this);
    }

    static int a(TurnBasedMatch turnBasedMatch) {
        return ds.hashCode(turnBasedMatch.getGame(), turnBasedMatch.getMatchId(), turnBasedMatch.getCreatorId(), turnBasedMatch.getCreationTimestamp(), turnBasedMatch.getLastUpdaterId(), turnBasedMatch.getLastUpdatedTimestamp(), turnBasedMatch.getPendingParticipantId(), turnBasedMatch.getStatus(), turnBasedMatch.getTurnStatus(), turnBasedMatch.getVariant(), turnBasedMatch.getVersion(), turnBasedMatch.getParticipants(), turnBasedMatch.getRematchId(), turnBasedMatch.getMatchNumber(), turnBasedMatch.getAutoMatchCriteria(), turnBasedMatch.getAvailableAutoMatchSlots(), turnBasedMatch.isLocallyModified());
    }

    public boolean equals(Object obj) {
        return TurnBasedMatchEntity.a((TurnBasedMatch)this, obj);
    }

    static boolean a(TurnBasedMatch turnBasedMatch, Object object) {
        if (!(object instanceof TurnBasedMatch)) {
            return false;
        }
        if (turnBasedMatch == object) {
            return true;
        }
        TurnBasedMatch turnBasedMatch2 = (TurnBasedMatch)object;
        return ds.equal(turnBasedMatch2.getGame(), turnBasedMatch.getGame()) && ds.equal(turnBasedMatch2.getMatchId(), turnBasedMatch.getMatchId()) && ds.equal(turnBasedMatch2.getCreatorId(), turnBasedMatch.getCreatorId()) && ds.equal(turnBasedMatch2.getCreationTimestamp(), turnBasedMatch.getCreationTimestamp()) && ds.equal(turnBasedMatch2.getLastUpdaterId(), turnBasedMatch.getLastUpdaterId()) && ds.equal(turnBasedMatch2.getLastUpdatedTimestamp(), turnBasedMatch.getLastUpdatedTimestamp()) && ds.equal(turnBasedMatch2.getPendingParticipantId(), turnBasedMatch.getPendingParticipantId()) && ds.equal(turnBasedMatch2.getStatus(), turnBasedMatch.getStatus()) && ds.equal(turnBasedMatch2.getTurnStatus(), turnBasedMatch.getTurnStatus()) && ds.equal(turnBasedMatch2.getVariant(), turnBasedMatch.getVariant()) && ds.equal(turnBasedMatch2.getVersion(), turnBasedMatch.getVersion()) && ds.equal(turnBasedMatch2.getParticipants(), turnBasedMatch.getParticipants()) && ds.equal(turnBasedMatch2.getRematchId(), turnBasedMatch.getRematchId()) && ds.equal(turnBasedMatch2.getMatchNumber(), turnBasedMatch.getMatchNumber()) && ds.equal(turnBasedMatch2.getAutoMatchCriteria(), turnBasedMatch.getAutoMatchCriteria()) && ds.equal(turnBasedMatch2.getAvailableAutoMatchSlots(), turnBasedMatch.getAvailableAutoMatchSlots()) && ds.equal(turnBasedMatch2.isLocallyModified(), turnBasedMatch.isLocallyModified());
    }

    public String toString() {
        return TurnBasedMatchEntity.b(this);
    }

    static String b(TurnBasedMatch turnBasedMatch) {
        return ds.e(turnBasedMatch).a("Game", turnBasedMatch.getGame()).a("MatchId", turnBasedMatch.getMatchId()).a("CreatorId", turnBasedMatch.getCreatorId()).a("CreationTimestamp", turnBasedMatch.getCreationTimestamp()).a("LastUpdaterId", turnBasedMatch.getLastUpdaterId()).a("LastUpdatedTimestamp", turnBasedMatch.getLastUpdatedTimestamp()).a("PendingParticipantId", turnBasedMatch.getPendingParticipantId()).a("MatchStatus", turnBasedMatch.getStatus()).a("TurnStatus", turnBasedMatch.getTurnStatus()).a("Variant", turnBasedMatch.getVariant()).a("Data", turnBasedMatch.getData()).a("Version", turnBasedMatch.getVersion()).a("Participants", turnBasedMatch.getParticipants()).a("RematchId", turnBasedMatch.getRematchId()).a("PreviousData", turnBasedMatch.getPreviousMatchData()).a("MatchNumber", turnBasedMatch.getMatchNumber()).a("AutoMatchCriteria", turnBasedMatch.getAutoMatchCriteria()).a("AvailableAutoMatchSlots", turnBasedMatch.getAvailableAutoMatchSlots()).a("LocallyModified", turnBasedMatch.isLocallyModified()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        TurnBasedMatchEntityCreator.a(this, out, flags);
    }

    static int a(TurnBasedMatch turnBasedMatch, String string2) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = (Participant)arrayList.get(i2);
            if (!participant.getParticipantId().equals(string2)) continue;
            return participant.getStatus();
        }
        throw new IllegalStateException("Participant " + string2 + " is not in match " + turnBasedMatch.getMatchId());
    }

    static ArrayList<String> c(TurnBasedMatch turnBasedMatch) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n2 = arrayList.size();
        ArrayList<String> arrayList2 = new ArrayList<String>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = (Participant)arrayList.get(i2);
            arrayList2.add(participant.getParticipantId());
        }
        return arrayList2;
    }

    static String b(TurnBasedMatch turnBasedMatch, String string2) {
        String string3 = null;
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = (Participant)arrayList.get(i2);
            Player player = participant.getPlayer();
            if (player == null || !player.getPlayerId().equals(string2)) continue;
            string3 = participant.getParticipantId();
            break;
        }
        return string3;
    }

    static Participant c(TurnBasedMatch turnBasedMatch, String string2) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = (Participant)arrayList.get(i2);
            if (!participant.getParticipantId().equals(string2)) continue;
            return participant;
        }
        throw new IllegalStateException("Participant " + string2 + " is not in match " + turnBasedMatch.getMatchId());
    }
}

