/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.os.Bundle;
import com.google.android.gms.internal.du;
import java.util.ArrayList;

public final class TurnBasedMatchConfig {
    private final int sv;
    private final String[] sN;
    private final Bundle sO;
    private final int ta;

    private TurnBasedMatchConfig(Builder builder) {
        this.sv = builder.sv;
        this.ta = builder.ta;
        this.sO = builder.sO;
        int n2 = builder.sR.size();
        this.sN = builder.sR.toArray(new String[n2]);
    }

    public int getVariant() {
        return this.sv;
    }

    public int getMinPlayers() {
        return this.ta;
    }

    public String[] getInvitedPlayerIds() {
        return this.sN;
    }

    public Bundle getAutoMatchCriteria() {
        return this.sO;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Bundle createAutoMatchCriteria(int minAutoMatchPlayers, int maxAutoMatchPlayers, long exclusiveBitMask) {
        Bundle bundle = new Bundle();
        bundle.putInt("min_automatch_players", minAutoMatchPlayers);
        bundle.putInt("max_automatch_players", maxAutoMatchPlayers);
        bundle.putLong("exclusive_bit_mask", exclusiveBitMask);
        return bundle;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Builder {
        int sv = -1;
        ArrayList<String> sR = new ArrayList();
        Bundle sO = null;
        int ta = 2;

        private Builder() {
        }

        public Builder addInvitedPlayer(String playerId) {
            du.f(playerId);
            this.sR.add(playerId);
            return this;
        }

        public Builder addInvitedPlayers(ArrayList<String> playerIds) {
            du.f(playerIds);
            this.sR.addAll(playerIds);
            return this;
        }

        public Builder setVariant(int variant) {
            du.b(variant == -1 || variant > 0, "Variant must be a positive integer or TurnBasedMatch.MATCH_VARIANT_ANY");
            this.sv = variant;
            return this;
        }

        public Builder setMinPlayers(int minPlayers) {
            this.ta = minPlayers;
            return this;
        }

        public Builder setAutoMatchCriteria(Bundle autoMatchCriteria) {
            this.sO = autoMatchCriteria;
            return this;
        }

        public TurnBasedMatchConfig build() {
            return new TurnBasedMatchConfig(this);
        }
    }
}

