/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.realtime;

import android.database.CharArrayBuffer;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.c;
import com.google.android.gms.internal.ds;
import com.google.android.gms.internal.eo;
import com.google.android.gms.internal.ey;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RoomEntity
extends ey
implements Room {
    public static final Parcelable.Creator<RoomEntity> CREATOR = new a();
    private final int kZ;
    private final String rh;
    private final String sS;
    private final long sr;
    private final int sT;
    private final String pZ;
    private final int sv;
    private final Bundle sO;
    private final ArrayList<ParticipantEntity> su;
    private final int sU;

    public RoomEntity(Room room) {
        this.kZ = 2;
        this.rh = room.getRoomId();
        this.sS = room.getCreatorId();
        this.sr = room.getCreationTimestamp();
        this.sT = room.getStatus();
        this.pZ = room.getDescription();
        this.sv = room.getVariant();
        this.sO = room.getAutoMatchCriteria();
        ArrayList arrayList = room.getParticipants();
        int n2 = arrayList.size();
        this.su = new ArrayList(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.su.add((ParticipantEntity)((Participant)arrayList.get(i2)).freeze());
        }
        this.sU = room.getAutoMatchWaitEstimateSeconds();
    }

    RoomEntity(int versionCode, String roomId, String creatorId, long creationTimestamp, int roomStatus, String description, int variant, Bundle autoMatchCriteria, ArrayList<ParticipantEntity> participants, int autoMatchWaitEstimateSeconds) {
        this.kZ = versionCode;
        this.rh = roomId;
        this.sS = creatorId;
        this.sr = creationTimestamp;
        this.sT = roomStatus;
        this.pZ = description;
        this.sv = variant;
        this.sO = autoMatchCriteria;
        this.su = participants;
        this.sU = autoMatchWaitEstimateSeconds;
    }

    public int getVersionCode() {
        return this.kZ;
    }

    @Override
    public String getRoomId() {
        return this.rh;
    }

    @Override
    public String getCreatorId() {
        return this.sS;
    }

    @Override
    public long getCreationTimestamp() {
        return this.sr;
    }

    @Override
    public int getStatus() {
        return this.sT;
    }

    @Override
    public String getDescription() {
        return this.pZ;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        eo.b(this.pZ, dataOut);
    }

    @Override
    public int getVariant() {
        return this.sv;
    }

    @Override
    public Bundle getAutoMatchCriteria() {
        return this.sO;
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.su);
    }

    @Override
    public int getAutoMatchWaitEstimateSeconds() {
        return this.sU;
    }

    @Override
    public int getParticipantStatus(String participantId) {
        return RoomEntity.a((Room)this, participantId);
    }

    @Override
    public ArrayList<String> getParticipantIds() {
        return RoomEntity.c(this);
    }

    @Override
    public String getParticipantId(String playerId) {
        return RoomEntity.b(this, playerId);
    }

    @Override
    public Participant getParticipant(String participantId) {
        return RoomEntity.c(this, participantId);
    }

    @Override
    public Room freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return RoomEntity.a(this);
    }

    static int a(Room room) {
        return ds.hashCode(room.getRoomId(), room.getCreatorId(), room.getCreationTimestamp(), room.getStatus(), room.getDescription(), room.getVariant(), room.getAutoMatchCriteria(), room.getParticipants(), room.getAutoMatchWaitEstimateSeconds());
    }

    public boolean equals(Object obj) {
        return RoomEntity.a((Room)this, obj);
    }

    static boolean a(Room room, Object object) {
        if (!(object instanceof Room)) {
            return false;
        }
        if (room == object) {
            return true;
        }
        Room room2 = (Room)object;
        return ds.equal(room2.getRoomId(), room.getRoomId()) && ds.equal(room2.getCreatorId(), room.getCreatorId()) && ds.equal(room2.getCreationTimestamp(), room.getCreationTimestamp()) && ds.equal(room2.getStatus(), room.getStatus()) && ds.equal(room2.getDescription(), room.getDescription()) && ds.equal(room2.getVariant(), room.getVariant()) && ds.equal(room2.getAutoMatchCriteria(), room.getAutoMatchCriteria()) && ds.equal(room2.getParticipants(), room.getParticipants()) && ds.equal(room2.getAutoMatchWaitEstimateSeconds(), room.getAutoMatchWaitEstimateSeconds());
    }

    public String toString() {
        return RoomEntity.b(this);
    }

    static String b(Room room) {
        return ds.e(room).a("RoomId", room.getRoomId()).a("CreatorId", room.getCreatorId()).a("CreationTimestamp", room.getCreationTimestamp()).a("RoomStatus", room.getStatus()).a("Description", room.getDescription()).a("Variant", room.getVariant()).a("AutoMatchCriteria", room.getAutoMatchCriteria()).a("Participants", room.getParticipants()).a("AutoMatchWaitEstimateSeconds", room.getAutoMatchWaitEstimateSeconds()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.bz()) {
            c.a(this, dest, flags);
        } else {
            dest.writeString(this.rh);
            dest.writeString(this.sS);
            dest.writeLong(this.sr);
            dest.writeInt(this.sT);
            dest.writeString(this.pZ);
            dest.writeInt(this.sv);
            dest.writeBundle(this.sO);
            int n2 = this.su.size();
            dest.writeInt(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                this.su.get(i2).writeToParcel(dest, flags);
            }
        }
    }

    static int a(Room room, String string2) {
        ArrayList arrayList = room.getParticipants();
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = (Participant)arrayList.get(i2);
            if (!participant.getParticipantId().equals(string2)) continue;
            return participant.getStatus();
        }
        throw new IllegalStateException("Participant " + string2 + " is not in room " + room.getRoomId());
    }

    static ArrayList<String> c(Room room) {
        ArrayList arrayList = room.getParticipants();
        int n2 = arrayList.size();
        ArrayList<String> arrayList2 = new ArrayList<String>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = (Participant)arrayList.get(i2);
            arrayList2.add(participant.getParticipantId());
        }
        return arrayList2;
    }

    static String b(Room room, String string2) {
        String string3 = null;
        ArrayList arrayList = room.getParticipants();
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = (Participant)arrayList.get(i2);
            Player player = participant.getPlayer();
            if (player == null || !player.getPlayerId().equals(string2)) continue;
            string3 = participant.getParticipantId();
            break;
        }
        return string3;
    }

    static Participant c(Room room, String string2) {
        ArrayList arrayList = room.getParticipants();
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = (Participant)arrayList.get(i2);
            if (!participant.getParticipantId().equals(string2)) continue;
            return participant;
        }
        throw new IllegalStateException("Participant " + string2 + " is not in match " + room.getRoomId());
    }

    static final class a
    extends c {
        a() {
        }

        public RoomEntity Z(Parcel parcel) {
            int n2;
            boolean bl2 = RoomEntity.c(RoomEntity.by());
            if (bl2 || RoomEntity.D(RoomEntity.class.getCanonicalName())) {
                return super.Z(parcel);
            }
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            long l2 = parcel.readLong();
            int n3 = parcel.readInt();
            String string4 = parcel.readString();
            int n4 = parcel.readInt();
            Bundle bundle = parcel.readBundle();
            int n5 = parcel.readInt();
            ArrayList<ParticipantEntity> arrayList = new ArrayList<ParticipantEntity>(n5);
            for (n2 = 0; n2 < n5; ++n2) {
                arrayList.add((ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel));
            }
            n2 = -1;
            return new RoomEntity(2, string2, string3, l2, n3, string4, n4, bundle, arrayList, n2);
        }

        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.Z(x0);
        }
    }
}

