/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.realtime;

import android.os.Bundle;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessageReceivedListener;
import com.google.android.gms.games.multiplayer.realtime.RoomStatusUpdateListener;
import com.google.android.gms.games.multiplayer.realtime.RoomUpdateListener;
import com.google.android.gms.internal.du;
import java.util.ArrayList;
import java.util.Arrays;

public final class RoomConfig {
    private final RoomUpdateListener sK;
    private final RoomStatusUpdateListener sL;
    private final RealTimeMessageReceivedListener sM;
    private final String rc;
    private final int sv;
    private final String[] sN;
    private final Bundle sO;
    private final boolean sP;

    private RoomConfig(Builder builder) {
        this.sK = builder.sK;
        this.sL = builder.sL;
        this.sM = builder.sM;
        this.rc = builder.sQ;
        this.sv = builder.sv;
        this.sO = builder.sO;
        this.sP = builder.sP;
        int n2 = builder.sR.size();
        this.sN = builder.sR.toArray(new String[n2]);
        if (this.sM == null) {
            du.a(this.sP, "Must either enable sockets OR specify a message listener");
        }
    }

    public RoomUpdateListener getRoomUpdateListener() {
        return this.sK;
    }

    public String getInvitationId() {
        return this.rc;
    }

    public RoomStatusUpdateListener getRoomStatusUpdateListener() {
        return this.sL;
    }

    public RealTimeMessageReceivedListener getMessageReceivedListener() {
        return this.sM;
    }

    public int getVariant() {
        return this.sv;
    }

    public String[] getInvitedPlayerIds() {
        return this.sN;
    }

    public Bundle getAutoMatchCriteria() {
        return this.sO;
    }

    public boolean isSocketEnabled() {
        return this.sP;
    }

    public static Builder builder(RoomUpdateListener listener) {
        return new Builder(listener);
    }

    public static Bundle createAutoMatchCriteria(int minAutoMatchPlayers, int maxAutoMatchPlayers, long exclusiveBitMask) {
        Bundle bundle = new Bundle();
        bundle.putInt("min_automatch_players", minAutoMatchPlayers);
        bundle.putInt("max_automatch_players", maxAutoMatchPlayers);
        bundle.putLong("exclusive_bit_mask", exclusiveBitMask);
        return bundle;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Builder {
        final RoomUpdateListener sK;
        RoomStatusUpdateListener sL;
        RealTimeMessageReceivedListener sM;
        String sQ = null;
        int sv = -1;
        ArrayList<String> sR = new ArrayList();
        Bundle sO;
        boolean sP = false;

        private Builder(RoomUpdateListener updateListener) {
            this.sK = du.c(updateListener, "Must provide a RoomUpdateListener");
        }

        public Builder setInvitationIdToAccept(String invitationId) {
            du.f(invitationId);
            this.sQ = invitationId;
            return this;
        }

        public Builder setRoomStatusUpdateListener(RoomStatusUpdateListener listener) {
            this.sL = listener;
            return this;
        }

        public Builder setMessageReceivedListener(RealTimeMessageReceivedListener listener) {
            this.sM = listener;
            return this;
        }

        public Builder addPlayersToInvite(String ... playerIds) {
            du.f(playerIds);
            this.sR.addAll(Arrays.asList(playerIds));
            return this;
        }

        public Builder addPlayersToInvite(ArrayList<String> playerIds) {
            du.f(playerIds);
            this.sR.addAll(playerIds);
            return this;
        }

        public Builder setVariant(int variant) {
            du.b(variant == -1 || variant > 0, "Variant must be a positive integer or Room.ROOM_VARIANT_ANY");
            this.sv = variant;
            return this;
        }

        public Builder setSocketCommunicationEnabled(boolean enableSockets) {
            this.sP = enableSockets;
            return this;
        }

        public Builder setAutoMatchCriteria(Bundle autoMatchCriteria) {
            this.sO = autoMatchCriteria;
            return this;
        }

        public RoomConfig build() {
            return new RoomConfig(this);
        }
    }
}

