/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantResult;
import com.google.android.gms.games.multiplayer.d;
import com.google.android.gms.internal.ds;
import com.google.android.gms.internal.eo;
import com.google.android.gms.internal.ey;

public final class ParticipantEntity
extends ey
implements Participant {
    public static final Parcelable.Creator<ParticipantEntity> CREATOR = new a();
    private final int kZ;
    private final String rm;
    private final String pW;
    private final Uri qb;
    private final Uri qc;
    private final int sy;
    private final String sz;
    private final boolean sA;
    private final PlayerEntity sB;
    private final int sC;
    private final ParticipantResult sD;

    public ParticipantEntity(Participant participant) {
        this.kZ = 2;
        this.rm = participant.getParticipantId();
        this.pW = participant.getDisplayName();
        this.qb = participant.getIconImageUri();
        this.qc = participant.getHiResImageUri();
        this.sy = participant.getStatus();
        this.sz = participant.dm();
        this.sA = participant.isConnectedToRoom();
        Player player = participant.getPlayer();
        this.sB = player == null ? null : new PlayerEntity(player);
        this.sC = participant.getCapabilities();
        this.sD = participant.getResult();
    }

    ParticipantEntity(int versionCode, String participantId, String displayName, Uri iconImageUri, Uri hiResImageUri, int status, String clientAddress, boolean connectedToRoom, PlayerEntity player, int capabilities, ParticipantResult result) {
        this.kZ = versionCode;
        this.rm = participantId;
        this.pW = displayName;
        this.qb = iconImageUri;
        this.qc = hiResImageUri;
        this.sy = status;
        this.sz = clientAddress;
        this.sA = connectedToRoom;
        this.sB = player;
        this.sC = capabilities;
        this.sD = result;
    }

    public int getVersionCode() {
        return this.kZ;
    }

    public int getStatus() {
        return this.sy;
    }

    public String dm() {
        return this.sz;
    }

    public boolean isConnectedToRoom() {
        return this.sA;
    }

    public String getDisplayName() {
        if (this.sB == null) {
            return this.pW;
        }
        return this.sB.getDisplayName();
    }

    public void getDisplayName(CharArrayBuffer dataOut) {
        if (this.sB == null) {
            eo.b(this.pW, dataOut);
            return;
        }
        this.sB.getDisplayName(dataOut);
    }

    public Uri getIconImageUri() {
        if (this.sB == null) {
            return this.qb;
        }
        return this.sB.getIconImageUri();
    }

    public Uri getHiResImageUri() {
        if (this.sB == null) {
            return this.qc;
        }
        return this.sB.getHiResImageUri();
    }

    public String getParticipantId() {
        return this.rm;
    }

    public Player getPlayer() {
        return this.sB;
    }

    public ParticipantResult getResult() {
        return this.sD;
    }

    public int getCapabilities() {
        return this.sC;
    }

    public Participant freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return ParticipantEntity.a(this);
    }

    static int a(Participant participant) {
        return ds.hashCode(participant.getPlayer(), participant.getStatus(), participant.dm(), participant.isConnectedToRoom(), participant.getDisplayName(), participant.getIconImageUri(), participant.getHiResImageUri(), participant.getCapabilities(), participant.getResult());
    }

    public boolean equals(Object obj) {
        return ParticipantEntity.a(this, obj);
    }

    static boolean a(Participant participant, Object object) {
        if (!(object instanceof Participant)) {
            return false;
        }
        if (participant == object) {
            return true;
        }
        Participant participant2 = (Participant)object;
        return ds.equal(participant2.getPlayer(), participant.getPlayer()) && ds.equal(participant2.getStatus(), participant.getStatus()) && ds.equal(participant2.dm(), participant.dm()) && ds.equal(participant2.isConnectedToRoom(), participant.isConnectedToRoom()) && ds.equal(participant2.getDisplayName(), participant.getDisplayName()) && ds.equal(participant2.getIconImageUri(), participant.getIconImageUri()) && ds.equal(participant2.getHiResImageUri(), participant.getHiResImageUri()) && ds.equal(participant2.getCapabilities(), participant.getCapabilities()) && ds.equal(participant2.getResult(), participant.getResult());
    }

    public String toString() {
        return ParticipantEntity.b(this);
    }

    static String b(Participant participant) {
        return ds.e(participant).a("Player", participant.getPlayer()).a("Status", participant.getStatus()).a("ClientAddress", participant.dm()).a("ConnectedToRoom", participant.isConnectedToRoom()).a("DisplayName", participant.getDisplayName()).a("IconImage", participant.getIconImageUri()).a("HiResImage", participant.getHiResImageUri()).a("Capabilities", participant.getCapabilities()).a("Result", participant.getResult()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.bz()) {
            d.a(this, dest, flags);
        } else {
            dest.writeString(this.rm);
            dest.writeString(this.pW);
            dest.writeString(this.qb == null ? null : this.qb.toString());
            dest.writeString(this.qc == null ? null : this.qc.toString());
            dest.writeInt(this.sy);
            dest.writeString(this.sz);
            dest.writeInt(this.sA ? 1 : 0);
            dest.writeInt(this.sB == null ? 0 : 1);
            if (this.sB != null) {
                this.sB.writeToParcel(dest, flags);
            }
        }
    }

    static final class a
    extends d {
        a() {
        }

        public ParticipantEntity X(Parcel parcel) {
            boolean bl2 = ParticipantEntity.c(ParticipantEntity.by());
            if (bl2 || ParticipantEntity.D(ParticipantEntity.class.getCanonicalName())) {
                return super.X(parcel);
            }
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            Uri uri = string4 == null ? null : Uri.parse((String)string4);
            String string5 = parcel.readString();
            Uri uri2 = string5 == null ? null : Uri.parse((String)string5);
            int n2 = parcel.readInt();
            String string6 = parcel.readString();
            boolean bl3 = parcel.readInt() > 0;
            boolean bl4 = parcel.readInt() > 0;
            int n3 = 7;
            ParticipantResult participantResult = null;
            PlayerEntity playerEntity = bl4 ? (PlayerEntity)PlayerEntity.CREATOR.createFromParcel(parcel) : null;
            return new ParticipantEntity(2, string2, string3, uri, uri2, n2, string6, bl3, playerEntity, n3, participantResult);
        }

        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.X(x0);
        }
    }
}

