/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.internal.ds;
import com.google.android.gms.internal.du;
import com.google.android.gms.internal.ey;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InvitationEntity
extends ey
implements Invitation {
    public static final Parcelable.Creator<InvitationEntity> CREATOR = new a();
    private final int kZ;
    private final GameEntity sq;
    private final String rc;
    private final long sr;
    private final int ss;
    private final ParticipantEntity st;
    private final ArrayList<ParticipantEntity> su;
    private final int sv;

    InvitationEntity(Invitation invitation) {
        this.kZ = 1;
        this.sq = new GameEntity(invitation.getGame());
        this.rc = invitation.getInvitationId();
        this.sr = invitation.getCreationTimestamp();
        this.ss = invitation.getInvitationType();
        this.sv = invitation.getVariant();
        String string2 = invitation.getInviter().getParticipantId();
        Participant participant = null;
        ArrayList arrayList = invitation.getParticipants();
        int n2 = arrayList.size();
        this.su = new ArrayList(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant2 = (Participant)arrayList.get(i2);
            if (participant2.getParticipantId().equals(string2)) {
                participant = participant2;
            }
            this.su.add((ParticipantEntity)participant2.freeze());
        }
        du.c(participant, "Must have a valid inviter!");
        this.st = (ParticipantEntity)participant.freeze();
    }

    InvitationEntity(int versionCode, GameEntity game, String invitationId, long creationTimestamp, int invitationType, ParticipantEntity inviter, ArrayList<ParticipantEntity> participants, int variant) {
        this.kZ = versionCode;
        this.sq = game;
        this.rc = invitationId;
        this.sr = creationTimestamp;
        this.ss = invitationType;
        this.st = inviter;
        this.su = participants;
        this.sv = variant;
    }

    public int getVersionCode() {
        return this.kZ;
    }

    @Override
    public Game getGame() {
        return this.sq;
    }

    @Override
    public String getInvitationId() {
        return this.rc;
    }

    @Override
    public Participant getInviter() {
        return this.st;
    }

    @Override
    public long getCreationTimestamp() {
        return this.sr;
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.su);
    }

    @Override
    public int getInvitationType() {
        return this.ss;
    }

    @Override
    public int getVariant() {
        return this.sv;
    }

    @Override
    public Invitation freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return InvitationEntity.a(this);
    }

    static int a(Invitation invitation) {
        return ds.hashCode(invitation.getGame(), invitation.getInvitationId(), invitation.getCreationTimestamp(), invitation.getInvitationType(), invitation.getInviter(), invitation.getParticipants(), invitation.getVariant());
    }

    public boolean equals(Object obj) {
        return InvitationEntity.a(this, obj);
    }

    static boolean a(Invitation invitation, Object object) {
        if (!(object instanceof Invitation)) {
            return false;
        }
        if (invitation == object) {
            return true;
        }
        Invitation invitation2 = (Invitation)object;
        return ds.equal(invitation2.getGame(), invitation.getGame()) && ds.equal(invitation2.getInvitationId(), invitation.getInvitationId()) && ds.equal(invitation2.getCreationTimestamp(), invitation.getCreationTimestamp()) && ds.equal(invitation2.getInvitationType(), invitation.getInvitationType()) && ds.equal(invitation2.getInviter(), invitation.getInviter()) && ds.equal(invitation2.getParticipants(), invitation.getParticipants()) && ds.equal(invitation2.getVariant(), invitation.getVariant());
    }

    public String toString() {
        return InvitationEntity.b(this);
    }

    static String b(Invitation invitation) {
        return ds.e(invitation).a("Game", invitation.getGame()).a("InvitationId", invitation.getInvitationId()).a("CreationTimestamp", invitation.getCreationTimestamp()).a("InvitationType", invitation.getInvitationType()).a("Inviter", invitation.getInviter()).a("Participants", invitation.getParticipants()).a("Variant", invitation.getVariant()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.bz()) {
            com.google.android.gms.games.multiplayer.a.a(this, dest, flags);
        } else {
            this.sq.writeToParcel(dest, flags);
            dest.writeString(this.rc);
            dest.writeLong(this.sr);
            dest.writeInt(this.ss);
            this.st.writeToParcel(dest, flags);
            int n2 = this.su.size();
            dest.writeInt(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                this.su.get(i2).writeToParcel(dest, flags);
            }
        }
    }

    static final class a
    extends com.google.android.gms.games.multiplayer.a {
        a() {
        }

        public InvitationEntity W(Parcel parcel) {
            int n2;
            boolean bl2 = InvitationEntity.c(InvitationEntity.by());
            if (bl2 || InvitationEntity.D(InvitationEntity.class.getCanonicalName())) {
                return super.W(parcel);
            }
            GameEntity gameEntity = (GameEntity)GameEntity.CREATOR.createFromParcel(parcel);
            String string2 = parcel.readString();
            long l2 = parcel.readLong();
            int n3 = parcel.readInt();
            ParticipantEntity participantEntity = (ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel);
            int n4 = parcel.readInt();
            ArrayList<ParticipantEntity> arrayList = new ArrayList<ParticipantEntity>(n4);
            for (n2 = 0; n2 < n4; ++n2) {
                arrayList.add((ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel));
            }
            n2 = -1;
            return new InvitationEntity(1, gameEntity, string2, l2, n3, participantEntity, arrayList, n2);
        }

        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.W(x0);
        }
    }
}

