/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import com.google.android.gms.internal.ds;
import com.google.android.gms.internal.du;
import com.google.android.gms.internal.eo;

public final class d
implements LeaderboardScore {
    private final long rR;
    private final String rS;
    private final String rT;
    private final long rU;
    private final long rV;
    private final String rW;
    private final Uri rX;
    private final Uri rY;
    private final PlayerEntity rZ;
    private final String sa;

    public d(LeaderboardScore leaderboardScore) {
        this.rR = leaderboardScore.getRank();
        this.rS = du.f(leaderboardScore.getDisplayRank());
        this.rT = du.f(leaderboardScore.getDisplayScore());
        this.rU = leaderboardScore.getRawScore();
        this.rV = leaderboardScore.getTimestampMillis();
        this.rW = leaderboardScore.getScoreHolderDisplayName();
        this.rX = leaderboardScore.getScoreHolderIconImageUri();
        this.rY = leaderboardScore.getScoreHolderHiResImageUri();
        Player player = leaderboardScore.getScoreHolder();
        this.rZ = player == null ? null : (PlayerEntity)player.freeze();
        this.sa = leaderboardScore.getScoreTag();
    }

    public long getRank() {
        return this.rR;
    }

    public String getDisplayRank() {
        return this.rS;
    }

    public void getDisplayRank(CharArrayBuffer dataOut) {
        eo.b(this.rS, dataOut);
    }

    public String getDisplayScore() {
        return this.rT;
    }

    public void getDisplayScore(CharArrayBuffer dataOut) {
        eo.b(this.rT, dataOut);
    }

    public long getRawScore() {
        return this.rU;
    }

    public long getTimestampMillis() {
        return this.rV;
    }

    public String getScoreHolderDisplayName() {
        if (this.rZ == null) {
            return this.rW;
        }
        return this.rZ.getDisplayName();
    }

    public void getScoreHolderDisplayName(CharArrayBuffer dataOut) {
        if (this.rZ == null) {
            eo.b(this.rW, dataOut);
            return;
        }
        this.rZ.getDisplayName(dataOut);
    }

    public Uri getScoreHolderIconImageUri() {
        if (this.rZ == null) {
            return this.rX;
        }
        return this.rZ.getIconImageUri();
    }

    public Uri getScoreHolderHiResImageUri() {
        if (this.rZ == null) {
            return this.rY;
        }
        return this.rZ.getHiResImageUri();
    }

    public Player getScoreHolder() {
        return this.rZ;
    }

    public String getScoreTag() {
        return this.sa;
    }

    public LeaderboardScore dg() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return d.a(this);
    }

    static int a(LeaderboardScore leaderboardScore) {
        return ds.hashCode(leaderboardScore.getRank(), leaderboardScore.getDisplayRank(), leaderboardScore.getRawScore(), leaderboardScore.getDisplayScore(), leaderboardScore.getTimestampMillis(), leaderboardScore.getScoreHolderDisplayName(), leaderboardScore.getScoreHolderIconImageUri(), leaderboardScore.getScoreHolderHiResImageUri(), leaderboardScore.getScoreHolder());
    }

    public boolean equals(Object obj) {
        return d.a(this, obj);
    }

    static boolean a(LeaderboardScore leaderboardScore, Object object) {
        if (!(object instanceof LeaderboardScore)) {
            return false;
        }
        if (leaderboardScore == object) {
            return true;
        }
        LeaderboardScore leaderboardScore2 = (LeaderboardScore)object;
        return ds.equal(leaderboardScore2.getRank(), leaderboardScore.getRank()) && ds.equal(leaderboardScore2.getDisplayRank(), leaderboardScore.getDisplayRank()) && ds.equal(leaderboardScore2.getRawScore(), leaderboardScore.getRawScore()) && ds.equal(leaderboardScore2.getDisplayScore(), leaderboardScore.getDisplayScore()) && ds.equal(leaderboardScore2.getTimestampMillis(), leaderboardScore.getTimestampMillis()) && ds.equal(leaderboardScore2.getScoreHolderDisplayName(), leaderboardScore.getScoreHolderDisplayName()) && ds.equal(leaderboardScore2.getScoreHolderIconImageUri(), leaderboardScore.getScoreHolderIconImageUri()) && ds.equal(leaderboardScore2.getScoreHolderHiResImageUri(), leaderboardScore.getScoreHolderHiResImageUri()) && ds.equal(leaderboardScore2.getScoreHolder(), leaderboardScore.getScoreHolder()) && ds.equal(leaderboardScore2.getScoreTag(), leaderboardScore.getScoreTag());
    }

    public String toString() {
        return d.b(this);
    }

    static String b(LeaderboardScore leaderboardScore) {
        return ds.e(leaderboardScore).a("Rank", leaderboardScore.getRank()).a("DisplayRank", leaderboardScore.getDisplayRank()).a("Score", leaderboardScore.getRawScore()).a("DisplayScore", leaderboardScore.getDisplayScore()).a("Timestamp", leaderboardScore.getTimestampMillis()).a("DisplayName", leaderboardScore.getScoreHolderDisplayName()).a("IconImageUri", leaderboardScore.getScoreHolderIconImageUri()).a("HiResImageUri", leaderboardScore.getScoreHolderHiResImageUri()).a("Player", leaderboardScore.getScoreHolder() == null ? null : leaderboardScore.getScoreHolder()).a("ScoreTag", leaderboardScore.getScoreTag()).toString();
    }

    public /* synthetic */ Object freeze() {
        return this.dg();
    }
}

