/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.internal.ds;
import com.google.android.gms.internal.du;
import com.google.android.gms.internal.fh;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SubmitScoreResult {
    private static final String[] so = new String[]{"leaderboardId", "playerId", "timeSpan", "hasResult", "rawScore", "formattedScore", "newBest", "scoreTag"};
    private String rL;
    private String qK;
    private int ka;
    private HashMap<Integer, Result> sp;

    public SubmitScoreResult(int statusCode, String leaderboardId, String playerId, HashMap<Integer, Result> results) {
        this.ka = statusCode;
        this.rL = leaderboardId;
        this.qK = playerId;
        this.sp = results;
    }

    public SubmitScoreResult(int statusCode, String leaderboardId, String playerId) {
        this(statusCode, leaderboardId, playerId, new HashMap<Integer, Result>());
    }

    public SubmitScoreResult(DataHolder dataHolder) {
        this.ka = dataHolder.getStatusCode();
        this.sp = new HashMap();
        int n2 = dataHolder.getCount();
        du.p(n2 == 3);
        for (int i2 = 0; i2 < n2; ++i2) {
            boolean bl2;
            int n3 = dataHolder.t(i2);
            if (i2 == 0) {
                this.rL = dataHolder.getString("leaderboardId", i2, n3);
                this.qK = dataHolder.getString("playerId", i2, n3);
            }
            if (!(bl2 = dataHolder.getBoolean("hasResult", i2, n3))) continue;
            Result result = new Result(dataHolder.getLong("rawScore", i2, n3), dataHolder.getString("formattedScore", i2, n3), dataHolder.getString("scoreTag", i2, n3), dataHolder.getBoolean("newBest", i2, n3));
            this.a(result, dataHolder.getInteger("timeSpan", i2, n3));
        }
    }

    public String getLeaderboardId() {
        return this.rL;
    }

    public String getPlayerId() {
        return this.qK;
    }

    public int getStatusCode() {
        return this.ka;
    }

    public Result getScoreResult(int timeSpan) {
        return this.sp.get(timeSpan);
    }

    private void a(Result result, int n2) {
        this.sp.put(n2, result);
    }

    public String toString() {
        ds.a a2 = ds.e(this).a("PlayerId", this.qK).a("StatusCode", this.ka);
        for (int i2 = 0; i2 < 3; ++i2) {
            Result result = this.sp.get(i2);
            a2.a("TimesSpan", fh.at(i2));
            a2.a("Result", result == null ? "null" : result.toString());
        }
        return a2.toString();
    }

    public static final class Result {
        public final long rawScore;
        public final String formattedScore;
        public final String scoreTag;
        public final boolean newBest;

        public Result(long rawScore, String formattedScore, String scoreTag, boolean newBest) {
            this.rawScore = rawScore;
            this.formattedScore = formattedScore;
            this.scoreTag = scoreTag;
            this.newBest = newBest;
        }

        public String toString() {
            return ds.e(this).a("RawScore", this.rawScore).a("FormattedScore", this.formattedScore).a("ScoreTag", this.scoreTag).a("NewBest", this.newBest).toString();
        }
    }
}

