/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.d;
import com.google.android.gms.internal.dg;
import com.google.android.gms.internal.ds;
import com.google.android.gms.internal.eo;
import com.google.android.gms.internal.ey;

public final class PlayerEntity
extends ey
implements Player {
    public static final Parcelable.Creator<PlayerEntity> CREATOR = new a();
    private final int kZ;
    private final String qK;
    private final String pW;
    private final Uri qb;
    private final Uri qc;
    private final long qL;

    public PlayerEntity(Player player) {
        this.kZ = 1;
        this.qK = player.getPlayerId();
        this.pW = player.getDisplayName();
        this.qb = player.getIconImageUri();
        this.qc = player.getHiResImageUri();
        this.qL = player.getRetrievedTimestamp();
        dg.d(this.qK);
        dg.d(this.pW);
        dg.n(this.qL > 0L);
    }

    PlayerEntity(int versionCode, String playerId, String displayName, Uri iconImageUri, Uri hiResImageUri, long retrievedTimestamp) {
        this.kZ = versionCode;
        this.qK = playerId;
        this.pW = displayName;
        this.qb = iconImageUri;
        this.qc = hiResImageUri;
        this.qL = retrievedTimestamp;
    }

    public int getVersionCode() {
        return this.kZ;
    }

    public String getPlayerId() {
        return this.qK;
    }

    public String getDisplayName() {
        return this.pW;
    }

    public void getDisplayName(CharArrayBuffer dataOut) {
        eo.b(this.pW, dataOut);
    }

    public boolean hasIconImage() {
        return this.getIconImageUri() != null;
    }

    public Uri getIconImageUri() {
        return this.qb;
    }

    public boolean hasHiResImage() {
        return this.getHiResImageUri() != null;
    }

    public Uri getHiResImageUri() {
        return this.qc;
    }

    public long getRetrievedTimestamp() {
        return this.qL;
    }

    public Player freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return PlayerEntity.a(this);
    }

    static int a(Player player) {
        return ds.hashCode(player.getPlayerId(), player.getDisplayName(), player.getIconImageUri(), player.getHiResImageUri(), player.getRetrievedTimestamp());
    }

    public boolean equals(Object obj) {
        return PlayerEntity.a(this, obj);
    }

    static boolean a(Player player, Object object) {
        if (!(object instanceof Player)) {
            return false;
        }
        if (player == object) {
            return true;
        }
        Player player2 = (Player)object;
        return ds.equal(player2.getPlayerId(), player.getPlayerId()) && ds.equal(player2.getDisplayName(), player.getDisplayName()) && ds.equal(player2.getIconImageUri(), player.getIconImageUri()) && ds.equal(player2.getHiResImageUri(), player.getHiResImageUri()) && ds.equal(player2.getRetrievedTimestamp(), player.getRetrievedTimestamp());
    }

    public String toString() {
        return PlayerEntity.b(this);
    }

    static String b(Player player) {
        return ds.e(player).a("PlayerId", player.getPlayerId()).a("DisplayName", player.getDisplayName()).a("IconImageUri", player.getIconImageUri()).a("HiResImageUri", player.getHiResImageUri()).a("RetrievedTimestamp", player.getRetrievedTimestamp()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.bz()) {
            d.a(this, dest, flags);
        } else {
            dest.writeString(this.qK);
            dest.writeString(this.pW);
            dest.writeString(this.qb == null ? null : this.qb.toString());
            dest.writeString(this.qc == null ? null : this.qc.toString());
            dest.writeLong(this.qL);
        }
    }

    static final class a
    extends d {
        a() {
        }

        public PlayerEntity V(Parcel parcel) {
            boolean bl2 = PlayerEntity.c(PlayerEntity.by());
            if (bl2 || PlayerEntity.D(PlayerEntity.class.getCanonicalName())) {
                return super.V(parcel);
            }
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            String string5 = parcel.readString();
            Uri uri = string4 == null ? null : Uri.parse((String)string4);
            Uri uri2 = string5 == null ? null : Uri.parse((String)string5);
            long l2 = parcel.readLong();
            return new PlayerEntity(1, string2, string3, uri, uri2, l2);
        }

        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.V(x0);
        }
    }
}

