/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.content.Context;
import android.content.Intent;
import android.view.View;
import com.google.android.gms.common.GooglePlayServicesClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.a;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.OnGamesLoadedListener;
import com.google.android.gms.games.OnPlayersLoadedListener;
import com.google.android.gms.games.OnSignOutCompleteListener;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.achievement.OnAchievementUpdatedListener;
import com.google.android.gms.games.achievement.OnAchievementsLoadedListener;
import com.google.android.gms.games.achievement.b;
import com.google.android.gms.games.c;
import com.google.android.gms.games.f;
import com.google.android.gms.games.leaderboard.LeaderboardScoreBuffer;
import com.google.android.gms.games.leaderboard.OnLeaderboardMetadataLoadedListener;
import com.google.android.gms.games.leaderboard.OnLeaderboardScoresLoadedListener;
import com.google.android.gms.games.leaderboard.OnPlayerLeaderboardScoreLoadedListener;
import com.google.android.gms.games.leaderboard.OnScoreSubmittedListener;
import com.google.android.gms.games.leaderboard.SubmitScoreResult;
import com.google.android.gms.games.leaderboard.h;
import com.google.android.gms.games.multiplayer.OnInvitationReceivedListener;
import com.google.android.gms.games.multiplayer.OnInvitationsLoadedListener;
import com.google.android.gms.games.multiplayer.ParticipantResult;
import com.google.android.gms.games.multiplayer.c;
import com.google.android.gms.games.multiplayer.realtime.RealTimeReliableMessageSentListener;
import com.google.android.gms.games.multiplayer.realtime.RealTimeSocket;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.RoomConfig;
import com.google.android.gms.games.multiplayer.realtime.RoomUpdateListener;
import com.google.android.gms.games.multiplayer.realtime.a;
import com.google.android.gms.games.multiplayer.turnbased.OnTurnBasedMatchCanceledListener;
import com.google.android.gms.games.multiplayer.turnbased.OnTurnBasedMatchInitiatedListener;
import com.google.android.gms.games.multiplayer.turnbased.OnTurnBasedMatchLeftListener;
import com.google.android.gms.games.multiplayer.turnbased.OnTurnBasedMatchLoadedListener;
import com.google.android.gms.games.multiplayer.turnbased.OnTurnBasedMatchUpdateReceivedListener;
import com.google.android.gms.games.multiplayer.turnbased.OnTurnBasedMatchUpdatedListener;
import com.google.android.gms.games.multiplayer.turnbased.OnTurnBasedMatchesLoadedListener;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchConfig;
import com.google.android.gms.games.multiplayer.turnbased.b;
import com.google.android.gms.internal.du;
import com.google.android.gms.internal.ex;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GamesClient
implements GooglePlayServicesClient {
    public static final int NOTIFICATION_TYPE_INVITATION = 1;
    public static final int NOTIFICATION_TYPE_MATCH_UPDATE = 2;
    public static final int NOTIFICATION_TYPES_ALL = -1;
    public static final int NOTIFICATION_TYPES_MULTIPLAYER = 3;
    public static final String EXTRA_PLAYERS = "players";
    public static final String EXTRA_MIN_AUTOMATCH_PLAYERS = "min_automatch_players";
    public static final String EXTRA_MAX_AUTOMATCH_PLAYERS = "max_automatch_players";
    public static final String EXTRA_PLAYER_SEARCH_RESULTS = "player_search_results";
    public static final String EXTRA_ROOM = "room";
    public static final String EXTRA_EXCLUSIVE_BIT_MASK = "exclusive_bit_mask";
    public static final String EXTRA_INVITATION = "invitation";
    public static final String EXTRA_TURN_BASED_MATCH = "turn_based_match";
    public static final int MAX_UNRELIABLE_MESSAGE_LEN = 1168;
    public static final int MAX_RELIABLE_MESSAGE_LEN = 1400;
    public static final int STATUS_OK = 0;
    public static final int STATUS_INTERNAL_ERROR = 1;
    public static final int STATUS_CLIENT_RECONNECT_REQUIRED = 2;
    public static final int STATUS_NETWORK_ERROR_STALE_DATA = 3;
    public static final int STATUS_NETWORK_ERROR_NO_DATA = 4;
    public static final int STATUS_NETWORK_ERROR_OPERATION_DEFERRED = 5;
    public static final int STATUS_NETWORK_ERROR_OPERATION_FAILED = 6;
    public static final int STATUS_LICENSE_CHECK_FAILED = 7;
    public static final int STATUS_APP_MISCONFIGURED = 8;
    public static final int STATUS_GAME_NOT_FOUND = 9;
    public static final int STATUS_ACHIEVEMENT_UNLOCK_FAILURE = 3000;
    public static final int STATUS_ACHIEVEMENT_UNKNOWN = 3001;
    public static final int STATUS_ACHIEVEMENT_NOT_INCREMENTAL = 3002;
    public static final int STATUS_ACHIEVEMENT_UNLOCKED = 3003;
    public static final int STATUS_MULTIPLAYER_ERROR_CREATION_NOT_ALLOWED = 6000;
    public static final int STATUS_MULTIPLAYER_ERROR_NOT_TRUSTED_TESTER = 6001;
    public static final int STATUS_MULTIPLAYER_ERROR_INVALID_MULTIPLAYER_TYPE = 6002;
    public static final int STATUS_MULTIPLAYER_DISABLED = 6003;
    public static final int STATUS_MULTIPLAYER_ERROR_INVALID_OPERATION = 6004;
    public static final int STATUS_MATCH_ERROR_INVALID_PARTICIPANT_STATE = 6500;
    public static final int STATUS_MATCH_ERROR_INACTIVE_MATCH = 6501;
    public static final int STATUS_MATCH_ERROR_INVALID_MATCH_STATE = 6502;
    public static final int STATUS_MATCH_ERROR_OUT_OF_DATE_VERSION = 6503;
    public static final int STATUS_MATCH_ERROR_INVALID_MATCH_RESULTS = 6504;
    public static final int STATUS_MATCH_ERROR_ALREADY_REMATCHED = 6505;
    public static final int STATUS_MATCH_NOT_FOUND = 6506;
    public static final int STATUS_MATCH_ERROR_LOCALLY_MODIFIED = 6507;
    public static final int STATUS_REAL_TIME_CONNECTION_FAILED = 7000;
    public static final int STATUS_REAL_TIME_MESSAGE_SEND_FAILED = 7001;
    public static final int STATUS_INVALID_REAL_TIME_ROOM_ID = 7002;
    public static final int STATUS_PARTICIPANT_NOT_CONNECTED = 7003;
    public static final int STATUS_REAL_TIME_ROOM_NOT_JOINED = 7004;
    public static final int STATUS_REAL_TIME_INACTIVE_ROOM = 7005;
    public static final int STATUS_OPERATION_IN_FLIGHT = 7007;
    public static final int STATUS_REAL_TIME_MESSAGE_FAILED = -1;
    private final ex qm;

    private GamesClient(Context context, String gamePackageName, String accountName, GooglePlayServicesClient.ConnectionCallbacks connectedListener, GooglePlayServicesClient.OnConnectionFailedListener connectionFailedListener, String[] scopes, int gravity, View gamesContentView, boolean showConnectingPopup, int connectingPopupGravity) {
        this.qm = new ex(context, gamePackageName, accountName, connectedListener, connectionFailedListener, scopes, gravity, gamesContentView, false, showConnectingPopup, connectingPopupGravity);
    }

    public void setGravityForPopups(int gravity) {
        this.qm.setGravityForPopups(gravity);
    }

    public void setViewForPopups(View gamesContentView) {
        du.f(gamesContentView);
        this.qm.setViewForPopups(gamesContentView);
    }

    @Override
    public void connect() {
        this.qm.connect();
    }

    @Override
    public boolean isConnected() {
        return this.qm.isConnected();
    }

    @Override
    public boolean isConnecting() {
        return this.qm.isConnecting();
    }

    @Override
    public void registerConnectionCallbacks(GooglePlayServicesClient.ConnectionCallbacks listener) {
        this.qm.registerConnectionCallbacks(listener);
    }

    @Override
    public boolean isConnectionCallbacksRegistered(GooglePlayServicesClient.ConnectionCallbacks listener) {
        return this.qm.isConnectionCallbacksRegistered(listener);
    }

    @Override
    public void unregisterConnectionCallbacks(GooglePlayServicesClient.ConnectionCallbacks listener) {
        this.qm.unregisterConnectionCallbacks(listener);
    }

    @Override
    public void registerConnectionFailedListener(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        this.qm.registerConnectionFailedListener(listener);
    }

    @Override
    public boolean isConnectionFailedListenerRegistered(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        return this.qm.isConnectionFailedListenerRegistered(listener);
    }

    @Override
    public void unregisterConnectionFailedListener(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        this.qm.unregisterConnectionFailedListener(listener);
    }

    @Override
    public void disconnect() {
        this.qm.disconnect();
    }

    public void reconnect() {
        this.qm.disconnect();
        this.qm.connect();
    }

    public String getCurrentAccountName() {
        return this.qm.getCurrentAccountName();
    }

    public String getCurrentPlayerId() {
        return this.qm.getCurrentPlayerId();
    }

    public Player getCurrentPlayer() {
        return this.qm.getCurrentPlayer();
    }

    public Game getCurrentGame() {
        return this.qm.getCurrentGame();
    }

    public void loadPlayer(final OnPlayersLoadedListener listener, String playerId) {
        this.qm.a(new a.c<f.a>(){

            @Override
            public void a(f.a a2) {
                listener.onPlayersLoaded(a2.getStatus().getStatusCode(), a2.cJ());
            }
        }, playerId);
    }

    public void loadInvitablePlayers(final OnPlayersLoadedListener listener, int pageSize, boolean forceReload) {
        this.qm.a(new a.c<f.a>(){

            @Override
            public void a(f.a a2) {
                listener.onPlayersLoaded(a2.getStatus().getStatusCode(), a2.cJ());
            }
        }, pageSize, false, forceReload);
    }

    public void loadMoreInvitablePlayers(final OnPlayersLoadedListener listener, int pageSize) {
        this.qm.a(new a.c<f.a>(){

            @Override
            public void a(f.a a2) {
                listener.onPlayersLoaded(a2.getStatus().getStatusCode(), a2.cJ());
            }
        }, pageSize, true, false);
    }

    public Intent getAllLeaderboardsIntent() {
        return this.qm.getAllLeaderboardsIntent();
    }

    public Intent getLeaderboardIntent(String leaderboardId) {
        return this.qm.getLeaderboardIntent(leaderboardId);
    }

    public void loadLeaderboardMetadata(final OnLeaderboardMetadataLoadedListener listener, boolean forceReload) {
        this.qm.a(new a.c<h.a>(){

            @Override
            public void a(h.a a2) {
                int n2 = a2.getStatus().getStatusCode();
                listener.onLeaderboardMetadataLoaded(n2, a2.cQ());
            }
        }, forceReload);
    }

    public void loadLeaderboardMetadata(final OnLeaderboardMetadataLoadedListener listener, String leaderboardId, boolean forceReload) {
        this.qm.a(new a.c<h.a>(){

            @Override
            public void a(h.a a2) {
                int n2 = a2.getStatus().getStatusCode();
                listener.onLeaderboardMetadataLoaded(n2, a2.cQ());
            }
        }, leaderboardId, forceReload);
    }

    public void loadCurrentPlayerLeaderboardScore(final OnPlayerLeaderboardScoreLoadedListener listener, String leaderboardId, int span, int leaderboardCollection) {
        this.qm.a(new a.c<h.b>(){

            @Override
            public void a(h.b b2) {
                int n2 = b2.getStatus().getStatusCode();
                listener.onPlayerLeaderboardScoreLoaded(n2, b2.cR());
            }
        }, null, leaderboardId, span, leaderboardCollection);
    }

    public void loadTopScores(final OnLeaderboardScoresLoadedListener listener, String leaderboardId, int span, int leaderboardCollection, int maxResults) {
        this.qm.a(new a.c<h.c>(){

            @Override
            public void a(h.c c2) {
                int n2 = c2.getStatus().getStatusCode();
                listener.onLeaderboardScoresLoaded(n2, c2.cO(), c2.cP());
            }
        }, leaderboardId, span, leaderboardCollection, maxResults, false);
    }

    public void loadTopScores(final OnLeaderboardScoresLoadedListener listener, String leaderboardId, int span, int leaderboardCollection, int maxResults, boolean forceReload) {
        this.qm.a(new a.c<h.c>(){

            @Override
            public void a(h.c c2) {
                int n2 = c2.getStatus().getStatusCode();
                listener.onLeaderboardScoresLoaded(n2, c2.cO(), c2.cP());
            }
        }, leaderboardId, span, leaderboardCollection, maxResults, forceReload);
    }

    public void loadPlayerCenteredScores(final OnLeaderboardScoresLoadedListener listener, String leaderboardId, int span, int leaderboardCollection, int maxResults) {
        this.qm.b(new a.c<h.c>(){

            @Override
            public void a(h.c c2) {
                int n2 = c2.getStatus().getStatusCode();
                listener.onLeaderboardScoresLoaded(n2, c2.cO(), c2.cP());
            }
        }, leaderboardId, span, leaderboardCollection, maxResults, false);
    }

    public void loadPlayerCenteredScores(final OnLeaderboardScoresLoadedListener listener, String leaderboardId, int span, int leaderboardCollection, int maxResults, boolean forceReload) {
        this.qm.b(new a.c<h.c>(){

            @Override
            public void a(h.c c2) {
                int n2 = c2.getStatus().getStatusCode();
                listener.onLeaderboardScoresLoaded(n2, c2.cO(), c2.cP());
            }
        }, leaderboardId, span, leaderboardCollection, maxResults, forceReload);
    }

    public void loadMoreScores(final OnLeaderboardScoresLoadedListener listener, LeaderboardScoreBuffer buffer, int maxResults, int pageDirection) {
        this.qm.a(new a.c<h.c>(){

            @Override
            public void a(h.c c2) {
                int n2 = c2.getStatus().getStatusCode();
                listener.onLeaderboardScoresLoaded(n2, c2.cO(), c2.cP());
            }
        }, buffer, maxResults, pageDirection);
    }

    public void submitScore(String leaderboardId, long score) {
        this.qm.a(null, leaderboardId, score, null);
    }

    public void submitScore(String leaderboardId, long score, String scoreTag) {
        this.qm.a(null, leaderboardId, score, scoreTag);
    }

    public void submitScoreImmediate(final OnScoreSubmittedListener listener, String leaderboardId, long score) {
        this.qm.a(new a.c<h.d>(){

            @Override
            public void a(h.d d2) {
                int n2 = d2.getStatus().getStatusCode();
                DataHolder dataHolder = d2.cS().dl();
                SubmitScoreResult submitScoreResult = new SubmitScoreResult(dataHolder);
                listener.onScoreSubmitted(n2, submitScoreResult);
            }
        }, leaderboardId, score, null);
    }

    public void submitScoreImmediate(final OnScoreSubmittedListener listener, String leaderboardId, long score, String scoreTag) {
        this.qm.a(new a.c<h.d>(){

            @Override
            public void a(h.d d2) {
                int n2 = d2.getStatus().getStatusCode();
                DataHolder dataHolder = d2.cS().dl();
                SubmitScoreResult submitScoreResult = new SubmitScoreResult(dataHolder);
                listener.onScoreSubmitted(n2, submitScoreResult);
            }
        }, leaderboardId, score, scoreTag);
    }

    public Intent getAchievementsIntent() {
        return this.qm.getAchievementsIntent();
    }

    public void loadAchievements(final OnAchievementsLoadedListener listener, boolean forceReload) {
        this.qm.b(new a.c<b.a>(){

            @Override
            public void a(b.a a2) {
                int n2 = a2.getStatus().getStatusCode();
                listener.onAchievementsLoaded(n2, a2.cK());
            }
        }, forceReload);
    }

    public void revealAchievement(String id) {
        this.qm.b(null, id);
    }

    public void revealAchievementImmediate(final OnAchievementUpdatedListener listener, String id) {
        this.qm.b(new a.c<b.b>(){

            @Override
            public void a(b.b b2) {
                int n2 = b2.getStatus().getStatusCode();
                listener.onAchievementUpdated(n2, b2.getAchievementId());
            }
        }, id);
    }

    public void unlockAchievement(String id) {
        this.qm.c(null, id);
    }

    public void unlockAchievementImmediate(final OnAchievementUpdatedListener listener, String id) {
        this.qm.c(new a.c<b.b>(){

            @Override
            public void a(b.b b2) {
                int n2 = b2.getStatus().getStatusCode();
                listener.onAchievementUpdated(n2, b2.getAchievementId());
            }
        }, id);
    }

    public void incrementAchievement(String id, int numSteps) {
        this.qm.a(null, id, numSteps);
    }

    public void incrementAchievementImmediate(final OnAchievementUpdatedListener listener, String id, int numSteps) {
        this.qm.a(new a.c<b.b>(){

            @Override
            public void a(b.b b2) {
                int n2 = b2.getStatus().getStatusCode();
                listener.onAchievementUpdated(n2, b2.getAchievementId());
            }
        }, id, numSteps);
    }

    public void setAchievementSteps(String id, int numSteps) {
        this.qm.b(null, id, numSteps);
    }

    public void setAchievementStepsImmediate(final OnAchievementUpdatedListener listener, String id, int numSteps) {
        this.qm.b(new a.c<b.b>(){

            @Override
            public void a(b.b b2) {
                int n2 = b2.getStatus().getStatusCode();
                listener.onAchievementUpdated(n2, b2.getAchievementId());
            }
        }, id, numSteps);
    }

    public Intent getMatchInboxIntent() {
        return this.qm.getMatchInboxIntent();
    }

    public Intent getInvitationInboxIntent() {
        return this.qm.getInvitationInboxIntent();
    }

    public void registerInvitationListener(OnInvitationReceivedListener listener) {
        this.qm.registerInvitationListener(listener);
    }

    public void unregisterInvitationListener() {
        this.qm.unregisterInvitationListener();
    }

    public void registerMatchUpdateListener(OnTurnBasedMatchUpdateReceivedListener listener) {
        this.qm.registerMatchUpdateListener(listener);
    }

    public void unregisterMatchUpdateListener() {
        this.qm.unregisterMatchUpdateListener();
    }

    public Intent getSelectPlayersIntent(int minPlayers, int maxPlayers) {
        return this.qm.getSelectPlayersIntent(minPlayers, maxPlayers, true);
    }

    public Intent getSelectPlayersIntent(int minPlayers, int maxPlayers, boolean allowAutomatch) {
        return this.qm.getSelectPlayersIntent(minPlayers, maxPlayers, allowAutomatch);
    }

    public Intent getPlayerSearchIntent() {
        return this.qm.getPlayerSearchIntent();
    }

    public Intent getRealTimeWaitingRoomIntent(Room room, int minParticipantsToStart) {
        return this.qm.getRealTimeWaitingRoomIntent(room, minParticipantsToStart);
    }

    public Intent getSettingsIntent() {
        return this.qm.getSettingsIntent();
    }

    public void loadGame(final OnGamesLoadedListener listener) {
        this.qm.d(new a.c<c.a>(){

            @Override
            public void a(c.a a2) {
                listener.onGamesLoaded(a2.getStatus().getStatusCode(), a2.cI());
            }
        });
    }

    public void signOut() {
        this.qm.b(new a.c<Status>(){

            @Override
            public void a(Status status) {
            }
        });
    }

    public void signOut(final OnSignOutCompleteListener listener) {
        this.qm.b(new a.c<Status>(){

            @Override
            public void a(Status status) {
                listener.onSignOutComplete();
            }
        });
    }

    public String getAppId() {
        return this.qm.getAppId();
    }

    public void createTurnBasedMatch(final OnTurnBasedMatchInitiatedListener listener, TurnBasedMatchConfig config) {
        this.qm.a(new a.c<b.b>(){

            @Override
            public void a(b.b b2) {
                int n2 = b2.getStatus().getStatusCode();
                listener.onTurnBasedMatchInitiated(n2, b2.cT());
            }
        }, config);
    }

    public void rematchTurnBasedMatch(final OnTurnBasedMatchInitiatedListener listener, String matchId) {
        this.qm.d(new a.c<b.b>(){

            @Override
            public void a(b.b b2) {
                int n2 = b2.getStatus().getStatusCode();
                listener.onTurnBasedMatchInitiated(n2, b2.cT());
            }
        }, matchId);
    }

    public void acceptTurnBasedInvitation(final OnTurnBasedMatchInitiatedListener listener, String invitationId) {
        this.qm.e(new a.c<b.b>(){

            @Override
            public void a(b.b b2) {
                int n2 = b2.getStatus().getStatusCode();
                listener.onTurnBasedMatchInitiated(n2, b2.cT());
            }
        }, invitationId);
    }

    public void declineTurnBasedInvitation(String invitationId) {
        this.qm.i(invitationId, 1);
    }

    public void dismissTurnBasedInvitation(String invitationId) {
        this.qm.h(invitationId, 1);
    }

    public int getMaxTurnBasedMatchDataSize() {
        return this.qm.getMaxTurnBasedMatchDataSize();
    }

    public void takeTurn(final OnTurnBasedMatchUpdatedListener listener, String matchId, byte[] matchData, String pendingParticipantId) {
        this.qm.a(new a.c<b.f>(){

            @Override
            public void a(b.f f2) {
                int n2 = f2.getStatus().getStatusCode();
                listener.onTurnBasedMatchUpdated(n2, f2.cT());
            }
        }, matchId, matchData, pendingParticipantId, null);
    }

    public void takeTurn(final OnTurnBasedMatchUpdatedListener listener, String matchId, byte[] matchData, String pendingParticipantId, ParticipantResult ... results) {
        this.qm.a(new a.c<b.f>(){

            @Override
            public void a(b.f f2) {
                int n2 = f2.getStatus().getStatusCode();
                listener.onTurnBasedMatchUpdated(n2, f2.cT());
            }
        }, matchId, matchData, pendingParticipantId, results);
    }

    public void takeTurn(final OnTurnBasedMatchUpdatedListener listener, String matchId, byte[] matchData, String pendingParticipantId, List<ParticipantResult> results) {
        ParticipantResult[] participantResultArray = results == null ? null : results.toArray(new ParticipantResult[results.size()]);
        this.qm.a(new a.c<b.f>(){

            @Override
            public void a(b.f f2) {
                int n2 = f2.getStatus().getStatusCode();
                listener.onTurnBasedMatchUpdated(n2, f2.cT());
            }
        }, matchId, matchData, pendingParticipantId, participantResultArray);
    }

    public void finishTurnBasedMatch(final OnTurnBasedMatchUpdatedListener listener, String matchId) {
        this.qm.a(new a.c<b.f>(){

            @Override
            public void a(b.f f2) {
                int n2 = f2.getStatus().getStatusCode();
                listener.onTurnBasedMatchUpdated(n2, f2.cT());
            }
        }, matchId, null, null);
    }

    public void finishTurnBasedMatch(final OnTurnBasedMatchUpdatedListener listener, String matchId, byte[] matchData, ParticipantResult ... results) {
        this.qm.a(new a.c<b.f>(){

            @Override
            public void a(b.f f2) {
                int n2 = f2.getStatus().getStatusCode();
                listener.onTurnBasedMatchUpdated(n2, f2.cT());
            }
        }, matchId, matchData, results);
    }

    public void finishTurnBasedMatch(OnTurnBasedMatchUpdatedListener listener, String matchId, byte[] matchData, List<ParticipantResult> results) {
        ParticipantResult[] participantResultArray = results == null ? null : results.toArray(new ParticipantResult[results.size()]);
        this.finishTurnBasedMatch(listener, matchId, matchData, participantResultArray);
    }

    public void leaveTurnBasedMatch(final OnTurnBasedMatchLeftListener listener, String matchId) {
        this.qm.f(new a.c<b.c>(){

            @Override
            public void a(b.c c2) {
                int n2 = c2.getStatus().getStatusCode();
                listener.onTurnBasedMatchLeft(n2, c2.cT());
            }
        }, matchId);
    }

    public void leaveTurnBasedMatchDuringTurn(final OnTurnBasedMatchLeftListener listener, String matchId, String pendingParticipantId) {
        this.qm.a(new a.c<b.c>(){

            @Override
            public void a(b.c c2) {
                int n2 = c2.getStatus().getStatusCode();
                listener.onTurnBasedMatchLeft(n2, c2.cT());
            }
        }, matchId, pendingParticipantId);
    }

    public void cancelTurnBasedMatch(final OnTurnBasedMatchCanceledListener listener, String matchId) {
        this.qm.g(new a.c<b.a>(){

            @Override
            public void a(b.a a2) {
                int n2 = a2.getStatus().getStatusCode();
                listener.onTurnBasedMatchCanceled(n2, a2.getMatchId());
            }
        }, matchId);
    }

    public void cancelTurnBasedMatch(String matchId) {
        this.qm.g(new a.c<b.a>(){

            @Override
            public void a(b.a a2) {
            }
        }, matchId);
    }

    public void dismissTurnBasedMatch(String matchId) {
        this.qm.dismissTurnBasedMatch(matchId);
    }

    public void createRoom(RoomConfig config) {
        this.qm.createRoom(config);
    }

    public void joinRoom(RoomConfig config) {
        this.qm.joinRoom(config);
    }

    public void leaveRoom(RoomUpdateListener listener, String roomId) {
        this.qm.leaveRoom(listener, roomId);
    }

    public int sendReliableRealTimeMessage(final RealTimeReliableMessageSentListener listener, byte[] messageData, String roomId, String recipientParticipantId) {
        return this.qm.a(new a.a(){

            public void onRealTimeMessageSent(int statusCode, int tokenId, String recipientParticipantId) {
                listener.onRealTimeMessageSent(statusCode, tokenId, recipientParticipantId);
            }
        }, messageData, roomId, recipientParticipantId);
    }

    public int sendUnreliableRealTimeMessage(byte[] messageData, String roomId, String recipientParticipantId) {
        return this.qm.a(messageData, roomId, new String[]{recipientParticipantId});
    }

    public int sendUnreliableRealTimeMessage(byte[] messageData, String roomId, List<String> recipientParticipantIds) {
        String[] stringArray = recipientParticipantIds.toArray(new String[recipientParticipantIds.size()]);
        return this.qm.a(messageData, roomId, stringArray);
    }

    public int sendUnreliableRealTimeMessageToAll(byte[] messageData, String roomId) {
        return this.qm.sendUnreliableRealTimeMessageToAll(messageData, roomId);
    }

    public RealTimeSocket getRealTimeSocketForParticipant(String roomId, String participantId) {
        return this.qm.getRealTimeSocketForParticipant(roomId, participantId);
    }

    public void declineRoomInvitation(String invitationId) {
        this.qm.i(invitationId, 0);
    }

    public void dismissRoomInvitation(String invitationId) {
        this.qm.h(invitationId, 0);
    }

    public void loadInvitations(final OnInvitationsLoadedListener listener) {
        this.qm.e(new a.c<c.a>(){

            @Override
            public void a(c.a a2) {
                int n2 = a2.getStatus().getStatusCode();
                listener.onInvitationsLoaded(n2, a2.getInvitations());
            }
        });
    }

    public void loadTurnBasedMatches(final OnTurnBasedMatchesLoadedListener listener, int ... matchTurnStatuses) {
        this.qm.a(new a.c<b.e>(){

            @Override
            public void a(b.e e2) {
                int n2 = e2.getStatus().getStatusCode();
                listener.onTurnBasedMatchesLoaded(n2, e2.cU());
            }
        }, matchTurnStatuses);
    }

    public void getTurnBasedMatch(final OnTurnBasedMatchLoadedListener listener, String matchId) {
        this.qm.h(new a.c<b.d>(){

            @Override
            public void a(b.d d2) {
                int n2 = d2.getStatus().getStatusCode();
                listener.onTurnBasedMatchLoaded(n2, d2.cT());
            }
        }, matchId);
    }

    public void clearAllNotifications() {
        this.qm.clearNotifications(-1);
    }

    public void clearNotifications(int notificationTypes) {
        this.qm.clearNotifications(notificationTypes);
    }

    public static final class Builder {
        private final Context mContext;
        private String qF;
        private String jD = "<<default account>>";
        private final GooglePlayServicesClient.ConnectionCallbacks jA;
        private final GooglePlayServicesClient.OnConnectionFailedListener jB;
        private String[] jC = new String[]{"https://www.googleapis.com/auth/games"};
        private int qG = 49;
        private View qH;
        private boolean qI = true;
        private int qJ = 17;

        public Builder(Context context, GooglePlayServicesClient.ConnectionCallbacks connectedListener, GooglePlayServicesClient.OnConnectionFailedListener connectionFailedListener) {
            this.mContext = context;
            this.qF = context.getPackageName();
            this.jA = connectedListener;
            this.jB = connectionFailedListener;
        }

        public Builder setScopes(String ... scopes) {
            this.jC = scopes;
            return this;
        }

        public Builder setAccountName(String accountName) {
            this.jD = du.f(accountName);
            return this;
        }

        public Builder setGravityForPopups(int gravity) {
            this.qG = gravity;
            return this;
        }

        public Builder setViewForPopups(View gamesContentView) {
            this.qH = du.f(gamesContentView);
            return this;
        }

        public Builder setShowConnectingPopup(boolean showConnectingPopup) {
            this.qI = showConnectingPopup;
            this.qJ = 17;
            return this;
        }

        public Builder setShowConnectingPopup(boolean showConnectingPopup, int gravity) {
            this.qI = showConnectingPopup;
            this.qJ = gravity;
            return this;
        }

        public GamesClient create() {
            return new GamesClient(this.mContext, this.qF, this.jD, this.jA, this.jB, this.jC, this.qG, this.qH, this.qI, this.qJ);
        }
    }
}

