/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.games.Game;
import com.google.android.gms.internal.ds;
import com.google.android.gms.internal.eo;
import com.google.android.gms.internal.ey;

public final class GameEntity
extends ey
implements Game {
    public static final Parcelable.Creator<GameEntity> CREATOR = new a();
    private final int kZ;
    private final String pV;
    private final String pW;
    private final String pX;
    private final String pY;
    private final String pZ;
    private final String qa;
    private final Uri qb;
    private final Uri qc;
    private final Uri qd;
    private final boolean qe;
    private final boolean qf;
    private final String qg;
    private final int qh;
    private final int qi;
    private final int qj;
    private final boolean qk;
    private final boolean ql;

    public GameEntity(Game game) {
        this.kZ = 2;
        this.pV = game.getApplicationId();
        this.pX = game.getPrimaryCategory();
        this.pY = game.getSecondaryCategory();
        this.pZ = game.getDescription();
        this.qa = game.getDeveloperName();
        this.pW = game.getDisplayName();
        this.qb = game.getIconImageUri();
        this.qc = game.getHiResImageUri();
        this.qd = game.getFeaturedImageUri();
        this.qe = game.isPlayEnabledGame();
        this.qf = game.isInstanceInstalled();
        this.qg = game.getInstancePackageName();
        this.qh = game.getGameplayAclStatus();
        this.qi = game.getAchievementTotalCount();
        this.qj = game.getLeaderboardCount();
        this.qk = game.isRealTimeMultiplayerEnabled();
        this.ql = game.isTurnBasedMultiplayerEnabled();
    }

    GameEntity(int versionCode, String applicationId, String displayName, String primaryCategory, String secondaryCategory, String description, String developerName, Uri iconImageUri, Uri hiResImageUri, Uri featuredImageUri, boolean playEnabledGame, boolean instanceInstalled, String instancePackageName, int gameplayAclStatus, int achievementTotalCount, int leaderboardCount, boolean realTimeEnabled, boolean turnBasedEnabled) {
        this.kZ = versionCode;
        this.pV = applicationId;
        this.pW = displayName;
        this.pX = primaryCategory;
        this.pY = secondaryCategory;
        this.pZ = description;
        this.qa = developerName;
        this.qb = iconImageUri;
        this.qc = hiResImageUri;
        this.qd = featuredImageUri;
        this.qe = playEnabledGame;
        this.qf = instanceInstalled;
        this.qg = instancePackageName;
        this.qh = gameplayAclStatus;
        this.qi = achievementTotalCount;
        this.qj = leaderboardCount;
        this.qk = realTimeEnabled;
        this.ql = turnBasedEnabled;
    }

    public int getVersionCode() {
        return this.kZ;
    }

    public String getApplicationId() {
        return this.pV;
    }

    public String getDisplayName() {
        return this.pW;
    }

    public void getDisplayName(CharArrayBuffer dataOut) {
        eo.b(this.pW, dataOut);
    }

    public String getPrimaryCategory() {
        return this.pX;
    }

    public String getSecondaryCategory() {
        return this.pY;
    }

    public String getDescription() {
        return this.pZ;
    }

    public void getDescription(CharArrayBuffer dataOut) {
        eo.b(this.pZ, dataOut);
    }

    public String getDeveloperName() {
        return this.qa;
    }

    public void getDeveloperName(CharArrayBuffer dataOut) {
        eo.b(this.qa, dataOut);
    }

    public Uri getIconImageUri() {
        return this.qb;
    }

    public Uri getHiResImageUri() {
        return this.qc;
    }

    public Uri getFeaturedImageUri() {
        return this.qd;
    }

    public boolean isPlayEnabledGame() {
        return this.qe;
    }

    public boolean isInstanceInstalled() {
        return this.qf;
    }

    public String getInstancePackageName() {
        return this.qg;
    }

    public int getGameplayAclStatus() {
        return this.qh;
    }

    public int getAchievementTotalCount() {
        return this.qi;
    }

    public int getLeaderboardCount() {
        return this.qj;
    }

    public boolean isRealTimeMultiplayerEnabled() {
        return this.qk;
    }

    public boolean isTurnBasedMultiplayerEnabled() {
        return this.ql;
    }

    public Game freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return GameEntity.a(this);
    }

    static int a(Game game) {
        return ds.hashCode(game.getApplicationId(), game.getDisplayName(), game.getPrimaryCategory(), game.getSecondaryCategory(), game.getDescription(), game.getDeveloperName(), game.getIconImageUri(), game.getHiResImageUri(), game.getFeaturedImageUri(), game.isPlayEnabledGame(), game.isInstanceInstalled(), game.getInstancePackageName(), game.getGameplayAclStatus(), game.getAchievementTotalCount(), game.getLeaderboardCount(), game.isRealTimeMultiplayerEnabled(), game.isTurnBasedMultiplayerEnabled());
    }

    public boolean equals(Object obj) {
        return GameEntity.a(this, obj);
    }

    static boolean a(Game game, Object object) {
        if (!(object instanceof Game)) {
            return false;
        }
        if (game == object) {
            return true;
        }
        Game game2 = (Game)object;
        return ds.equal(game2.getApplicationId(), game.getApplicationId()) && ds.equal(game2.getDisplayName(), game.getDisplayName()) && ds.equal(game2.getPrimaryCategory(), game.getPrimaryCategory()) && ds.equal(game2.getSecondaryCategory(), game.getSecondaryCategory()) && ds.equal(game2.getDescription(), game.getDescription()) && ds.equal(game2.getDeveloperName(), game.getDeveloperName()) && ds.equal(game2.getIconImageUri(), game.getIconImageUri()) && ds.equal(game2.getHiResImageUri(), game.getHiResImageUri()) && ds.equal(game2.getFeaturedImageUri(), game.getFeaturedImageUri()) && ds.equal(game2.isPlayEnabledGame(), game.isPlayEnabledGame()) && ds.equal(game2.isInstanceInstalled(), game.isInstanceInstalled()) && ds.equal(game2.getInstancePackageName(), game.getInstancePackageName()) && ds.equal(game2.getGameplayAclStatus(), game.getGameplayAclStatus()) && ds.equal(game2.getAchievementTotalCount(), game.getAchievementTotalCount()) && ds.equal(game2.getLeaderboardCount(), game.getLeaderboardCount()) && ds.equal(game2.isRealTimeMultiplayerEnabled(), game.isRealTimeMultiplayerEnabled()) && ds.equal(game2.isTurnBasedMultiplayerEnabled(), game.isTurnBasedMultiplayerEnabled());
    }

    public String toString() {
        return GameEntity.b(this);
    }

    static String b(Game game) {
        return ds.e(game).a("ApplicationId", game.getApplicationId()).a("DisplayName", game.getDisplayName()).a("PrimaryCategory", game.getPrimaryCategory()).a("SecondaryCategory", game.getSecondaryCategory()).a("Description", game.getDescription()).a("DeveloperName", game.getDeveloperName()).a("IconImageUri", game.getIconImageUri()).a("HiResImageUri", game.getHiResImageUri()).a("FeaturedImageUri", game.getFeaturedImageUri()).a("PlayEnabledGame", game.isPlayEnabledGame()).a("InstanceInstalled", game.isInstanceInstalled()).a("InstancePackageName", game.getInstancePackageName()).a("GameplayAclStatus", game.getGameplayAclStatus()).a("AchievementTotalCount", game.getAchievementTotalCount()).a("LeaderboardCount", game.getLeaderboardCount()).a("RealTimeMultiplayerEnabled", game.isRealTimeMultiplayerEnabled()).a("TurnBasedMultiplayerEnabled", game.isTurnBasedMultiplayerEnabled()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.bz()) {
            com.google.android.gms.games.a.a(this, dest, flags);
        } else {
            dest.writeString(this.pV);
            dest.writeString(this.pW);
            dest.writeString(this.pX);
            dest.writeString(this.pY);
            dest.writeString(this.pZ);
            dest.writeString(this.qa);
            dest.writeString(this.qb == null ? null : this.qb.toString());
            dest.writeString(this.qc == null ? null : this.qc.toString());
            dest.writeString(this.qd == null ? null : this.qd.toString());
            dest.writeInt(this.qe ? 1 : 0);
            dest.writeInt(this.qf ? 1 : 0);
            dest.writeString(this.qg);
            dest.writeInt(this.qh);
            dest.writeInt(this.qi);
            dest.writeInt(this.qj);
        }
    }

    static final class a
    extends com.google.android.gms.games.a {
        a() {
        }

        public GameEntity U(Parcel parcel) {
            boolean bl2 = GameEntity.c(GameEntity.by());
            if (bl2 || GameEntity.D(GameEntity.class.getCanonicalName())) {
                return super.U(parcel);
            }
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            String string5 = parcel.readString();
            String string6 = parcel.readString();
            String string7 = parcel.readString();
            String string8 = parcel.readString();
            Uri uri = string8 == null ? null : Uri.parse((String)string8);
            String string9 = parcel.readString();
            Uri uri2 = string9 == null ? null : Uri.parse((String)string9);
            String string10 = parcel.readString();
            Uri uri3 = string10 == null ? null : Uri.parse((String)string10);
            boolean bl3 = parcel.readInt() > 0;
            boolean bl4 = parcel.readInt() > 0;
            String string11 = parcel.readString();
            int n2 = parcel.readInt();
            int n3 = parcel.readInt();
            int n4 = parcel.readInt();
            boolean bl5 = false;
            boolean bl6 = false;
            return new GameEntity(2, string2, string3, string4, string5, string6, string7, uri, uri2, uri3, bl3, bl4, string11, n2, n3, n4, bl5, bl6);
        }

        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.U(x0);
        }
    }
}

