/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.query;

import com.google.android.gms.drive.metadata.CollectionMetadataField;
import com.google.android.gms.drive.metadata.MetadataField;
import com.google.android.gms.drive.metadata.OrderedMetadataField;
import com.google.android.gms.drive.query.Filter;
import com.google.android.gms.drive.query.SearchableField;
import com.google.android.gms.drive.query.internal.ComparisonFilter;
import com.google.android.gms.drive.query.internal.FieldOnlyFilter;
import com.google.android.gms.drive.query.internal.InFilter;
import com.google.android.gms.drive.query.internal.LogicalFilter;
import com.google.android.gms.drive.query.internal.NotFilter;
import com.google.android.gms.drive.query.internal.Operator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Filters {
    public static <T> Filter eq(MetadataField<T> field, T value) {
        return new ComparisonFilter<T>(Operator.pr, field, value);
    }

    public static <T extends Comparable<T>> Filter lessThan(OrderedMetadataField<T> field, T value) {
        return new ComparisonFilter<T>(Operator.ps, field, value);
    }

    public static <T extends Comparable<T>> Filter greaterThan(OrderedMetadataField<T> field, T value) {
        return new ComparisonFilter<T>(Operator.pu, field, value);
    }

    public static <T extends Comparable<T>> Filter lessThanEquals(OrderedMetadataField<T> field, T value) {
        return new ComparisonFilter<T>(Operator.pt, field, value);
    }

    public static <T extends Comparable<T>> Filter greaterThanEquals(OrderedMetadataField<T> field, T value) {
        return new ComparisonFilter<T>(Operator.pv, field, value);
    }

    public static <T> Filter in(CollectionMetadataField<T> field, T value) {
        return new InFilter<T>(field, value);
    }

    public static Filter contains(MetadataField<String> field, String value) {
        return new ComparisonFilter<String>(Operator.pz, field, value);
    }

    public static Filter and(Filter filter, Filter ... additionalFilters) {
        return new LogicalFilter(Operator.pw, filter, additionalFilters);
    }

    public static Filter and(List<Filter> filters) {
        return new LogicalFilter(Operator.pw, filters);
    }

    public static Filter or(Filter filter, Filter ... additionalFilters) {
        return new LogicalFilter(Operator.px, filter, additionalFilters);
    }

    public static Filter or(List<Filter> filters) {
        return new LogicalFilter(Operator.px, filters);
    }

    public static Filter not(Filter toNegate) {
        return new NotFilter(toNegate);
    }

    public static Filter sharedWithMe() {
        return new FieldOnlyFilter(SearchableField.pa);
    }
}

