/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.internal;

import android.os.RemoteException;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.a;
import com.google.android.gms.drive.Contents;
import com.google.android.gms.drive.CreateFileActivityBuilder;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveFile;
import com.google.android.gms.drive.DriveFolder;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.MetadataBuffer;
import com.google.android.gms.drive.OpenFileActivityBuilder;
import com.google.android.gms.drive.internal.CloseContentsRequest;
import com.google.android.gms.drive.internal.CreateContentsRequest;
import com.google.android.gms.drive.internal.OnContentsResponse;
import com.google.android.gms.drive.internal.OnListEntriesResponse;
import com.google.android.gms.drive.internal.QueryRequest;
import com.google.android.gms.drive.internal.i;
import com.google.android.gms.drive.internal.j;
import com.google.android.gms.drive.internal.k;
import com.google.android.gms.drive.internal.l;
import com.google.android.gms.drive.internal.p;
import com.google.android.gms.drive.internal.z;
import com.google.android.gms.drive.query.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class h
implements DriveApi {
    @Override
    public PendingResult<DriveApi.MetadataBufferResult, DriveFolder.OnChildrenRetrievedCallback> query(GoogleApiClient apiClient, final Query query) {
        if (query == null) {
            throw new IllegalArgumentException("Query must be provided.");
        }
        return apiClient.a(new g(){

            protected void a(j j2) {
                try {
                    j2.cu().a(new QueryRequest(query), (p)new f(this));
                }
                catch (RemoteException remoteException) {
                    this.a(new c(new Status(8, remoteException.getLocalizedMessage(), null), null));
                }
            }

            protected /* synthetic */ void b(Api.a a2) {
                this.a((j)a2);
            }
        });
    }

    @Override
    public PendingResult<DriveApi.ContentsResult, DriveApi.OnNewContentsCallback> newContents(GoogleApiClient apiClient) {
        return apiClient.a(new e(){

            protected void a(j j2) {
                try {
                    j2.cu().a(new CreateContentsRequest(), (p)new d(this));
                }
                catch (RemoteException remoteException) {
                    this.a(new a(new Status(8, remoteException.getLocalizedMessage(), null), null));
                }
            }

            protected /* synthetic */ void b(Api.a a2) {
                this.a((j)a2);
            }
        });
    }

    @Override
    public PendingResult<Status, DriveApi.OnContentsDiscardedCallback> discardContents(GoogleApiClient apiClient, final Contents contents) {
        return apiClient.b(new b(){

            protected void a(j j2) {
                try {
                    j2.cu().a(new CloseContentsRequest(contents, false), (p)new z(this));
                }
                catch (RemoteException remoteException) {
                    this.a(new Status(8, remoteException.getLocalizedMessage(), null));
                }
            }

            protected /* synthetic */ void b(Api.a a2) {
                this.a((j)a2);
            }
        });
    }

    @Override
    public DriveFile getFile(GoogleApiClient apiClient, DriveId id) {
        if (id == null) {
            throw new IllegalArgumentException("Id must be provided.");
        }
        if (!apiClient.isConnected()) {
            throw new IllegalStateException("Client must be connected");
        }
        return new k(id);
    }

    @Override
    public DriveFolder getFolder(GoogleApiClient apiClient, DriveId id) {
        if (id == null) {
            throw new IllegalArgumentException("Id must be provided.");
        }
        if (!apiClient.isConnected()) {
            throw new IllegalStateException("Client must be connected");
        }
        return new l(id);
    }

    @Override
    public DriveFolder getRootFolder(GoogleApiClient apiClient) {
        if (!apiClient.isConnected()) {
            throw new IllegalStateException("Client must be connected");
        }
        j j2 = apiClient.a(Drive.jL);
        return new l(j2.cv());
    }

    @Override
    public OpenFileActivityBuilder newOpenFileActivityBuilder() {
        return new OpenFileActivityBuilder();
    }

    @Override
    public CreateFileActivityBuilder newCreateFileActivityBuilder() {
        return new CreateFileActivityBuilder();
    }

    @Override
    public PendingResult<Status, DriveApi.OnSyncFinishCallback> requestSync(GoogleApiClient client) {
        return client.b(new h(){

            protected void a(j j2) {
                try {
                    j2.cu().a(new z(this));
                }
                catch (RemoteException remoteException) {
                    this.a(new Status(8, remoteException.getLocalizedMessage(), null));
                }
            }

            protected /* synthetic */ void b(Api.a a2) {
                this.a((j)a2);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class d
    extends com.google.android.gms.drive.internal.a {
        private final a.c<DriveApi.ContentsResult> jN;

        public d(a.c<DriveApi.ContentsResult> c2) {
            this.jN = c2;
        }

        @Override
        public void a(OnContentsResponse onContentsResponse) throws RemoteException {
            this.jN.a(new a(Status.kW, onContentsResponse.cx()));
        }

        @Override
        public void d(Status status) throws RemoteException {
            this.jN.a(new a(status, null));
        }
    }

    static class a
    implements DriveApi.ContentsResult {
        private final Status jP;
        private final Contents nZ;

        public a(Status status, Contents contents) {
            this.jP = status;
            this.nZ = contents;
        }

        public Status getStatus() {
            return this.jP;
        }

        public Contents getContents() {
            return this.nZ;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class h
    extends i<Status, DriveApi.OnSyncFinishCallback> {
        h() {
        }

        @Override
        protected void a(DriveApi.OnSyncFinishCallback onSyncFinishCallback, Status status) {
            onSyncFinishCallback.onSyncFinish(status);
        }

        public Status e(Status status) {
            return status;
        }

        @Override
        public /* synthetic */ Result b(Status status) {
            return this.e(status);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class b
    extends i<Status, DriveApi.OnContentsDiscardedCallback> {
        b() {
        }

        @Override
        protected void a(DriveApi.OnContentsDiscardedCallback onContentsDiscardedCallback, Status status) {
            onContentsDiscardedCallback.onContentsDiscarded(status);
        }

        public Status e(Status status) {
            return status;
        }

        @Override
        public /* synthetic */ Result b(Status status) {
            return this.e(status);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class e
    extends i<DriveApi.ContentsResult, DriveApi.OnNewContentsCallback> {
        e() {
        }

        @Override
        protected void a(DriveApi.OnNewContentsCallback onNewContentsCallback, DriveApi.ContentsResult contentsResult) {
            onNewContentsCallback.onNewContents(contentsResult);
        }

        public DriveApi.ContentsResult f(Status status) {
            return new a(status, null);
        }

        @Override
        public /* synthetic */ Result b(Status status) {
            return this.f(status);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class g
    extends i<DriveApi.MetadataBufferResult, DriveFolder.OnChildrenRetrievedCallback> {
        g() {
        }

        @Override
        protected void a(DriveFolder.OnChildrenRetrievedCallback onChildrenRetrievedCallback, DriveApi.MetadataBufferResult metadataBufferResult) {
            onChildrenRetrievedCallback.onChildrenRetrieved(metadataBufferResult);
        }

        public DriveApi.MetadataBufferResult g(Status status) {
            return new c(status, null);
        }

        @Override
        public /* synthetic */ Result b(Status status) {
            return this.g(status);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class f
    extends com.google.android.gms.drive.internal.a {
        private final a.c<DriveApi.MetadataBufferResult> jN;

        public f(a.c<DriveApi.MetadataBufferResult> c2) {
            this.jN = c2;
        }

        @Override
        public void a(OnListEntriesResponse onListEntriesResponse) throws RemoteException {
            MetadataBuffer metadataBuffer = new MetadataBuffer(onListEntriesResponse.cA(), null);
            this.jN.a(new c(Status.kW, metadataBuffer));
        }

        @Override
        public void d(Status status) throws RemoteException {
            this.jN.a(new c(status, null));
        }
    }

    static class c
    implements DriveApi.MetadataBufferResult {
        private final Status jP;
        private final MetadataBuffer ot;

        public c(Status status, MetadataBuffer metadataBuffer) {
            this.jP = status;
            this.ot = metadataBuffer;
        }

        public Status getStatus() {
            return this.jP;
        }

        public MetadataBuffer getMetadataBuffer() {
            return this.ot;
        }
    }
}

