/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

import android.app.ActivityManager;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.ResultReceiver;
import android.util.Log;
import android.widget.ImageView;
import com.google.android.gms.common.images.a;
import com.google.android.gms.internal.dg;
import com.google.android.gms.internal.dy;
import com.google.android.gms.internal.es;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class ImageManager {
    private static final Object ly = new Object();
    private static HashSet<Uri> lz = new HashSet();
    private static ImageManager lA;
    private static ImageManager lB;
    private final Context mContext;
    private final Handler mHandler;
    private final ExecutorService lC;
    private final b lD;
    private final Map<com.google.android.gms.common.images.a, ImageReceiver> lE;
    private final Map<Uri, ImageReceiver> lF;

    public static ImageManager create(Context context) {
        return ImageManager.a(context, false);
    }

    public static ImageManager a(Context context, boolean bl2) {
        if (bl2) {
            if (lB == null) {
                lB = new ImageManager(context, true);
            }
            return lB;
        }
        if (lA == null) {
            lA = new ImageManager(context, false);
        }
        return lA;
    }

    private ImageManager(Context context, boolean withMemoryCache) {
        this.mContext = context.getApplicationContext();
        this.mHandler = new Handler(Looper.getMainLooper());
        this.lC = Executors.newFixedThreadPool(4);
        if (withMemoryCache) {
            this.lD = new b(this.mContext);
            if (es.cn()) {
                this.bm();
            }
        } else {
            this.lD = null;
        }
        this.lE = new HashMap<com.google.android.gms.common.images.a, ImageReceiver>();
        this.lF = new HashMap<Uri, ImageReceiver>();
    }

    private void bm() {
        this.mContext.registerComponentCallbacks((ComponentCallbacks)new e(this.lD));
    }

    public void loadImage(ImageView imageView, Uri uri) {
        com.google.android.gms.common.images.a a2 = new com.google.android.gms.common.images.a(uri);
        a2.a(imageView);
        this.a(a2);
    }

    public void loadImage(ImageView imageView, int resId) {
        com.google.android.gms.common.images.a a2 = new com.google.android.gms.common.images.a(resId);
        a2.a(imageView);
        this.a(a2);
    }

    public void loadImage(ImageView imageView, Uri uri, int defaultResId) {
        com.google.android.gms.common.images.a a2 = new com.google.android.gms.common.images.a(uri);
        a2.w(defaultResId);
        a2.a(imageView);
        this.a(a2);
    }

    public void loadImage(OnImageLoadedListener listener, Uri uri) {
        com.google.android.gms.common.images.a a2 = new com.google.android.gms.common.images.a(uri);
        a2.a(listener);
        this.a(a2);
    }

    public void loadImage(OnImageLoadedListener listener, Uri uri, int defaultResId) {
        com.google.android.gms.common.images.a a2 = new com.google.android.gms.common.images.a(uri);
        a2.w(defaultResId);
        a2.a(listener);
        this.a(a2);
    }

    public void a(com.google.android.gms.common.images.a a2) {
        dg.B("ImageManager.loadImage() must be called in the main thread");
        boolean bl2 = this.b(a2);
        d d2 = new d(a2);
        if (bl2) {
            d2.run();
        } else {
            this.mHandler.post((Runnable)d2);
        }
    }

    private boolean b(com.google.android.gms.common.images.a a2) {
        dg.B("ImageManager.cleanupHashMaps() must be called in the main thread");
        if (a2.lP == 1) {
            return true;
        }
        ImageReceiver imageReceiver = this.lE.get(a2);
        if (imageReceiver == null) {
            return true;
        }
        if (imageReceiver.lH) {
            return false;
        }
        this.lE.remove(a2);
        imageReceiver.d(a2);
        return true;
    }

    private Bitmap a(a.a a2) {
        if (this.lD == null) {
            return null;
        }
        Bitmap bitmap = (Bitmap)this.lD.get(a2);
        return bitmap;
    }

    private static final class a {
        static int a(ActivityManager activityManager) {
            return activityManager.getLargeMemoryClass();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class b
    extends dy<a.a, Bitmap> {
        public b(Context context) {
            super(b.q(context));
        }

        protected void a(boolean bl2, a.a a2, Bitmap bitmap, Bitmap bitmap2) {
            super.entryRemoved(bl2, a2, bitmap, bitmap2);
        }

        private static int q(Context context) {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            boolean bl2 = (context.getApplicationInfo().flags & 0x100000) != 0;
            int n2 = bl2 && es.ck() ? a.a(activityManager) : activityManager.getMemoryClass();
            int n3 = 0x100000 * n2;
            return (int)(0.33f * (float)n3);
        }

        protected int a(a.a a2, Bitmap bitmap) {
            return bitmap.getHeight() * bitmap.getRowBytes();
        }

        @Override
        protected /* synthetic */ int sizeOf(Object x0, Object x1) {
            return this.a((a.a)x0, (Bitmap)x1);
        }

        @Override
        protected /* synthetic */ void entryRemoved(boolean x0, Object x1, Object x2, Object x3) {
            this.a(x0, (a.a)x1, (Bitmap)x2, (Bitmap)x3);
        }
    }

    private static final class e
    implements ComponentCallbacks2 {
        private final b lD;

        public e(b b2) {
            this.lD = b2;
        }

        public void onConfigurationChanged(Configuration newConfig) {
        }

        public void onLowMemory() {
            this.lD.evictAll();
        }

        public void onTrimMemory(int level) {
            if (level >= 60) {
                this.lD.evictAll();
            } else if (level >= 20) {
                this.lD.trimToSize(this.lD.size() / 2);
            }
        }
    }

    private final class f
    implements Runnable {
        private final Uri mUri;
        private final Bitmap mBitmap;
        private final CountDownLatch kv;
        private boolean lL;

        public f(Uri uri, Bitmap bitmap, boolean bl2, CountDownLatch countDownLatch) {
            this.mUri = uri;
            this.mBitmap = bitmap;
            this.lL = bl2;
            this.kv = countDownLatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ImageReceiver imageReceiver;
            boolean bl2;
            dg.B("OnBitmapLoadedRunnable must be executed in the main thread");
            boolean bl3 = bl2 = this.mBitmap != null;
            if (ImageManager.this.lD != null) {
                if (this.lL) {
                    ImageManager.this.lD.evictAll();
                    System.gc();
                    this.lL = false;
                    ImageManager.this.mHandler.post((Runnable)this);
                    return;
                }
                if (bl2) {
                    ImageManager.this.lD.put(new a.a(this.mUri), this.mBitmap);
                }
            }
            if ((imageReceiver = (ImageReceiver)((Object)ImageManager.this.lF.remove(this.mUri))) != null) {
                this.a(imageReceiver, bl2);
            }
            this.kv.countDown();
            Object object = ly;
            synchronized (object) {
                lz.remove(this.mUri);
            }
        }

        private void a(ImageReceiver imageReceiver, boolean bl2) {
            imageReceiver.lH = true;
            ArrayList arrayList = imageReceiver.lG;
            int n2 = arrayList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                com.google.android.gms.common.images.a a2 = (com.google.android.gms.common.images.a)arrayList.get(i2);
                if (bl2) {
                    a2.a(ImageManager.this.mContext, this.mBitmap, false);
                } else {
                    a2.b(ImageManager.this.mContext, false);
                }
                if (a2.lP == 1) continue;
                ImageManager.this.lE.remove(a2);
            }
            imageReceiver.lH = false;
        }
    }

    private final class c
    implements Runnable {
        private final Uri mUri;
        private final ParcelFileDescriptor lJ;

        public c(Uri uri, ParcelFileDescriptor parcelFileDescriptor) {
            this.mUri = uri;
            this.lJ = parcelFileDescriptor;
        }

        public void run() {
            dg.C("LoadBitmapFromDiskRunnable can't be executed in the main thread");
            boolean bl2 = false;
            Bitmap bitmap = null;
            if (this.lJ != null) {
                try {
                    bitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)this.lJ.getFileDescriptor());
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    Log.e((String)"ImageManager", (String)("OOM while loading bitmap for uri: " + this.mUri), (Throwable)outOfMemoryError);
                    bl2 = true;
                }
                try {
                    this.lJ.close();
                }
                catch (IOException iOException) {
                    Log.e((String)"ImageManager", (String)"closed failed", (Throwable)iOException);
                }
            }
            CountDownLatch countDownLatch = new CountDownLatch(1);
            ImageManager.this.mHandler.post((Runnable)new f(this.mUri, bitmap, bl2, countDownLatch));
            try {
                countDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                Log.w((String)"ImageManager", (String)("Latch interrupted while posting " + this.mUri));
            }
        }
    }

    private final class ImageReceiver
    extends ResultReceiver {
        private final Uri mUri;
        private final ArrayList<com.google.android.gms.common.images.a> lG;
        boolean lH;

        ImageReceiver(Uri uri) {
            super(new Handler(Looper.getMainLooper()));
            this.lH = false;
            this.mUri = uri;
            this.lG = new ArrayList();
        }

        public void c(com.google.android.gms.common.images.a a2) {
            dg.a(!this.lH, "Cannot add an ImageRequest when mHandlingRequests is true");
            dg.B("ImageReceiver.addImageRequest() must be called in the main thread");
            this.lG.add(a2);
        }

        public void d(com.google.android.gms.common.images.a a2) {
            dg.a(!this.lH, "Cannot remove an ImageRequest when mHandlingRequests is true");
            dg.B("ImageReceiver.removeImageRequest() must be called in the main thread");
            this.lG.remove(a2);
        }

        public void bp() {
            Intent intent = new Intent("com.google.android.gms.common.images.LOAD_IMAGE");
            intent.putExtra("com.google.android.gms.extras.uri", (Parcelable)this.mUri);
            intent.putExtra("com.google.android.gms.extras.resultReceiver", (Parcelable)this);
            intent.putExtra("com.google.android.gms.extras.priority", 3);
            ImageManager.this.mContext.sendBroadcast(intent);
        }

        public void onReceiveResult(int resultCode, Bundle resultData) {
            ParcelFileDescriptor parcelFileDescriptor = (ParcelFileDescriptor)resultData.getParcelable("com.google.android.gms.extra.fileDescriptor");
            ImageManager.this.lC.execute(new c(this.mUri, parcelFileDescriptor));
        }
    }

    private final class d
    implements Runnable {
        private final com.google.android.gms.common.images.a lK;

        public d(com.google.android.gms.common.images.a a2) {
            this.lK = a2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            dg.B("LoadImageRunnable must be executed on the main thread");
            ImageManager.this.b(this.lK);
            a.a a2 = this.lK.lM;
            if (a2.uri == null) {
                this.lK.b(ImageManager.this.mContext, true);
                return;
            }
            Bitmap bitmap = ImageManager.this.a(a2);
            if (bitmap != null) {
                this.lK.a(ImageManager.this.mContext, bitmap, true);
                return;
            }
            this.lK.r(ImageManager.this.mContext);
            ImageReceiver imageReceiver = (ImageReceiver)((Object)ImageManager.this.lF.get(a2.uri));
            if (imageReceiver == null) {
                imageReceiver = new ImageReceiver(a2.uri);
                ImageManager.this.lF.put(a2.uri, imageReceiver);
            }
            imageReceiver.c(this.lK);
            if (this.lK.lP != 1) {
                ImageManager.this.lE.put(this.lK, imageReceiver);
            }
            boolean bl2 = false;
            Object object = ly;
            synchronized (object) {
                bl2 = lz.contains(a2.uri);
                if (!bl2) {
                    lz.add(a2.uri);
                    imageReceiver.bp();
                }
            }
        }
    }

    public static interface OnImageLoadedListener {
        public void onImageLoaded(Uri var1, Drawable var2, boolean var3);
    }
}

