/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import android.content.ContentValues;
import android.database.AbstractWindowedCursor;
import android.database.CharArrayBuffer;
import android.database.CursorIndexOutOfBoundsException;
import android.database.CursorWindow;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.util.Log;
import com.google.android.gms.common.data.DataHolderCreator;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.dg;
import com.google.android.gms.internal.ds;
import com.google.android.gms.internal.du;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class DataHolder
implements SafeParcelable {
    public static final DataHolderCreator CREATOR = new DataHolderCreator();
    private final int kZ;
    private final String[] lh;
    Bundle li;
    private final CursorWindow[] lj;
    private final int ka;
    private final Bundle lk;
    int[] ll;
    int lm;
    boolean mClosed = false;
    private Object ln;
    private boolean lo = true;
    private static final Builder lp = new Builder(new String[0], null){

        @Override
        public Builder withRow(HashMap<String, Object> row) {
            throw new UnsupportedOperationException("Cannot add data to empty builder");
        }

        @Override
        public Builder withRow(ContentValues values) {
            throw new UnsupportedOperationException("Cannot add data to empty builder");
        }
    };

    DataHolder(int versionCode, String[] columns, CursorWindow[] windows, int statusCode, Bundle metadata) {
        this.kZ = versionCode;
        this.lh = columns;
        this.lj = windows;
        this.ka = statusCode;
        this.lk = metadata;
    }

    public DataHolder(String[] columns, CursorWindow[] windows, int statusCode, Bundle metadata) {
        this.kZ = 1;
        this.lh = du.f(columns);
        this.lj = du.f(windows);
        this.ka = statusCode;
        this.lk = metadata;
        this.validateContents();
    }

    public void c(Object object) {
        this.ln = object;
    }

    public DataHolder(AbstractWindowedCursor cursor, int statusCode, Bundle metadata) {
        this(cursor.getColumnNames(), DataHolder.a(cursor), statusCode, metadata);
    }

    private DataHolder(Builder builder, int statusCode, Bundle metadata) {
        this(builder.lh, DataHolder.a(builder), statusCode, metadata);
    }

    public void validateContents() {
        int n2;
        this.li = new Bundle();
        for (n2 = 0; n2 < this.lh.length; ++n2) {
            this.li.putInt(this.lh[n2], n2);
        }
        this.ll = new int[this.lj.length];
        n2 = 0;
        for (int i2 = 0; i2 < this.lj.length; ++i2) {
            this.ll[i2] = n2;
            n2 += this.lj[i2].getNumRows();
        }
        this.lm = n2;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        DataHolderCreator.a(this, dest, flags);
    }

    int getVersionCode() {
        return this.kZ;
    }

    String[] bi() {
        return this.lh;
    }

    CursorWindow[] bj() {
        return this.lj;
    }

    public int getStatusCode() {
        return this.ka;
    }

    public Bundle getMetadata() {
        return this.lk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CursorWindow[] a(AbstractWindowedCursor abstractWindowedCursor) {
        ArrayList<CursorWindow> arrayList = new ArrayList<CursorWindow>();
        try {
            int n2 = abstractWindowedCursor.getCount();
            CursorWindow cursorWindow = abstractWindowedCursor.getWindow();
            int n3 = 0;
            if (cursorWindow != null && cursorWindow.getStartPosition() == 0) {
                cursorWindow.acquireReference();
                abstractWindowedCursor.setWindow(null);
                arrayList.add(cursorWindow);
                n3 = cursorWindow.getNumRows();
            }
            while (n3 < n2 && abstractWindowedCursor.moveToPosition(n3)) {
                CursorWindow cursorWindow2 = abstractWindowedCursor.getWindow();
                if (cursorWindow2 != null) {
                    cursorWindow2.acquireReference();
                    abstractWindowedCursor.setWindow(null);
                } else {
                    cursorWindow2 = new CursorWindow(false);
                    abstractWindowedCursor.fillWindow(n3, cursorWindow2);
                }
                if (cursorWindow2.getNumRows() == 0) {
                    break;
                }
                arrayList.add(cursorWindow2);
                n3 = cursorWindow2.getStartPosition() + cursorWindow2.getNumRows();
            }
        }
        finally {
            abstractWindowedCursor.close();
        }
        return arrayList.toArray(new CursorWindow[arrayList.size()]);
    }

    private static CursorWindow[] a(Builder builder) {
        if (builder.lh.length == 0) {
            return new CursorWindow[0];
        }
        ArrayList arrayList = builder.lq;
        int n2 = arrayList.size();
        CursorWindow cursorWindow = new CursorWindow(false);
        ArrayList<CursorWindow> arrayList2 = new ArrayList<CursorWindow>();
        arrayList2.add(cursorWindow);
        cursorWindow.setNumColumns(builder.lh.length);
        try {
            int n3 = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!cursorWindow.allocRow()) {
                    Log.d((String)"DataHolder", (String)("Allocating additional cursor window for large data set (row " + i2 + ")"));
                    cursorWindow = new CursorWindow(false);
                    cursorWindow.setNumColumns(builder.lh.length);
                    arrayList2.add(cursorWindow);
                    if (!cursorWindow.allocRow()) {
                        Log.e((String)"DataHolder", (String)"Unable to allocate row to hold data.");
                        arrayList2.remove(cursorWindow);
                        return arrayList2.toArray(new CursorWindow[arrayList2.size()]);
                    }
                    n3 = 0;
                }
                Map map = (Map)arrayList.get(i2);
                boolean bl2 = true;
                for (int i3 = 0; i3 < builder.lh.length && bl2; ++i3) {
                    String string2 = builder.lh[i3];
                    Object v2 = map.get(string2);
                    if (v2 == null) {
                        bl2 = cursorWindow.putNull(n3, i3);
                        continue;
                    }
                    if (v2 instanceof String) {
                        bl2 = cursorWindow.putString((String)v2, n3, i3);
                        continue;
                    }
                    if (v2 instanceof Long) {
                        bl2 = cursorWindow.putLong(((Long)v2).longValue(), n3, i3);
                        continue;
                    }
                    if (v2 instanceof Integer) {
                        bl2 = cursorWindow.putLong((long)((Integer)v2).intValue(), n3, i3);
                        continue;
                    }
                    if (v2 instanceof Boolean) {
                        boolean bl3 = (Boolean)v2;
                        bl2 = cursorWindow.putLong(bl3 ? 1L : 0L, n3, i3);
                        continue;
                    }
                    if (v2 instanceof byte[]) {
                        bl2 = cursorWindow.putBlob((byte[])v2, n3, i3);
                        continue;
                    }
                    throw new IllegalArgumentException("Unsupported object for column " + string2 + ": " + v2);
                }
                if (!bl2) {
                    Log.d((String)"DataHolder", (String)("Couldn't populate window data for row " + i2 + " - allocating new window."));
                    cursorWindow.freeLastRow();
                    cursorWindow = new CursorWindow(false);
                    cursorWindow.setNumColumns(builder.lh.length);
                    arrayList2.add(cursorWindow);
                    n3 = 0;
                    --i2;
                    continue;
                }
                ++n3;
            }
        }
        catch (RuntimeException runtimeException) {
            int n4 = arrayList2.size();
            for (int i4 = 0; i4 < n4; ++i4) {
                ((CursorWindow)arrayList2.get(i4)).close();
            }
            throw runtimeException;
        }
        return arrayList2.toArray(new CursorWindow[arrayList2.size()]);
    }

    private void a(String string2, int n2) {
        if (this.li == null || !this.li.containsKey(string2)) {
            throw new IllegalArgumentException("No such column: " + string2);
        }
        if (this.isClosed()) {
            throw new IllegalArgumentException("Buffer is closed.");
        }
        if (n2 < 0 || n2 >= this.lm) {
            throw new CursorIndexOutOfBoundsException(n2, this.lm);
        }
    }

    public long getLong(String column, int row, int windowIndex) {
        this.a(column, row);
        return this.lj[windowIndex].getLong(row - this.ll[windowIndex], this.li.getInt(column));
    }

    public int getInteger(String column, int row, int windowIndex) {
        this.a(column, row);
        return this.lj[windowIndex].getInt(row - this.ll[windowIndex], this.li.getInt(column));
    }

    public String getString(String column, int row, int windowIndex) {
        this.a(column, row);
        return this.lj[windowIndex].getString(row - this.ll[windowIndex], this.li.getInt(column));
    }

    public boolean getBoolean(String column, int row, int windowIndex) {
        this.a(column, row);
        Long l2 = this.lj[windowIndex].getLong(row - this.ll[windowIndex], this.li.getInt(column));
        return l2 == 1L;
    }

    public byte[] getByteArray(String column, int row, int windowIndex) {
        this.a(column, row);
        return this.lj[windowIndex].getBlob(row - this.ll[windowIndex], this.li.getInt(column));
    }

    public Uri parseUri(String column, int row, int windowIndex) {
        String string2 = this.getString(column, row, windowIndex);
        return string2 == null ? null : Uri.parse((String)string2);
    }

    public void copyToBuffer(String column, int row, int windowIndex, CharArrayBuffer dataOut) {
        this.a(column, row);
        this.lj[windowIndex].copyStringToBuffer(row - this.ll[windowIndex], this.li.getInt(column), dataOut);
    }

    public boolean hasNull(String column, int row, int windowIndex) {
        this.a(column, row);
        return this.lj[windowIndex].isNull(row - this.ll[windowIndex], this.li.getInt(column));
    }

    public int getCount() {
        return this.lm;
    }

    public int t(int n2) {
        int n3;
        du.n(n2 >= 0 && n2 < this.lm);
        for (n3 = 0; n3 < this.ll.length; ++n3) {
            if (n2 >= this.ll[n3]) continue;
            --n3;
            break;
        }
        if (n3 == this.ll.length) {
            --n3;
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        DataHolder dataHolder = this;
        synchronized (dataHolder) {
            return this.mClosed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        DataHolder dataHolder = this;
        synchronized (dataHolder) {
            if (!this.mClosed) {
                this.mClosed = true;
                for (int i2 = 0; i2 < this.lj.length; ++i2) {
                    this.lj[i2].close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.lo && this.lj.length > 0 && !this.isClosed()) {
                String string2 = this.ln == null ? "internal object: " + this.toString() : this.ln.toString();
                Log.e((String)"DataBuffer", (String)("Internal data leak within a DataBuffer object detected!  Be sure to explicitly call close() on all DataBuffer extending objects when you are done with them. (" + string2 + ")"));
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    public static Builder builder(String[] columns) {
        return new Builder(columns, null);
    }

    public static Builder builder(String[] columns, String uniqueColumn) {
        du.f(uniqueColumn);
        return new Builder(columns, uniqueColumn);
    }

    public static DataHolder empty(int statusCode) {
        return DataHolder.empty(statusCode, null);
    }

    public static DataHolder empty(int statusCode, Bundle metadata) {
        return new DataHolder(lp, statusCode, metadata);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class a
    implements Comparator<HashMap<String, Object>> {
        private final String lv;

        a(String string2) {
            this.lv = du.f(string2);
        }

        public int a(HashMap<String, Object> hashMap, HashMap<String, Object> hashMap2) {
            Object object;
            Object object2 = du.f(hashMap.get(this.lv));
            if (object2.equals(object = du.f(hashMap2.get(this.lv)))) {
                return 0;
            }
            if (object2 instanceof Boolean) {
                return ((Boolean)object2).compareTo((Boolean)object);
            }
            if (object2 instanceof Long) {
                return ((Long)object2).compareTo((Long)object);
            }
            if (object2 instanceof Integer) {
                return ((Integer)object2).compareTo((Integer)object);
            }
            if (object2 instanceof String) {
                return ((String)object2).compareTo((String)object);
            }
            throw new IllegalArgumentException("Unknown type for lValue " + object2);
        }

        @Override
        public /* synthetic */ int compare(Object x0, Object x1) {
            return this.a((HashMap)x0, (HashMap)x1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private final String[] lh;
        private final ArrayList<HashMap<String, Object>> lq;
        private final String lr;
        private final HashMap<Object, Integer> ls;
        private boolean lt;
        private String lu;

        private Builder(String[] columns, String uniqueColumn) {
            this.lh = du.f(columns);
            this.lq = new ArrayList();
            this.lr = uniqueColumn;
            this.ls = new HashMap();
            this.lt = false;
            this.lu = null;
        }

        public Builder withRow(HashMap<String, Object> row) {
            dg.d(row);
            if (this.lr != null) {
                this.a(row);
            }
            this.lq.add(row);
            this.lt = false;
            return this;
        }

        private void a(HashMap<String, Object> hashMap) {
            Object object = hashMap.get(this.lr);
            if (object == null) {
                return;
            }
            Integer n2 = this.ls.remove(object);
            if (n2 != null) {
                this.lq.remove(n2);
            }
            this.ls.put(object, this.lq.size());
        }

        public Builder withRow(ContentValues values) {
            dg.d(values);
            HashMap<String, Object> hashMap = new HashMap<String, Object>(values.size());
            Set set = values.valueSet();
            for (Map.Entry entry : set) {
                hashMap.put((String)entry.getKey(), entry.getValue());
            }
            return this.withRow(hashMap);
        }

        public Builder removeRowsWithValue(String column, Object value) {
            for (int i2 = this.lq.size() - 1; i2 >= 0; --i2) {
                if (!ds.equal(this.lq.get(i2).get(column), value)) continue;
                this.lq.remove(i2);
            }
            return this;
        }

        public Builder sort(String sortColumn) {
            dg.d(sortColumn);
            if (this.lt && sortColumn.equals(this.lu)) {
                return this;
            }
            Collections.sort(this.lq, new a(sortColumn));
            this.bk();
            this.lt = true;
            this.lu = sortColumn;
            return this;
        }

        private void bk() {
            if (this.lr != null) {
                this.ls.clear();
                int n2 = this.lq.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    Object object = this.lq.get(i2).get(this.lr);
                    if (object == null) continue;
                    this.ls.put(object, i2);
                }
            }
        }

        public int getCount() {
            return this.lq.size();
        }

        public DataHolder build(int statusCode) {
            return new DataHolder(this, statusCode, null);
        }

        public DataHolder build(int statusCode, Bundle metadata) {
            return new DataHolder(this, statusCode, metadata);
        }
    }
}

