/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.content.Context;
import android.os.Bundle;
import android.view.View;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesClient;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.a;
import com.google.android.gms.internal.dh;
import com.google.android.gms.internal.dl;
import com.google.android.gms.internal.du;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GoogleApiClient {
    private final Object kt = new Object();
    private final dl kB;
    private final Queue<a<?>> kC = new LinkedList();
    private ConnectionResult kD;
    private int kE;
    private int kF = 3;
    private int kG;
    private final Bundle kH = new Bundle();
    private final Map<Api.b<?>, Api.a> kI = new HashMap();
    private boolean kJ;
    private final ConnectionCallbacks kK = new ConnectionCallbacks(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onConnected(Bundle connectionHint) {
            Object object = GoogleApiClient.this.kt;
            synchronized (object) {
                if (GoogleApiClient.this.kF == 1) {
                    if (connectionHint != null) {
                        GoogleApiClient.this.kH.putAll(connectionHint);
                    }
                    GoogleApiClient.this.aY();
                }
            }
        }

        public void onDisconnected() {
            GoogleApiClient.this.ba();
        }
    };
    private final dl.b kL = new dl.b(){

        public boolean bb() {
            return GoogleApiClient.this.kJ;
        }

        public boolean isConnected() {
            return GoogleApiClient.this.isConnected();
        }

        public Bundle bc() {
            return null;
        }
    };

    private GoogleApiClient(Context context, dh commonSettings, Map<Api, ApiOptions> apis, Set<ConnectionCallbacks> connectedCallbacks, Set<OnConnectionFailedListener> onConnectionFailedListeners) {
        this.kB = new dl(context, this.kL);
        for (ConnectionCallbacks object : connectedCallbacks) {
            this.kB.registerConnectionCallbacks(object);
        }
        for (OnConnectionFailedListener onConnectionFailedListener : onConnectionFailedListeners) {
            this.kB.registerConnectionFailedListener(onConnectionFailedListener);
        }
        for (Api api : apis.keySet()) {
            final Api.b<?> b2 = api.aV();
            ApiOptions apiOptions = apis.get(api);
            this.kI.put(b2, (Api.a)b2.b(context, commonSettings, apiOptions, this.kK, new OnConnectionFailedListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onConnectionFailed(ConnectionResult result) {
                    Object object = GoogleApiClient.this.kt;
                    synchronized (object) {
                        if (GoogleApiClient.this.kD == null || b2.getPriority() < GoogleApiClient.this.kE) {
                            GoogleApiClient.this.kD = result;
                            GoogleApiClient.this.kE = b2.getPriority();
                        }
                        GoogleApiClient.this.aY();
                    }
                }
            }));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void aY() {
        Object object = this.kt;
        synchronized (object) {
            --this.kG;
            if (this.kG == 0) {
                if (this.kD != null) {
                    this.kF = 3;
                    for (Api.a a2 : this.kI.values()) {
                        a2.disconnect();
                    }
                    this.kB.a(this.kD);
                } else {
                    this.kF = 2;
                    Bundle bundle = this.kH.isEmpty() ? null : this.kH;
                    this.kB.b(bundle);
                    this.aZ();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <A extends Api.a, T extends a.a<?, ?, A>> T a(T t2) {
        Object object = this.kt;
        synchronized (object) {
            if (this.isConnected()) {
                this.b(t2);
            } else {
                this.kC.add(t2);
            }
        }
        return t2;
    }

    public <A extends Api.a, T extends a.a<?, ?, A>> T b(T t2) {
        du.a(this.isConnected(), "GoogleApiClient is not connected yet.");
        this.aZ();
        this.a((a<A>)t2);
        return t2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <A extends Api.a> void a(a<A> a2) {
        Object object = this.kt;
        synchronized (object) {
            du.a(this.isConnected(), "GoogleApiClient is not connected yet.");
            du.a(a2.aV() != null, "This task can not be executed or enqueued (it's probably a Batch or malformed)");
            A a3 = this.a(a2.aV());
            a2.a(a3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void aZ() {
        du.a(this.isConnected(), "GoogleApiClient is not connected yet.");
        Object object = this.kt;
        synchronized (object) {
            while (!this.kC.isEmpty()) {
                this.a(this.kC.remove());
            }
        }
    }

    public <C extends Api.a> C a(Api.b<C> b2) {
        Api.a a2 = this.kI.get(b2);
        du.c(a2, "Appropriate Api was not requested.");
        return (C)a2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() {
        Object object = this.kt;
        synchronized (object) {
            if (this.isConnected() || this.isConnecting()) {
                return;
            }
            this.kJ = true;
            this.kD = null;
            this.kF = 1;
            this.kH.clear();
            this.kG = this.kI.size();
            for (Api.a a2 : this.kI.values()) {
                a2.connect();
            }
        }
    }

    public void disconnect() {
        this.ba();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ba() {
        Object object = this.kt;
        synchronized (object) {
            this.kJ = false;
            this.kC.clear();
            for (Api.a a2 : this.kI.values()) {
                a2.disconnect();
            }
            if (this.kF != 3) {
                this.kF = 3;
                this.kB.bG();
            }
        }
    }

    public void reconnect() {
        this.disconnect();
        this.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        Object object = this.kt;
        synchronized (object) {
            return this.kF == 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnecting() {
        Object object = this.kt;
        synchronized (object) {
            return this.kF == 1;
        }
    }

    public void registerConnectionCallbacks(ConnectionCallbacks listener) {
        this.kB.registerConnectionCallbacks(listener);
    }

    public boolean isConnectionCallbacksRegistered(ConnectionCallbacks listener) {
        return this.kB.isConnectionCallbacksRegistered(listener);
    }

    public void unregisterConnectionCallbacks(ConnectionCallbacks listener) {
        this.kB.unregisterConnectionCallbacks(listener);
    }

    public void registerConnectionFailedListener(OnConnectionFailedListener listener) {
        this.kB.registerConnectionFailedListener(listener);
    }

    public boolean isConnectionFailedListenerRegistered(OnConnectionFailedListener listener) {
        return this.kB.isConnectionFailedListenerRegistered(listener);
    }

    public void unregisterConnectionFailedListener(OnConnectionFailedListener listener) {
        this.kB.unregisterConnectionFailedListener(listener);
    }

    public static final class Builder {
        private String jD;
        private final Set<String> kO = new HashSet<String>();
        private int kP;
        private View kQ;
        private String kR;
        private final Context mContext;
        private final Map<Api, ApiOptions> kS = new HashMap<Api, ApiOptions>();
        private final Set<ConnectionCallbacks> kT = new HashSet<ConnectionCallbacks>();
        private final Set<OnConnectionFailedListener> kU = new HashSet<OnConnectionFailedListener>();

        public Builder(Context context) {
            this.mContext = context;
            this.kR = context.getPackageName();
        }

        public Builder(Context context, ConnectionCallbacks connectedListener, OnConnectionFailedListener connectionFailedListener) {
            this(context);
            du.c(connectedListener, "Must provide a connected listener");
            this.kT.add(connectedListener);
            du.c(connectionFailedListener, "Must provide a connection failed listener");
            this.kU.add(connectionFailedListener);
        }

        public Builder addConnectionCallbacks(ConnectionCallbacks listener) {
            this.kT.add(listener);
            return this;
        }

        public Builder addOnConnectionFailedListener(OnConnectionFailedListener listener) {
            this.kU.add(listener);
            return this;
        }

        public Builder setViewForPopups(View viewForPopups) {
            this.kQ = viewForPopups;
            return this;
        }

        public Builder addScope(Scope scope) {
            this.kO.add(scope.be());
            return this;
        }

        public Builder addApi(Api api) {
            return this.addApi(api, null);
        }

        public Builder addApi(Api api, ApiOptions options) {
            this.kS.put(api, options);
            List<Scope> list = api.aW();
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.kO.add(list.get(i2).be());
            }
            return this;
        }

        public Builder setAccountName(String accountName) {
            this.jD = accountName;
            return this;
        }

        public Builder useDefaultAccount() {
            return this.setAccountName("<<default account>>");
        }

        public Builder setGravityForPopups(int gravityForPopups) {
            this.kP = gravityForPopups;
            return this;
        }

        public dh bd() {
            return new dh(this.jD, this.kO, this.kP, this.kQ, this.kR);
        }

        public GoogleApiClient build() {
            return new GoogleApiClient(this.mContext, this.bd(), this.kS, this.kT, this.kU);
        }
    }

    public static interface ApiOptions {
    }

    public static interface OnConnectionFailedListener
    extends GooglePlayServicesClient.OnConnectionFailedListener {
    }

    public static interface ConnectionCallbacks
    extends GooglePlayServicesClient.ConnectionCallbacks {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface a<A extends Api.a> {
        public Api.b<A> aV();

        public void a(A var1);
    }
}

