/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.appstate;

import android.content.Context;
import com.google.android.gms.appstate.OnSignOutCompleteListener;
import com.google.android.gms.appstate.OnStateDeletedListener;
import com.google.android.gms.appstate.OnStateListLoadedListener;
import com.google.android.gms.appstate.OnStateLoadedListener;
import com.google.android.gms.appstate.b;
import com.google.android.gms.common.GooglePlayServicesClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.a;
import com.google.android.gms.internal.db;
import com.google.android.gms.internal.dg;
import com.google.android.gms.internal.du;

public final class AppStateClient
implements GooglePlayServicesClient {
    public static final int STATUS_OK = 0;
    public static final int STATUS_INTERNAL_ERROR = 1;
    public static final int STATUS_CLIENT_RECONNECT_REQUIRED = 2;
    public static final int STATUS_NETWORK_ERROR_STALE_DATA = 3;
    public static final int STATUS_NETWORK_ERROR_NO_DATA = 4;
    public static final int STATUS_NETWORK_ERROR_OPERATION_DEFERRED = 5;
    public static final int STATUS_NETWORK_ERROR_OPERATION_FAILED = 6;
    public static final int STATUS_DEVELOPER_ERROR = 7;
    public static final int STATUS_WRITE_OUT_OF_DATE_VERSION = 2000;
    public static final int STATUS_WRITE_SIZE_EXCEEDED = 2001;
    public static final int STATUS_STATE_KEY_NOT_FOUND = 2002;
    public static final int STATUS_STATE_KEY_LIMIT_EXCEEDED = 2003;
    private final db ju;

    private AppStateClient(Context context, GooglePlayServicesClient.ConnectionCallbacks connectedListener, GooglePlayServicesClient.OnConnectionFailedListener connectionFailedListener, String accountName, String[] scopes) {
        this.ju = new db(context, connectedListener, connectionFailedListener, accountName, scopes);
    }

    public void connect() {
        this.ju.connect();
    }

    public boolean isConnected() {
        return this.ju.isConnected();
    }

    public boolean isConnecting() {
        return this.ju.isConnecting();
    }

    public void registerConnectionCallbacks(GooglePlayServicesClient.ConnectionCallbacks listener) {
        this.ju.registerConnectionCallbacks(listener);
    }

    public boolean isConnectionCallbacksRegistered(GooglePlayServicesClient.ConnectionCallbacks listener) {
        return this.ju.isConnectionCallbacksRegistered(listener);
    }

    public void unregisterConnectionCallbacks(GooglePlayServicesClient.ConnectionCallbacks listener) {
        this.ju.unregisterConnectionCallbacks(listener);
    }

    public void registerConnectionFailedListener(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        this.ju.registerConnectionFailedListener(listener);
    }

    public boolean isConnectionFailedListenerRegistered(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        return this.ju.isConnectionFailedListenerRegistered(listener);
    }

    public void unregisterConnectionFailedListener(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        this.ju.unregisterConnectionFailedListener(listener);
    }

    public void disconnect() {
        this.ju.disconnect();
    }

    public void reconnect() {
        this.ju.disconnect();
        this.ju.connect();
    }

    public int getMaxStateSize() {
        return this.ju.getMaxStateSize();
    }

    public int getMaxNumKeys() {
        return this.ju.getMaxNumKeys();
    }

    public void updateState(int stateKey, byte[] data) {
        this.ju.a(new a(null), stateKey, data);
    }

    public void updateStateImmediate(OnStateLoadedListener listener, int stateKey, byte[] data) {
        du.c(listener, "Must provide a valid listener");
        this.ju.a(new a(listener), stateKey, data);
    }

    public void deleteState(final OnStateDeletedListener listener, int stateKey) {
        this.ju.a(new a.c<b.b>(){

            @Override
            public void a(b.b b2) {
                listener.onStateDeleted(b2.getStatus().getStatusCode(), b2.aK());
            }
        }, stateKey);
    }

    public void loadState(OnStateLoadedListener listener, int stateKey) {
        this.ju.b(new a(listener), stateKey);
    }

    public void listStates(final OnStateListLoadedListener listener) {
        this.ju.a(new a.c<b.c>(){

            @Override
            public void a(b.c c2) {
                listener.onStateListLoaded(c2.getStatus().getStatusCode(), c2.aN());
            }
        });
    }

    public void resolveState(OnStateLoadedListener listener, int stateKey, String resolvedVersion, byte[] resolvedData) {
        this.ju.a(new a(listener), stateKey, resolvedVersion, resolvedData);
    }

    public void signOut() {
        this.ju.b(new a.c<Status>(){

            @Override
            public void a(Status status) {
            }
        });
    }

    public void signOut(final OnSignOutCompleteListener listener) {
        du.c(listener, "Must provide a valid listener");
        this.ju.b(new a.c<Status>(){

            @Override
            public void a(Status status) {
                listener.onSignOutComplete();
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class a
    implements a.c<b.e> {
        private final OnStateLoadedListener jE;

        a(OnStateLoadedListener onStateLoadedListener) {
            this.jE = onStateLoadedListener;
        }

        @Override
        public void a(b.e e2) {
            if (this.jE == null) {
                return;
            }
            int n2 = e2.getStatus().getStatusCode();
            if (n2 == 2000) {
                b.a a2 = e2.aP();
                dg.d(a2);
                this.jE.onStateConflict(a2.aK(), a2.aL(), a2.getLocalData(), a2.aM());
            } else {
                b.d d2 = e2.aO();
                dg.d(d2);
                this.jE.onStateLoaded(d2.getStatus().getStatusCode(), d2.aK(), d2.getLocalData());
            }
        }
    }

    public static final class Builder {
        private static final String[] jz = new String[]{"https://www.googleapis.com/auth/appstate"};
        private Context mContext;
        private GooglePlayServicesClient.ConnectionCallbacks jA;
        private GooglePlayServicesClient.OnConnectionFailedListener jB;
        private String[] jC;
        private String jD;

        public Builder(Context context, GooglePlayServicesClient.ConnectionCallbacks connectedListener, GooglePlayServicesClient.OnConnectionFailedListener connectionFailedListener) {
            this.mContext = context;
            this.jA = connectedListener;
            this.jB = connectionFailedListener;
            this.jC = jz;
            this.jD = "<<default account>>";
        }

        public Builder setScopes(String ... scopes) {
            this.jC = scopes;
            return this;
        }

        public Builder setAccountName(String accountName) {
            this.jD = du.f(accountName);
            return this;
        }

        public AppStateClient create() {
            return new AppStateClient(this.mContext, this.jA, this.jB, this.jD, this.jC);
        }
    }
}

