/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.vending.licensing;

import android.content.SharedPreferences;
import android.util.Log;
import com.google.android.vending.licensing.Obfuscator;
import com.google.android.vending.licensing.ValidationException;

public class PreferenceObfuscator {
    private static final String TAG = "PreferenceObfuscator";
    private final SharedPreferences mPreferences;
    private final Obfuscator mObfuscator;
    private SharedPreferences.Editor mEditor;

    public PreferenceObfuscator(SharedPreferences sp, Obfuscator o) {
        this.mPreferences = sp;
        this.mObfuscator = o;
        this.mEditor = null;
    }

    public void putString(String key, String value) {
        if (this.mEditor == null) {
            this.mEditor = this.mPreferences.edit();
        }
        String obfuscatedValue = this.mObfuscator.obfuscate(value, key);
        this.mEditor.putString(key, obfuscatedValue);
    }

    public String getString(String key, String defValue) {
        String result;
        String value = this.mPreferences.getString(key, null);
        if (value != null) {
            try {
                result = this.mObfuscator.unobfuscate(value, key);
            }
            catch (ValidationException e) {
                Log.w((String)TAG, (String)("Validation error while reading preference: " + key));
                result = defValue;
            }
        } else {
            result = defValue;
        }
        return result;
    }

    public void commit() {
        if (this.mEditor != null) {
            this.mEditor.commit();
            this.mEditor = null;
        }
    }
}

