/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.vending.licensing;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.vending.licensing.ILicenseResultListener;
import com.google.android.vending.licensing.ILicensingService;
import com.google.android.vending.licensing.LicenseCheckerCallback;
import com.google.android.vending.licensing.LicenseValidator;
import com.google.android.vending.licensing.NullDeviceLimiter;
import com.google.android.vending.licensing.Policy;
import com.google.android.vending.licensing.util.Base64;
import com.google.android.vending.licensing.util.Base64DecoderException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;

public class LicenseChecker
implements ServiceConnection {
    private static final String TAG = "LicenseChecker";
    private static final String KEY_FACTORY_ALGORITHM = "RSA";
    private static final int TIMEOUT_MS = 10000;
    private static final SecureRandom RANDOM = new SecureRandom();
    private static final boolean DEBUG_LICENSE_ERROR = false;
    private ILicensingService mService;
    private PublicKey mPublicKey;
    private final Context mContext;
    private final Policy mPolicy;
    private Handler mHandler;
    private final String mPackageName;
    private final String mVersionCode;
    private final Set<LicenseValidator> mChecksInProgress = new HashSet<LicenseValidator>();
    private final Queue<LicenseValidator> mPendingChecks = new LinkedList<LicenseValidator>();

    public LicenseChecker(Context context, Policy policy, String encodedPublicKey) {
        this.mContext = context;
        this.mPolicy = policy;
        this.mPublicKey = LicenseChecker.generatePublicKey(encodedPublicKey);
        this.mPackageName = this.mContext.getPackageName();
        this.mVersionCode = LicenseChecker.getVersionCode(context, this.mPackageName);
        HandlerThread handlerThread = new HandlerThread("background thread");
        handlerThread.start();
        this.mHandler = new Handler(handlerThread.getLooper());
    }

    private static PublicKey generatePublicKey(String encodedPublicKey) {
        try {
            byte[] decodedKey = Base64.decode(encodedPublicKey);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_FACTORY_ALGORITHM);
            return keyFactory.generatePublic(new X509EncodedKeySpec(decodedKey));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (Base64DecoderException e) {
            Log.e((String)TAG, (String)"Could not decode from Base64.");
            throw new IllegalArgumentException(e);
        }
        catch (InvalidKeySpecException e) {
            Log.e((String)TAG, (String)"Invalid key specification.");
            throw new IllegalArgumentException(e);
        }
    }

    public synchronized void checkAccess(LicenseCheckerCallback callback) {
        block8: {
            if (this.mPolicy.allowAccess()) {
                Log.i((String)TAG, (String)"Using cached license response");
                callback.allow(256);
            } else {
                LicenseValidator validator = new LicenseValidator(this.mPolicy, new NullDeviceLimiter(), callback, this.generateNonce(), this.mPackageName, this.mVersionCode);
                if (this.mService == null) {
                    Log.i((String)TAG, (String)"Binding to licensing service.");
                    try {
                        boolean bindResult = this.mContext.bindService(new Intent(new String(Base64.decode("Y29tLmFuZHJvaWQudmVuZGluZy5saWNlbnNpbmcuSUxpY2Vuc2luZ1NlcnZpY2U="))), (ServiceConnection)this, 1);
                        if (bindResult) {
                            this.mPendingChecks.offer(validator);
                            break block8;
                        }
                        Log.e((String)TAG, (String)"Could not bind to service.");
                        this.handleServiceConnectionError(validator);
                    }
                    catch (SecurityException e) {
                        callback.applicationError(6);
                    }
                    catch (Base64DecoderException e) {
                        e.printStackTrace();
                    }
                } else {
                    this.mPendingChecks.offer(validator);
                    this.runChecks();
                }
            }
        }
    }

    private void runChecks() {
        LicenseValidator validator;
        while ((validator = this.mPendingChecks.poll()) != null) {
            try {
                Log.i((String)TAG, (String)("Calling checkLicense on service for " + validator.getPackageName()));
                this.mService.checkLicense(validator.getNonce(), validator.getPackageName(), new ResultListener(validator));
                this.mChecksInProgress.add(validator);
            }
            catch (RemoteException e) {
                Log.w((String)TAG, (String)"RemoteException in checkLicense call.", (Throwable)e);
                this.handleServiceConnectionError(validator);
            }
        }
    }

    private synchronized void finishCheck(LicenseValidator validator) {
        this.mChecksInProgress.remove(validator);
        if (this.mChecksInProgress.isEmpty()) {
            this.cleanupService();
        }
    }

    public synchronized void onServiceConnected(ComponentName name, IBinder service) {
        this.mService = ILicensingService.Stub.asInterface(service);
        this.runChecks();
    }

    public synchronized void onServiceDisconnected(ComponentName name) {
        Log.w((String)TAG, (String)"Service unexpectedly disconnected.");
        this.mService = null;
    }

    private synchronized void handleServiceConnectionError(LicenseValidator validator) {
        this.mPolicy.processServerResponse(291, null);
        if (this.mPolicy.allowAccess()) {
            validator.getCallback().allow(291);
        } else {
            validator.getCallback().dontAllow(291);
        }
    }

    private void cleanupService() {
        if (this.mService != null) {
            try {
                this.mContext.unbindService((ServiceConnection)this);
            }
            catch (IllegalArgumentException e) {
                Log.e((String)TAG, (String)"Unable to unbind from licensing service (already unbound)");
            }
            this.mService = null;
        }
    }

    public synchronized void onDestroy() {
        this.cleanupService();
        this.mHandler.getLooper().quit();
    }

    private int generateNonce() {
        return RANDOM.nextInt();
    }

    private static String getVersionCode(Context context, String packageName) {
        try {
            return String.valueOf(context.getPackageManager().getPackageInfo((String)packageName, (int)0).versionCode);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)TAG, (String)"Package not found. could not get version code.");
            return "";
        }
    }

    private class ResultListener
    extends ILicenseResultListener.Stub {
        private final LicenseValidator mValidator;
        private Runnable mOnTimeout;
        private static final int ERROR_CONTACTING_SERVER = 257;
        private static final int ERROR_INVALID_PACKAGE_NAME = 258;
        private static final int ERROR_NON_MATCHING_UID = 259;

        public ResultListener(LicenseValidator validator) {
            this.mValidator = validator;
            this.mOnTimeout = new Runnable(){

                public void run() {
                    Log.i((String)LicenseChecker.TAG, (String)"Check timed out.");
                    LicenseChecker.this.handleServiceConnectionError(ResultListener.this.mValidator);
                    LicenseChecker.this.finishCheck(ResultListener.this.mValidator);
                }
            };
            this.startTimeout();
        }

        public void verifyLicense(final int responseCode, final String signedData, final String signature) {
            LicenseChecker.this.mHandler.post(new Runnable(){

                public void run() {
                    Log.i((String)LicenseChecker.TAG, (String)"Received response.");
                    if (LicenseChecker.this.mChecksInProgress.contains(ResultListener.this.mValidator)) {
                        ResultListener.this.clearTimeout();
                        ResultListener.this.mValidator.verify(LicenseChecker.this.mPublicKey, responseCode, signedData, signature);
                        LicenseChecker.this.finishCheck(ResultListener.this.mValidator);
                    }
                }
            });
        }

        private void startTimeout() {
            Log.i((String)LicenseChecker.TAG, (String)"Start monitoring timeout.");
            LicenseChecker.this.mHandler.postDelayed(this.mOnTimeout, 10000L);
        }

        private void clearTimeout() {
            Log.i((String)LicenseChecker.TAG, (String)"Clearing timeout.");
            LicenseChecker.this.mHandler.removeCallbacks(this.mOnTimeout);
        }
    }
}

