/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.vending.expansion.downloader.impl;

import android.app.Notification;
import android.app.PendingIntent;
import android.content.Context;
import android.os.Build;
import android.widget.RemoteViews;
import com.google.android.vending.expansion.downloader.Helpers;
import com.google.android.vending.expansion.downloader.impl.DownloadNotification;

public class V3CustomNotification
implements DownloadNotification.ICustomNotification {
    CharSequence mTitle;
    CharSequence mTicker;
    int mIcon;
    long mTotalBytes = -1L;
    long mCurrentBytes = -1L;
    long mTimeRemaining;
    PendingIntent mPendingIntent;
    Notification mNotification = new Notification();

    public void setIcon(int icon) {
        this.mIcon = icon;
    }

    public void setTitle(CharSequence title) {
        this.mTitle = title;
    }

    public void setTotalBytes(long totalBytes) {
        this.mTotalBytes = totalBytes;
    }

    public void setCurrentBytes(long currentBytes) {
        this.mCurrentBytes = currentBytes;
    }

    public Notification updateNotification(Context c) {
        Notification n = this.mNotification;
        n.icon = this.mIcon;
        n.flags |= 2;
        if (Build.VERSION.SDK_INT > 10) {
            n.flags |= 8;
        }
        RemoteViews expandedView = new RemoteViews(c.getPackageName(), 2130903040);
        expandedView.setTextViewText(2131099651, this.mTitle);
        expandedView.setViewVisibility(2131099655, 0);
        expandedView.setTextViewText(2131099655, (CharSequence)Helpers.getDownloadProgressString(this.mCurrentBytes, this.mTotalBytes));
        expandedView.setViewVisibility(2131099653, 0);
        expandedView.setProgressBar(2131099654, (int)(this.mTotalBytes >> 8), (int)(this.mCurrentBytes >> 8), this.mTotalBytes <= 0L);
        expandedView.setViewVisibility(2131099652, 0);
        expandedView.setTextViewText(2131099652, (CharSequence)c.getString(2130968598, new Object[]{Helpers.getTimeRemaining(this.mTimeRemaining)}));
        expandedView.setTextViewText(2131099650, (CharSequence)Helpers.getDownloadProgressPercent(this.mCurrentBytes, this.mTotalBytes));
        expandedView.setImageViewResource(2131099649, this.mIcon);
        n.contentView = expandedView;
        n.contentIntent = this.mPendingIntent;
        return n;
    }

    public void setPendingIntent(PendingIntent contentIntent) {
        this.mPendingIntent = contentIntent;
    }

    public void setTicker(CharSequence ticker) {
        this.mTicker = ticker;
    }

    public void setTimeRemaining(long timeRemaining) {
        this.mTimeRemaining = timeRemaining;
    }
}

