/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.vending.expansion.downloader.impl;

import android.app.Notification;
import android.app.PendingIntent;
import android.content.Context;
import com.google.android.vending.expansion.downloader.Helpers;
import com.google.android.vending.expansion.downloader.impl.DownloadNotification;

public class V14CustomNotification
implements DownloadNotification.ICustomNotification {
    CharSequence mTitle;
    CharSequence mTicker;
    int mIcon;
    long mTotalKB = -1L;
    long mCurrentKB = -1L;
    long mTimeRemaining;
    PendingIntent mPendingIntent;

    public void setIcon(int icon) {
        this.mIcon = icon;
    }

    public void setTitle(CharSequence title) {
        this.mTitle = title;
    }

    public void setTotalBytes(long totalBytes) {
        this.mTotalKB = totalBytes;
    }

    public void setCurrentBytes(long currentBytes) {
        this.mCurrentKB = currentBytes;
    }

    void setProgress(Notification.Builder builder) {
    }

    public Notification updateNotification(Context c) {
        Notification.Builder builder = new Notification.Builder(c);
        builder.setContentTitle(this.mTitle);
        if (this.mTotalKB > 0L && -1L != this.mCurrentKB) {
            builder.setProgress((int)(this.mTotalKB >> 8), (int)(this.mCurrentKB >> 8), false);
        } else {
            builder.setProgress(0, 0, true);
        }
        builder.setContentText((CharSequence)Helpers.getDownloadProgressString(this.mCurrentKB, this.mTotalKB));
        builder.setContentInfo((CharSequence)c.getString(2130968598, new Object[]{Helpers.getTimeRemaining(this.mTimeRemaining)}));
        if (this.mIcon != 0) {
            builder.setSmallIcon(this.mIcon);
        } else {
            int iconResource = 0x1080081;
            builder.setSmallIcon(iconResource);
        }
        builder.setOngoing(true);
        builder.setTicker(this.mTicker);
        builder.setContentIntent(this.mPendingIntent);
        builder.setOnlyAlertOnce(true);
        return builder.getNotification();
    }

    public void setPendingIntent(PendingIntent contentIntent) {
        this.mPendingIntent = contentIntent;
    }

    public void setTicker(CharSequence ticker) {
        this.mTicker = ticker;
    }

    public void setTimeRemaining(long timeRemaining) {
        this.mTimeRemaining = timeRemaining;
    }
}

