/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.vending.expansion.downloader.impl;

import android.content.Context;
import android.net.Proxy;
import android.os.Build;
import android.os.PowerManager;
import android.os.Process;
import android.util.Log;
import com.google.android.vending.expansion.downloader.Helpers;
import com.google.android.vending.expansion.downloader.impl.AndroidHttpClient;
import com.google.android.vending.expansion.downloader.impl.DownloadInfo;
import com.google.android.vending.expansion.downloader.impl.DownloadNotification;
import com.google.android.vending.expansion.downloader.impl.DownloaderService;
import com.google.android.vending.expansion.downloader.impl.DownloadsDB;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SyncFailedException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.params.ConnRouteParams;
import org.apache.http.params.HttpParams;

public class DownloadThread {
    private Context mContext;
    private DownloadInfo mInfo;
    private DownloaderService mService;
    private final DownloadsDB mDB;
    private final DownloadNotification mNotification;
    private String mUserAgent;

    public DownloadThread(DownloadInfo info, DownloaderService service, DownloadNotification notification) {
        this.mContext = service;
        this.mInfo = info;
        this.mService = service;
        this.mNotification = notification;
        this.mDB = DownloadsDB.getDB((Context)service);
        this.mUserAgent = "APKXDL (Linux; U; Android " + Build.VERSION.RELEASE + ";" + Locale.getDefault().toString() + "; " + Build.DEVICE + "/" + Build.ID + ")" + service.getPackageName();
    }

    private String userAgent() {
        return this.mUserAgent;
    }

    public HttpHost getPreferredHttpHost(Context context, String url) {
        String proxyHost;
        if (!DownloadThread.isLocalHost(url) && !this.mService.isWiFi() && (proxyHost = Proxy.getHost((Context)context)) != null) {
            return new HttpHost(proxyHost, Proxy.getPort((Context)context), "http");
        }
        return null;
    }

    private static final boolean isLocalHost(String url) {
        if (url == null) {
            return false;
        }
        try {
            URI uri = URI.create(url);
            String host = uri.getHost();
            if (host != null && (host.equalsIgnoreCase("localhost") || host.equals("127.0.0.1") || host.equals("[::1]"))) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Process.setThreadPriority((int)10);
        State state = new State(this.mInfo, this.mService);
        AndroidHttpClient client = null;
        PowerManager.WakeLock wakeLock = null;
        int finalStatus = 491;
        try {
            PowerManager pm = (PowerManager)this.mContext.getSystemService("power");
            wakeLock = pm.newWakeLock(1, "LVLDL");
            wakeLock.acquire();
            client = AndroidHttpClient.newInstance(this.userAgent(), this.mContext);
            boolean finished = false;
            while (!finished) {
                ConnRouteParams.setDefaultProxy((HttpParams)client.getParams(), (HttpHost)this.getPreferredHttpHost(this.mContext, state.mRequestUri));
                HttpGet request = new HttpGet(state.mRequestUri);
                try {
                    this.executeDownload(state, client, request);
                    finished = true;
                }
                catch (RetryDownload retryDownload) {}
                continue;
                finally {
                    request.abort();
                    request = null;
                }
            }
            this.finalizeDestinationFile(state);
            finalStatus = 200;
        }
        catch (StopRequest error) {
            Log.w((String)"LVLDL", (String)("Aborting request for download " + this.mInfo.mFileName + ": " + error.getMessage()));
            error.printStackTrace();
            finalStatus = error.mFinalStatus;
        }
        catch (Throwable ex) {
            Log.w((String)"LVLDL", (String)("Exception for " + this.mInfo.mFileName + ": " + ex));
            finalStatus = 491;
        }
        finally {
            if (wakeLock != null) {
                wakeLock.release();
                wakeLock = null;
            }
            if (client != null) {
                client.close();
                client = null;
            }
            this.cleanupDestination(state, finalStatus);
            this.notifyDownloadCompleted(finalStatus, state.mCountRetry, state.mRetryAfter, state.mRedirectCount, state.mGotData, state.mFilename);
        }
    }

    private void executeDownload(State state, AndroidHttpClient client, HttpGet request) throws StopRequest, RetryDownload {
        InnerState innerState = new InnerState();
        byte[] data = new byte[4096];
        this.checkPausedOrCanceled(state);
        this.setupDestinationFile(state, innerState);
        this.addRequestHeaders(innerState, request);
        this.checkConnectivity(state);
        this.mNotification.onDownloadStateChanged(3);
        HttpResponse response = this.sendRequest(state, client, request);
        this.handleExceptionalStatus(state, innerState, response);
        this.processResponseHeaders(state, innerState, response);
        InputStream entityStream = this.openResponseEntity(state, response);
        this.mNotification.onDownloadStateChanged(4);
        this.transferData(state, innerState, data, entityStream);
    }

    private void checkConnectivity(State state) throws StopRequest {
        switch (this.mService.getNetworkAvailabilityState(this.mDB)) {
            case 1: {
                return;
            }
            case 2: {
                throw new StopRequest(195, "waiting for network to return");
            }
            case 6: {
                throw new StopRequest(196, "waiting for wifi or for download over cellular to be authorized");
            }
            case 5: {
                throw new StopRequest(195, "roaming is not allowed");
            }
            case 3: {
                throw new StopRequest(197, "waiting for wifi");
            }
        }
    }

    private void transferData(State state, InnerState innerState, byte[] data, InputStream entityStream) throws StopRequest {
        while (true) {
            int bytesRead;
            if ((bytesRead = this.readFromResponse(state, innerState, data, entityStream)) == -1) {
                this.handleEndOfStream(state, innerState);
                return;
            }
            state.mGotData = true;
            this.writeDataToDestination(state, data, bytesRead);
            innerState.mBytesSoFar += bytesRead;
            innerState.mBytesThisSession += bytesRead;
            this.reportProgress(state, innerState);
            this.checkPausedOrCanceled(state);
        }
    }

    private void finalizeDestinationFile(State state) throws StopRequest {
        this.syncDestination(state);
        String tempFilename = state.mFilename;
        String finalFilename = Helpers.generateSaveFileName((Context)this.mService, this.mInfo.mFileName);
        if (!state.mFilename.equals(finalFilename)) {
            File startFile = new File(tempFilename);
            File destFile = new File(finalFilename);
            if (this.mInfo.mTotalBytes != -1L && this.mInfo.mCurrentBytes == this.mInfo.mTotalBytes) {
                if (!startFile.renameTo(destFile)) {
                    throw new StopRequest(492, "unable to finalize destination file");
                }
            } else {
                throw new StopRequest(487, "file delivered with incorrect size. probably due to network not browser configured");
            }
        }
    }

    private void cleanupDestination(State state, int finalStatus) {
        this.closeDestination(state);
        if (state.mFilename != null && DownloaderService.isStatusError(finalStatus)) {
            new File(state.mFilename).delete();
            state.mFilename = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncDestination(State state) {
        FileOutputStream downloadedFileStream = null;
        try {
            downloadedFileStream = new FileOutputStream(state.mFilename, true);
            downloadedFileStream.getFD().sync();
        }
        catch (FileNotFoundException ex) {
            Log.w((String)"LVLDL", (String)("file " + state.mFilename + " not found: " + ex));
        }
        catch (SyncFailedException ex) {
            Log.w((String)"LVLDL", (String)("file " + state.mFilename + " sync failed: " + ex));
        }
        catch (IOException ex) {
            Log.w((String)"LVLDL", (String)("IOException trying to sync " + state.mFilename + ": " + ex));
        }
        catch (RuntimeException ex) {
            Log.w((String)"LVLDL", (String)"exception while syncing file: ", (Throwable)ex);
        }
        finally {
            if (downloadedFileStream != null) {
                try {
                    downloadedFileStream.close();
                }
                catch (IOException ex) {
                    Log.w((String)"LVLDL", (String)"IOException while closing synced file: ", (Throwable)ex);
                }
                catch (RuntimeException ex) {
                    Log.w((String)"LVLDL", (String)"exception while closing file: ", (Throwable)ex);
                }
            }
        }
    }

    private void closeDestination(State state) {
        try {
            if (state.mStream != null) {
                state.mStream.close();
                state.mStream = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void checkPausedOrCanceled(State state) throws StopRequest {
        if (this.mService.getControl() == 1) {
            int status = this.mService.getStatus();
            switch (status) {
                case 193: {
                    throw new StopRequest(this.mService.getStatus(), "download paused");
                }
            }
        }
    }

    private void reportProgress(State state, InnerState innerState) {
        long now = System.currentTimeMillis();
        if (innerState.mBytesSoFar - innerState.mBytesNotified > 4096 && now - innerState.mTimeLastNotification > 1000L) {
            this.mInfo.mCurrentBytes = innerState.mBytesSoFar;
            this.mDB.updateDownloadCurrentBytes(this.mInfo);
            innerState.mBytesNotified = innerState.mBytesSoFar;
            innerState.mTimeLastNotification = now;
            long totalBytesSoFar = (long)innerState.mBytesThisSession + this.mService.mBytesSoFar;
            this.mService.notifyUpdateBytes(totalBytesSoFar);
        }
    }

    private void writeDataToDestination(State state, byte[] data, int bytesRead) throws StopRequest {
        try {
            if (state.mStream == null) {
                state.mStream = new FileOutputStream(state.mFilename, true);
            }
            state.mStream.write(data, 0, bytesRead);
            this.closeDestination(state);
            return;
        }
        catch (IOException ex) {
            if (!Helpers.isExternalMediaMounted()) {
                throw new StopRequest(499, "external media not mounted while writing destination file");
            }
            long availableBytes = Helpers.getAvailableBytes(Helpers.getFilesystemRoot(state.mFilename));
            if (availableBytes < (long)bytesRead) {
                throw new StopRequest(498, "insufficient space while writing destination file", ex);
            }
            throw new StopRequest(492, "while writing destination file: " + ex.toString(), ex);
        }
    }

    private void handleEndOfStream(State state, InnerState innerState) throws StopRequest {
        boolean lengthMismatched;
        this.mInfo.mCurrentBytes = innerState.mBytesSoFar;
        this.mDB.updateDownload(this.mInfo);
        boolean bl = lengthMismatched = innerState.mHeaderContentLength != null && innerState.mBytesSoFar != Integer.parseInt(innerState.mHeaderContentLength);
        if (lengthMismatched) {
            if (this.cannotResume(innerState)) {
                throw new StopRequest(489, "mismatched content length");
            }
            throw new StopRequest(this.getFinalStatusForHttpError(state), "closed socket before end of file");
        }
    }

    private boolean cannotResume(InnerState innerState) {
        return innerState.mBytesSoFar > 0 && innerState.mHeaderETag == null;
    }

    private int readFromResponse(State state, InnerState innerState, byte[] data, InputStream entityStream) throws StopRequest {
        try {
            return entityStream.read(data);
        }
        catch (IOException ex) {
            this.logNetworkState();
            this.mInfo.mCurrentBytes = innerState.mBytesSoFar;
            this.mDB.updateDownload(this.mInfo);
            if (this.cannotResume(innerState)) {
                String message = "while reading response: " + ex.toString() + ", can't resume interrupted download with no ETag";
                throw new StopRequest(489, message, ex);
            }
            throw new StopRequest(this.getFinalStatusForHttpError(state), "while reading response: " + ex.toString(), ex);
        }
    }

    private InputStream openResponseEntity(State state, HttpResponse response) throws StopRequest {
        try {
            return response.getEntity().getContent();
        }
        catch (IOException ex) {
            this.logNetworkState();
            throw new StopRequest(this.getFinalStatusForHttpError(state), "while getting entity: " + ex.toString(), ex);
        }
    }

    private void logNetworkState() {
        Log.i((String)"LVLDL", (String)("Net " + (this.mService.getNetworkAvailabilityState(this.mDB) == 1 ? "Up" : "Down")));
    }

    private void processResponseHeaders(State state, InnerState innerState, HttpResponse response) throws StopRequest {
        if (innerState.mContinuingDownload) {
            return;
        }
        this.readResponseHeaders(state, innerState, response);
        try {
            state.mFilename = this.mService.generateSaveFile(this.mInfo.mFileName, this.mInfo.mTotalBytes);
        }
        catch (DownloaderService.GenerateSaveFileError exc) {
            throw new StopRequest(exc.mStatus, exc.mMessage);
        }
        try {
            state.mStream = new FileOutputStream(state.mFilename);
        }
        catch (FileNotFoundException exc) {
            File pathFile = new File(Helpers.getSaveFilePath((Context)this.mService));
            try {
                if (pathFile.mkdirs()) {
                    state.mStream = new FileOutputStream(state.mFilename);
                }
            }
            catch (Exception ex) {
                throw new StopRequest(492, "while opening destination file: " + exc.toString(), exc);
            }
        }
        this.updateDatabaseFromHeaders(state, innerState);
        this.checkConnectivity(state);
    }

    private void updateDatabaseFromHeaders(State state, InnerState innerState) {
        this.mInfo.mETag = innerState.mHeaderETag;
        this.mDB.updateDownload(this.mInfo);
    }

    private void readResponseHeaders(State state, InnerState innerState, HttpResponse response) throws StopRequest {
        boolean noSizeInfo;
        Header header = response.getFirstHeader("Content-Disposition");
        if (header != null) {
            innerState.mHeaderContentDisposition = header.getValue();
        }
        if ((header = response.getFirstHeader("Content-Location")) != null) {
            innerState.mHeaderContentLocation = header.getValue();
        }
        if ((header = response.getFirstHeader("ETag")) != null) {
            innerState.mHeaderETag = header.getValue();
        }
        String headerTransferEncoding = null;
        header = response.getFirstHeader("Transfer-Encoding");
        if (header != null) {
            headerTransferEncoding = header.getValue();
        }
        String headerContentType = null;
        header = response.getFirstHeader("Content-Type");
        if (header != null && !(headerContentType = header.getValue()).equals("application/vnd.android.obb")) {
            throw new StopRequest(487, "file delivered with incorrect Mime type");
        }
        if (headerTransferEncoding == null && (header = response.getFirstHeader("Content-Length")) != null) {
            innerState.mHeaderContentLength = header.getValue();
            long contentLength = Long.parseLong(innerState.mHeaderContentLength);
            if (contentLength != -1L && contentLength != this.mInfo.mTotalBytes) {
                Log.e((String)"LVLDL", (String)"Incorrect file size delivered.");
            }
        }
        boolean bl = noSizeInfo = innerState.mHeaderContentLength == null && (headerTransferEncoding == null || !headerTransferEncoding.equalsIgnoreCase("chunked"));
        if (noSizeInfo) {
            throw new StopRequest(495, "can't know size of download, giving up");
        }
    }

    private void handleExceptionalStatus(State state, InnerState innerState, HttpResponse response) throws StopRequest, RetryDownload {
        int expectedStatus;
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 503 && this.mInfo.mNumFailed < 5) {
            this.handleServiceUnavailable(state, response);
        }
        if (statusCode == 301 || statusCode == 302 || statusCode == 303 || statusCode == 307) {
            this.handleRedirect(state, response, statusCode);
        }
        int n = expectedStatus = innerState.mContinuingDownload ? 206 : 200;
        if (statusCode != expectedStatus) {
            this.handleOtherStatus(state, innerState, statusCode);
        } else {
            state.mRedirectCount = 0;
        }
    }

    private void handleOtherStatus(State state, InnerState innerState, int statusCode) throws StopRequest {
        int finalStatus = DownloaderService.isStatusError(statusCode) ? statusCode : (statusCode >= 300 && statusCode < 400 ? 493 : (innerState.mContinuingDownload && statusCode == 200 ? 489 : 494));
        throw new StopRequest(finalStatus, "http error " + statusCode);
    }

    private void handleRedirect(State state, HttpResponse response, int statusCode) throws StopRequest, RetryDownload {
        String newUri;
        if (state.mRedirectCount >= 5) {
            throw new StopRequest(497, "too many redirects");
        }
        Header header = response.getFirstHeader("Location");
        if (header == null) {
            return;
        }
        try {
            newUri = new URI(this.mInfo.mUri).resolve(new URI(header.getValue())).toString();
        }
        catch (URISyntaxException ex) {
            throw new StopRequest(495, "Couldn't resolve redirect URI");
        }
        ++state.mRedirectCount;
        state.mRequestUri = newUri;
        if (statusCode == 301 || statusCode == 303) {
            state.mNewUri = newUri;
        }
        throw new RetryDownload();
    }

    private void addRequestHeaders(InnerState innerState, HttpGet request) {
        if (innerState.mContinuingDownload) {
            if (innerState.mHeaderETag != null) {
                request.addHeader("If-Match", innerState.mHeaderETag);
            }
            request.addHeader("Range", "bytes=" + innerState.mBytesSoFar + "-");
        }
    }

    private void handleServiceUnavailable(State state, HttpResponse response) throws StopRequest {
        state.mCountRetry = true;
        Header header = response.getFirstHeader("Retry-After");
        if (header != null) {
            try {
                state.mRetryAfter = Integer.parseInt(header.getValue());
                if (state.mRetryAfter < 0) {
                    state.mRetryAfter = 0;
                } else {
                    if (state.mRetryAfter < 30) {
                        state.mRetryAfter = 30;
                    } else if (state.mRetryAfter > 86400) {
                        state.mRetryAfter = 86400;
                    }
                    state.mRetryAfter += Helpers.sRandom.nextInt(31);
                    state.mRetryAfter *= 1000;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new StopRequest(194, "got 503 Service Unavailable, will retry later");
    }

    private HttpResponse sendRequest(State state, AndroidHttpClient client, HttpGet request) throws StopRequest {
        try {
            return client.execute((HttpUriRequest)request);
        }
        catch (IllegalArgumentException ex) {
            throw new StopRequest(495, "while trying to execute request: " + ex.toString(), ex);
        }
        catch (IOException ex) {
            this.logNetworkState();
            throw new StopRequest(this.getFinalStatusForHttpError(state), "while trying to execute request: " + ex.toString(), ex);
        }
    }

    private int getFinalStatusForHttpError(State state) {
        if (this.mService.getNetworkAvailabilityState(this.mDB) != 1) {
            return 195;
        }
        if (this.mInfo.mNumFailed < 5) {
            state.mCountRetry = true;
            return 194;
        }
        Log.w((String)"LVLDL", (String)("reached max retries for " + this.mInfo.mNumFailed));
        return 495;
    }

    private void setupDestinationFile(State state, InnerState innerState) throws StopRequest {
        if (state.mFilename != null) {
            if (!Helpers.isFilenameValid(state.mFilename)) {
                throw new StopRequest(492, "found invalid internal destination filename");
            }
            File f = new File(state.mFilename);
            if (f.exists()) {
                long fileLength = f.length();
                if (fileLength == 0L) {
                    f.delete();
                    state.mFilename = null;
                } else {
                    if (this.mInfo.mETag == null) {
                        f.delete();
                        throw new StopRequest(489, "Trying to resume a download that can't be resumed");
                    }
                    try {
                        state.mStream = new FileOutputStream(state.mFilename, true);
                    }
                    catch (FileNotFoundException exc) {
                        throw new StopRequest(492, "while opening destination for resuming: " + exc.toString(), exc);
                    }
                    innerState.mBytesSoFar = (int)fileLength;
                    if (this.mInfo.mTotalBytes != -1L) {
                        innerState.mHeaderContentLength = Long.toString(this.mInfo.mTotalBytes);
                    }
                    innerState.mHeaderETag = this.mInfo.mETag;
                    innerState.mContinuingDownload = true;
                }
            }
        }
        if (state.mStream != null) {
            this.closeDestination(state);
        }
    }

    private void notifyDownloadCompleted(int status, boolean countRetry, int retryAfter, int redirectCount, boolean gotData, String filename) {
        this.updateDownloadDatabase(status, countRetry, retryAfter, redirectCount, gotData, filename);
        if (DownloaderService.isStatusCompleted(status)) {
            // empty if block
        }
    }

    private void updateDownloadDatabase(int status, boolean countRetry, int retryAfter, int redirectCount, boolean gotData, String filename) {
        this.mInfo.mStatus = status;
        this.mInfo.mRetryAfter = retryAfter;
        this.mInfo.mRedirectCount = redirectCount;
        this.mInfo.mLastMod = System.currentTimeMillis();
        this.mInfo.mNumFailed = !countRetry ? 0 : (gotData ? 1 : ++this.mInfo.mNumFailed);
        this.mDB.updateDownload(this.mInfo);
    }

    private class RetryDownload
    extends Throwable {
        private static final long serialVersionUID = 6196036036517540229L;

        private RetryDownload() {
        }
    }

    private class StopRequest
    extends Throwable {
        private static final long serialVersionUID = 6338592678988347973L;
        public int mFinalStatus;

        public StopRequest(int finalStatus, String message) {
            super(message);
            this.mFinalStatus = finalStatus;
        }

        public StopRequest(int finalStatus, String message, Throwable throwable) {
            super(message, throwable);
            this.mFinalStatus = finalStatus;
        }
    }

    private static class InnerState {
        public int mBytesSoFar = 0;
        public int mBytesThisSession = 0;
        public String mHeaderETag;
        public boolean mContinuingDownload = false;
        public String mHeaderContentLength;
        public String mHeaderContentDisposition;
        public String mHeaderContentLocation;
        public int mBytesNotified = 0;
        public long mTimeLastNotification = 0L;

        private InnerState() {
        }
    }

    private static class State {
        public String mFilename;
        public FileOutputStream mStream;
        public boolean mCountRetry = false;
        public int mRetryAfter = 0;
        public int mRedirectCount = 0;
        public String mNewUri;
        public boolean mGotData = false;
        public String mRequestUri;

        public State(DownloadInfo info, DownloaderService service) {
            this.mRedirectCount = info.mRedirectCount;
            this.mRequestUri = info.mUri;
            this.mFilename = service.generateTempSaveFileName(info.mFileName);
        }
    }
}

