/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.vending.expansion.downloader;

import android.app.Notification;
import android.app.NotificationManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.telephony.TelephonyManager;
import android.util.Log;

class SystemFacade {
    private Context mContext;
    private NotificationManager mNotificationManager;

    public SystemFacade(Context context) {
        this.mContext = context;
        this.mNotificationManager = (NotificationManager)this.mContext.getSystemService("notification");
    }

    public long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    public Integer getActiveNetworkType() {
        ConnectivityManager connectivity = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        if (connectivity == null) {
            Log.w((String)"LVLDL", (String)"couldn't get connectivity manager");
            return null;
        }
        NetworkInfo activeInfo = connectivity.getActiveNetworkInfo();
        if (activeInfo == null) {
            return null;
        }
        return activeInfo.getType();
    }

    public boolean isNetworkRoaming() {
        ConnectivityManager connectivity = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        if (connectivity == null) {
            Log.w((String)"LVLDL", (String)"couldn't get connectivity manager");
            return false;
        }
        NetworkInfo info = connectivity.getActiveNetworkInfo();
        boolean isMobile = info != null && info.getType() == 0;
        TelephonyManager tm = (TelephonyManager)this.mContext.getSystemService("phone");
        if (null == tm) {
            Log.w((String)"LVLDL", (String)"couldn't get telephony manager");
            return false;
        }
        boolean isRoaming = isMobile && tm.isNetworkRoaming();
        return isRoaming;
    }

    public Long getMaxBytesOverMobile() {
        return Integer.MAX_VALUE;
    }

    public Long getRecommendedMaxBytesOverMobile() {
        return 0x200000L;
    }

    public void sendBroadcast(Intent intent) {
        this.mContext.sendBroadcast(intent);
    }

    public boolean userOwnsPackage(int uid, String packageName) throws PackageManager.NameNotFoundException {
        return this.mContext.getPackageManager().getApplicationInfo((String)packageName, (int)0).uid == uid;
    }

    public void postNotification(long id2, Notification notification) {
        this.mNotificationManager.notify((int)id2, notification);
    }

    public void cancelNotification(long id2) {
        this.mNotificationManager.cancel((int)id2);
    }

    public void cancelAllNotifications() {
        this.mNotificationManager.cancelAll();
    }

    public void startThread(Thread thread) {
        thread.start();
    }
}

