/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.vending.expansion.downloader;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcelable;
import android.os.RemoteException;
import com.google.android.vending.expansion.downloader.DownloadProgressInfo;
import com.google.android.vending.expansion.downloader.IDownloaderClient;
import com.google.android.vending.expansion.downloader.IStub;
import com.google.android.vending.expansion.downloader.impl.DownloaderService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloaderClientMarshaller {
    public static final int MSG_ONDOWNLOADSTATE_CHANGED = 10;
    public static final int MSG_ONDOWNLOADPROGRESS = 11;
    public static final int MSG_ONSERVICECONNECTED = 12;
    public static final String PARAM_NEW_STATE = "newState";
    public static final String PARAM_PROGRESS = "progress";
    public static final String PARAM_MESSENGER = "EMH";
    public static final int NO_DOWNLOAD_REQUIRED = 0;
    public static final int LVL_CHECK_REQUIRED = 1;
    public static final int DOWNLOAD_REQUIRED = 2;

    public static IDownloaderClient CreateProxy(Messenger msg) {
        return new Proxy(msg);
    }

    public static IStub CreateStub(IDownloaderClient itf, Class<?> downloaderService) {
        return new Stub(itf, downloaderService);
    }

    public static int startDownloadServiceIfRequired(Context context, PendingIntent notificationClient, Class<?> serviceClass) throws PackageManager.NameNotFoundException {
        return DownloaderService.startDownloadServiceIfRequired(context, notificationClient, serviceClass);
    }

    public static int startDownloadServiceIfRequired(Context context, Intent notificationClient, Class<?> serviceClass) throws PackageManager.NameNotFoundException {
        return DownloaderService.startDownloadServiceIfRequired(context, notificationClient, serviceClass);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Stub
    implements IStub {
        private IDownloaderClient mItf = null;
        private Class<?> mDownloaderServiceClass;
        private boolean mBound;
        private Messenger mServiceMessenger;
        private Context mContext;
        final Messenger mMessenger = new Messenger(new Handler(){

            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 11: {
                        Bundle bun = msg.getData();
                        if (null == Stub.this.mContext) break;
                        bun.setClassLoader(Stub.this.mContext.getClassLoader());
                        DownloadProgressInfo dpi = (DownloadProgressInfo)msg.getData().getParcelable(DownloaderClientMarshaller.PARAM_PROGRESS);
                        Stub.this.mItf.onDownloadProgress(dpi);
                        break;
                    }
                    case 10: {
                        Stub.this.mItf.onDownloadStateChanged(msg.getData().getInt(DownloaderClientMarshaller.PARAM_NEW_STATE));
                        break;
                    }
                    case 12: {
                        Stub.this.mItf.onServiceConnected((Messenger)msg.getData().getParcelable(DownloaderClientMarshaller.PARAM_MESSENGER));
                    }
                }
            }
        });
        private ServiceConnection mConnection = new ServiceConnection(){

            public void onServiceConnected(ComponentName className, IBinder service) {
                Stub.this.mServiceMessenger = new Messenger(service);
                Stub.this.mItf.onServiceConnected(Stub.this.mServiceMessenger);
            }

            public void onServiceDisconnected(ComponentName className) {
                Stub.this.mServiceMessenger = null;
            }
        };

        public Stub(IDownloaderClient itf, Class<?> downloaderService) {
            this.mItf = itf;
            this.mDownloaderServiceClass = downloaderService;
        }

        @Override
        public void connect(Context c) {
            this.mContext = c;
            Intent bindIntent = new Intent(c, this.mDownloaderServiceClass);
            bindIntent.putExtra(DownloaderClientMarshaller.PARAM_MESSENGER, (Parcelable)this.mMessenger);
            if (c.bindService(bindIntent, this.mConnection, 2)) {
                this.mBound = true;
            }
        }

        @Override
        public void disconnect(Context c) {
            if (this.mBound) {
                c.unbindService(this.mConnection);
                this.mBound = false;
            }
            this.mContext = null;
        }

        @Override
        public Messenger getMessenger() {
            return this.mMessenger;
        }
    }

    private static class Proxy
    implements IDownloaderClient {
        private Messenger mServiceMessenger;

        public void onDownloadStateChanged(int newState) {
            Bundle params = new Bundle(1);
            params.putInt(DownloaderClientMarshaller.PARAM_NEW_STATE, newState);
            this.send(10, params);
        }

        public void onDownloadProgress(DownloadProgressInfo progress) {
            Bundle params = new Bundle(1);
            params.putParcelable(DownloaderClientMarshaller.PARAM_PROGRESS, (Parcelable)progress);
            this.send(11, params);
        }

        private void send(int method, Bundle params) {
            Message m = Message.obtain(null, (int)method);
            m.setData(params);
            try {
                this.mServiceMessenger.send(m);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }

        public Proxy(Messenger msg) {
            this.mServiceMessenger = msg;
        }

        public void onServiceConnected(Messenger m) {
        }
    }
}

