/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.espresso.intent;

import android.content.Intent;
import android.support.test.espresso.intent.VerifiableIntent;
import android.support.test.espresso.intent.VerificationMode;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.hamcrest.Matcher;

public final class VerificationModes {
    public static VerificationMode noUnverifiedIntents() {
        return new NoUnverifiedIntents();
    }

    public static VerificationMode times(int times) {
        return new Times(times);
    }

    private static String joinOnDash(List<VerifiableIntent> recordedIntents) {
        if (recordedIntents.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        for (VerifiableIntent i : recordedIntents) {
            sb.append(String.format("\n-%s)", i));
        }
        return sb.toString();
    }

    private VerificationModes() {
    }

    private static final class Times
    implements VerificationMode {
        private final int times;

        public Times(int times) {
            this.times = times;
        }

        @Override
        public void verify(Matcher<Intent> matcher, List<VerifiableIntent> recordedIntents) {
            ArrayList<VerifiableIntent> matchedIntents = new ArrayList<VerifiableIntent>();
            for (VerifiableIntent verifiableIntent : recordedIntents) {
                if (!matcher.matches((Object)verifiableIntent.getIntent())) continue;
                matchedIntents.add(verifiableIntent);
            }
            int matches = matchedIntents.size();
            if (matches != this.times) {
                Assert.fail((String)String.format("Wanted to match %d intents. Actually matched %d intents.\n\nIntentMatcher: %s\n\nMatched intents:%s\n\nRecorded intents:%s", this.times, matches, matcher, VerificationModes.joinOnDash(matchedIntents), VerificationModes.joinOnDash(recordedIntents)));
            }
            for (VerifiableIntent verifiableIntent : matchedIntents) {
                verifiableIntent.markAsVerified();
            }
        }
    }

    private static final class NoUnverifiedIntents
    implements VerificationMode {
        private NoUnverifiedIntents() {
        }

        @Override
        public void verify(Matcher<Intent> matcher, List<VerifiableIntent> recordedIntents) {
            ArrayList<VerifiableIntent> unverifiedIntents = new ArrayList<VerifiableIntent>();
            for (VerifiableIntent verifiableIntent : recordedIntents) {
                if (!matcher.matches((Object)verifiableIntent.getIntent()) || verifiableIntent.hasBeenVerified()) continue;
                unverifiedIntents.add(verifiableIntent);
            }
            if (!unverifiedIntents.isEmpty()) {
                Assert.fail((String)String.format("Found unverified intents.\n\nUnverified intents:%s\n\nRecorded intents:%s", VerificationModes.joinOnDash(unverifiedIntents), VerificationModes.joinOnDash(recordedIntents)));
            }
        }
    }
}

