/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.espresso.contrib;

import android.support.test.espresso.Espresso;
import android.support.test.espresso.IdlingResource;
import android.support.test.espresso.PerformException;
import android.support.test.espresso.UiController;
import android.support.test.espresso.ViewAction;
import android.support.test.espresso.contrib.DrawerMatchers;
import android.support.test.espresso.matcher.ViewMatchers;
import android.support.v4.widget.DrawerLayout;
import android.view.View;
import java.lang.reflect.Field;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.hamcrest.Matcher;

public final class DrawerActions {
    private static Field listenerField;

    private DrawerActions() {
    }

    public static void openDrawer(int drawerLayoutId) {
        if (DrawerActions.checkDrawer(drawerLayoutId, DrawerMatchers.isOpen())) {
            return;
        }
        Espresso.onView((Matcher)ViewMatchers.withId((int)drawerLayoutId)).perform(new ViewAction[]{DrawerActions.registerListener()});
        Espresso.onView((Matcher)ViewMatchers.withId((int)drawerLayoutId)).perform(new ViewAction[]{DrawerActions.actionOpenDrawer()});
        Espresso.onView((Matcher)ViewMatchers.withId((int)drawerLayoutId)).perform(new ViewAction[]{DrawerActions.unregisterListener()});
    }

    public static void closeDrawer(int drawerLayoutId) {
        if (DrawerActions.checkDrawer(drawerLayoutId, DrawerMatchers.isClosed())) {
            return;
        }
        Espresso.onView((Matcher)ViewMatchers.withId((int)drawerLayoutId)).perform(new ViewAction[]{DrawerActions.registerListener()});
        Espresso.onView((Matcher)ViewMatchers.withId((int)drawerLayoutId)).perform(new ViewAction[]{DrawerActions.actionCloseDrawer()});
        Espresso.onView((Matcher)ViewMatchers.withId((int)drawerLayoutId)).perform(new ViewAction[]{DrawerActions.unregisterListener()});
    }

    private static boolean checkDrawer(int drawerLayoutId, final Matcher<View> matcher) {
        final AtomicBoolean matches = new AtomicBoolean(false);
        Espresso.onView((Matcher)ViewMatchers.withId((int)drawerLayoutId)).perform(new ViewAction[]{new ViewAction(){

            public Matcher<View> getConstraints() {
                return ViewMatchers.isAssignableFrom(DrawerLayout.class);
            }

            public String getDescription() {
                return "check drawer";
            }

            public void perform(UiController uiController, View view) {
                matches.set(matcher.matches((Object)view));
            }
        }});
        return matches.get();
    }

    private static ViewAction actionOpenDrawer() {
        return new ViewAction(){

            public Matcher<View> getConstraints() {
                return ViewMatchers.isAssignableFrom(DrawerLayout.class);
            }

            public String getDescription() {
                return "open drawer";
            }

            public void perform(UiController uiController, View view) {
                ((DrawerLayout)view).openDrawer(0x800003);
            }
        };
    }

    private static ViewAction actionCloseDrawer() {
        return new ViewAction(){

            public Matcher<View> getConstraints() {
                return ViewMatchers.isAssignableFrom(DrawerLayout.class);
            }

            public String getDescription() {
                return "close drawer";
            }

            public void perform(UiController uiController, View view) {
                ((DrawerLayout)view).closeDrawer(0x800003);
            }
        };
    }

    private static ViewAction registerListener() {
        return new ViewAction(){

            public Matcher<View> getConstraints() {
                return ViewMatchers.isAssignableFrom(DrawerLayout.class);
            }

            public String getDescription() {
                return "register idling drawer listener";
            }

            public void perform(UiController uiController, View view) {
                DrawerLayout drawer = (DrawerLayout)view;
                DrawerLayout.DrawerListener existingListener = DrawerActions.getDrawerListener(drawer);
                if (existingListener instanceof IdlingDrawerListener) {
                    return;
                }
                IdlingDrawerListener instance = IdlingDrawerListener.getInstance(existingListener);
                drawer.setDrawerListener((DrawerLayout.DrawerListener)instance);
                Espresso.registerIdlingResources((IdlingResource[])new IdlingResource[]{instance});
            }
        };
    }

    private static ViewAction unregisterListener() {
        return new ViewAction(){

            public Matcher<View> getConstraints() {
                return ViewMatchers.isAssignableFrom(DrawerLayout.class);
            }

            public String getDescription() {
                return "unregister idling drawer listener";
            }

            public void perform(UiController uiController, View view) {
                DrawerLayout drawer = (DrawerLayout)view;
                DrawerLayout.DrawerListener existingListener = DrawerActions.getDrawerListener(drawer);
                if (existingListener instanceof IdlingDrawerListener) {
                    Espresso.unregisterIdlingResources((IdlingResource[])new IdlingResource[]{(IdlingResource)existingListener});
                    drawer.setDrawerListener(((IdlingDrawerListener)existingListener).parentListener);
                }
            }
        };
    }

    @Nullable
    private static DrawerLayout.DrawerListener getDrawerListener(DrawerLayout drawer) {
        try {
            if (listenerField == null) {
                listenerField = DrawerLayout.class.getDeclaredField("mListener");
                listenerField.setAccessible(true);
            }
            return (DrawerLayout.DrawerListener)listenerField.get(drawer);
        }
        catch (IllegalArgumentException ex) {
            throw new PerformException.Builder().withCause((Throwable)ex).build();
        }
        catch (IllegalAccessException ex) {
            throw new PerformException.Builder().withCause((Throwable)ex).build();
        }
        catch (NoSuchFieldException ex) {
            throw new PerformException.Builder().withCause((Throwable)ex).build();
        }
        catch (SecurityException ex) {
            throw new PerformException.Builder().withCause((Throwable)ex).build();
        }
    }

    private static class IdlingDrawerListener
    implements DrawerLayout.DrawerListener,
    IdlingResource {
        private static IdlingDrawerListener instance;
        @Nullable
        private DrawerLayout.DrawerListener parentListener;
        private IdlingResource.ResourceCallback callback;
        private boolean idle = true;

        private IdlingDrawerListener() {
        }

        private static IdlingDrawerListener getInstance(DrawerLayout.DrawerListener parentListener) {
            if (instance == null) {
                instance = new IdlingDrawerListener();
            }
            instance.setParentListener(parentListener);
            return instance;
        }

        public void setParentListener(@Nullable DrawerLayout.DrawerListener parentListener) {
            this.parentListener = parentListener;
        }

        public void onDrawerClosed(View drawer) {
            if (this.parentListener != null) {
                this.parentListener.onDrawerClosed(drawer);
            }
        }

        public void onDrawerOpened(View drawer) {
            if (this.parentListener != null) {
                this.parentListener.onDrawerOpened(drawer);
            }
        }

        public void onDrawerSlide(View drawer, float slideOffset) {
            if (this.parentListener != null) {
                this.parentListener.onDrawerSlide(drawer, slideOffset);
            }
        }

        public void onDrawerStateChanged(int newState) {
            if (newState == 0) {
                this.idle = true;
                if (this.callback != null) {
                    this.callback.onTransitionToIdle();
                }
            } else {
                this.idle = false;
            }
            if (this.parentListener != null) {
                this.parentListener.onDrawerStateChanged(newState);
            }
        }

        public String getName() {
            return "IdlingDrawerListener";
        }

        public boolean isIdleNow() {
            return this.idle;
        }

        public void registerIdleTransitionCallback(IdlingResource.ResourceCallback callback) {
            this.callback = callback;
        }
    }
}

