/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3.model.BucketType;
import software.amazon.awssdk.services.s3.model.DataRedundancy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BucketInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BucketInfo> {
    private static final SdkField<String> DATA_REDUNDANCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataRedundancy").getter(BucketInfo.getter(BucketInfo::dataRedundancyAsString)).setter(BucketInfo.setter(Builder::dataRedundancy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataRedundancy").unmarshallLocationName("DataRedundancy").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(BucketInfo.getter(BucketInfo::typeAsString)).setter(BucketInfo.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").unmarshallLocationName("Type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_REDUNDANCY_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BucketInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String dataRedundancy;
    private final String type;

    private BucketInfo(BuilderImpl builder) {
        this.dataRedundancy = builder.dataRedundancy;
        this.type = builder.type;
    }

    public final DataRedundancy dataRedundancy() {
        return DataRedundancy.fromValue(this.dataRedundancy);
    }

    public final String dataRedundancyAsString() {
        return this.dataRedundancy;
    }

    public final BucketType type() {
        return BucketType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataRedundancyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BucketInfo)) {
            return false;
        }
        BucketInfo other = (BucketInfo)obj;
        return Objects.equals(this.dataRedundancyAsString(), other.dataRedundancyAsString()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"BucketInfo").add("DataRedundancy", (Object)this.dataRedundancyAsString()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataRedundancy": {
                return Optional.ofNullable(clazz.cast(this.dataRedundancyAsString()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("DataRedundancy", DATA_REDUNDANCY_FIELD);
        map.put("Type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BucketInfo, T> g) {
        return obj -> g.apply((BucketInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dataRedundancy;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(BucketInfo model) {
            this.dataRedundancy(model.dataRedundancy);
            this.type(model.type);
        }

        public final String getDataRedundancy() {
            return this.dataRedundancy;
        }

        public final void setDataRedundancy(String dataRedundancy) {
            this.dataRedundancy = dataRedundancy;
        }

        @Override
        public final Builder dataRedundancy(String dataRedundancy) {
            this.dataRedundancy = dataRedundancy;
            return this;
        }

        @Override
        public final Builder dataRedundancy(DataRedundancy dataRedundancy) {
            this.dataRedundancy(dataRedundancy == null ? null : dataRedundancy.toString());
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(BucketType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public BucketInfo build() {
            return new BucketInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BucketInfo> {
        public Builder dataRedundancy(String var1);

        public Builder dataRedundancy(DataRedundancy var1);

        public Builder type(String var1);

        public Builder type(BucketType var1);
    }
}

