/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.http;

import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.crt.CRT;
import software.amazon.awssdk.crt.CrtResource;
import software.amazon.awssdk.crt.CrtRuntimeException;

public class HttpStream
extends CrtResource {
    protected HttpStream(long ptr) {
        this.acquireNativeHandle(ptr);
    }

    @Override
    protected boolean canReleaseReferencesImmediately() {
        return true;
    }

    @Override
    protected void releaseNativeHandle() {
        if (!this.isNull()) {
            HttpStream.httpStreamRelease(this.getNativeHandle());
        }
    }

    public void incrementWindow(int windowSize) {
        if (windowSize < 0) {
            throw new IllegalArgumentException("windowSize must be >= 0. Actual value: " + windowSize);
        }
        if (!this.isNull()) {
            HttpStream.httpStreamIncrementWindow(this.getNativeHandle(), windowSize);
        }
    }

    public void writeChunk(byte[] chunkData, boolean isFinalChunk, HttpStreamWriteChunkCompletionCallback chunkCompletionCallback) {
        if (chunkCompletionCallback == null) {
            throw new IllegalArgumentException("You must supply a chunkCompletionCallback");
        }
        if (chunkData == null) {
            throw new IllegalArgumentException("You must provide a non-null chunkData");
        }
        int error = HttpStream.httpStreamWriteChunk(this.getNativeHandle(), chunkData, isFinalChunk, chunkCompletionCallback);
        if (error != 0) {
            int lastError = CRT.awsLastError();
            throw new CrtRuntimeException(lastError);
        }
    }

    public CompletableFuture<Void> writeChunk(byte[] chunkData, boolean isFinalChunk) {
        final CompletableFuture<Void> completionFuture = new CompletableFuture<Void>();
        HttpStreamWriteChunkCompletionCallback completionCallback = new HttpStreamWriteChunkCompletionCallback(){

            @Override
            public void onChunkCompleted(int errorCode) {
                if (errorCode == 0) {
                    completionFuture.complete(null);
                } else {
                    completionFuture.completeExceptionally(new CrtRuntimeException(errorCode));
                }
            }
        };
        this.writeChunk(chunkData, isFinalChunk, completionCallback);
        return completionFuture;
    }

    public void activate() {
        if (!this.isNull()) {
            HttpStream.httpStreamActivate(this.getNativeHandle(), this);
        }
    }

    public int getResponseStatusCode() {
        if (!this.isNull()) {
            return HttpStream.httpStreamGetResponseStatusCode(this.getNativeHandle());
        }
        throw new IllegalStateException("Can't get Status Code on Closed Stream");
    }

    private static native void httpStreamRelease(long var0);

    private static native void httpStreamIncrementWindow(long var0, int var2);

    private static native void httpStreamActivate(long var0, HttpStream var2);

    private static native int httpStreamGetResponseStatusCode(long var0);

    private static native int httpStreamWriteChunk(long var0, byte[] var2, boolean var3, HttpStreamWriteChunkCompletionCallback var4);

    public static interface HttpStreamWriteChunkCompletionCallback {
        public void onChunkCompleted(int var1);
    }
}

