/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.http;

import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.crt.CrtResource;
import software.amazon.awssdk.crt.CrtRuntimeException;
import software.amazon.awssdk.crt.http.HttpClientConnection;
import software.amazon.awssdk.crt.http.HttpClientConnectionManagerOptions;
import software.amazon.awssdk.crt.http.HttpMonitoringOptions;
import software.amazon.awssdk.crt.http.HttpProxyOptions;
import software.amazon.awssdk.crt.io.ClientBootstrap;
import software.amazon.awssdk.crt.io.SocketOptions;
import software.amazon.awssdk.crt.io.TlsContext;

public class HttpClientConnectionManager
extends CrtResource {
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static final int DEFAULT_HTTP_PORT = 80;
    private static final int DEFAULT_HTTPS_PORT = 443;
    private static final Charset UTF8 = StandardCharsets.UTF_8;
    private final int windowSize;
    private final URI uri;
    private final int port;
    private final int maxConnections;
    private final CompletableFuture<Void> shutdownComplete = new CompletableFuture();

    public static HttpClientConnectionManager create(HttpClientConnectionManagerOptions options) {
        return new HttpClientConnectionManager(options);
    }

    private HttpClientConnectionManager(HttpClientConnectionManagerOptions options) {
        URI uri = options.getUri();
        if (uri == null) {
            throw new IllegalArgumentException("URI must not be null");
        }
        if (uri.getScheme() == null) {
            throw new IllegalArgumentException("URI does not have a Scheme");
        }
        if (!HTTP.equals(uri.getScheme()) && !HTTPS.equals(uri.getScheme())) {
            throw new IllegalArgumentException("URI has unknown Scheme");
        }
        if (uri.getHost() == null) {
            throw new IllegalArgumentException("URI does not have a Host name");
        }
        ClientBootstrap clientBootstrap = options.getClientBootstrap();
        if (clientBootstrap == null) {
            throw new IllegalArgumentException("ClientBootstrap must not be null");
        }
        SocketOptions socketOptions = options.getSocketOptions();
        if (socketOptions == null) {
            throw new IllegalArgumentException("SocketOptions must not be null");
        }
        boolean useTls = HTTPS.equals(uri.getScheme());
        TlsContext tlsContext = options.getTlsContext();
        if (useTls && tlsContext == null) {
            throw new IllegalArgumentException("TlsContext must not be null if https is used");
        }
        int windowSize = options.getWindowSize();
        if (windowSize <= 0) {
            throw new IllegalArgumentException("Window Size must be greater than zero.");
        }
        int bufferSize = options.getBufferSize();
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("Buffer Size must be greater than zero.");
        }
        int maxConnections = options.getMaxConnections();
        if (maxConnections <= 0) {
            throw new IllegalArgumentException("Max Connections must be greater than zero.");
        }
        int port = options.getPort();
        if (port == -1 && (port = uri.getPort()) == -1) {
            if (HTTP.equals(uri.getScheme())) {
                port = 80;
            }
            if (HTTPS.equals(uri.getScheme())) {
                port = 443;
            }
        }
        HttpProxyOptions proxyOptions = options.getProxyOptions();
        this.windowSize = windowSize;
        this.uri = uri;
        this.port = port;
        this.maxConnections = maxConnections;
        int proxyConnectionType = 0;
        String proxyHost = null;
        int proxyPort = 0;
        TlsContext proxyTlsContext = null;
        int proxyAuthorizationType = 0;
        String proxyAuthorizationUsername = null;
        String proxyAuthorizationPassword = null;
        if (proxyOptions != null) {
            proxyConnectionType = proxyOptions.getConnectionType().getValue();
            proxyHost = proxyOptions.getHost();
            proxyPort = proxyOptions.getPort();
            proxyTlsContext = proxyOptions.getTlsContext();
            proxyAuthorizationType = proxyOptions.getAuthorizationType().getValue();
            proxyAuthorizationUsername = proxyOptions.getAuthorizationUsername();
            proxyAuthorizationPassword = proxyOptions.getAuthorizationPassword();
        }
        HttpMonitoringOptions monitoringOptions = options.getMonitoringOptions();
        long monitoringThroughputThresholdInBytesPerSecond = 0L;
        int monitoringFailureIntervalInSeconds = 0;
        if (monitoringOptions != null) {
            monitoringThroughputThresholdInBytesPerSecond = monitoringOptions.getMinThroughputBytesPerSecond();
            monitoringFailureIntervalInSeconds = monitoringOptions.getAllowableThroughputFailureIntervalSeconds();
        }
        this.acquireNativeHandle(HttpClientConnectionManager.httpClientConnectionManagerNew(this, clientBootstrap.getNativeHandle(), socketOptions.getNativeHandle(), useTls ? tlsContext.getNativeHandle() : 0L, windowSize, uri.getHost().getBytes(UTF8), port, maxConnections, proxyConnectionType, proxyHost != null ? proxyHost.getBytes(UTF8) : null, proxyPort, proxyTlsContext != null ? proxyTlsContext.getNativeHandle() : 0L, proxyAuthorizationType, proxyAuthorizationUsername != null ? proxyAuthorizationUsername.getBytes(UTF8) : null, proxyAuthorizationPassword != null ? proxyAuthorizationPassword.getBytes(UTF8) : null, options.isManualWindowManagement(), options.getMaxConnectionIdleInMilliseconds(), monitoringThroughputThresholdInBytesPerSecond, monitoringFailureIntervalInSeconds));
        this.addReferenceTo(clientBootstrap);
        if (useTls) {
            this.addReferenceTo(tlsContext);
        }
    }

    public CompletableFuture<HttpClientConnection> acquireConnection() {
        if (this.isNull()) {
            throw new IllegalStateException("HttpClientConnectionManager has been closed, can't acquire new connections");
        }
        CompletableFuture<HttpClientConnection> connRequest = new CompletableFuture<HttpClientConnection>();
        HttpClientConnectionManager.httpClientConnectionManagerAcquireConnection(this.getNativeHandle(), connRequest);
        return connRequest;
    }

    public void releaseConnection(HttpClientConnection conn) {
        conn.close();
    }

    private void onShutdownComplete() {
        this.releaseReferences();
        this.shutdownComplete.complete(null);
    }

    @Override
    protected boolean canReleaseReferencesImmediately() {
        return false;
    }

    @Override
    protected void releaseNativeHandle() {
        if (!this.isNull()) {
            HttpClientConnectionManager.httpClientConnectionManagerRelease(this.getNativeHandle());
        }
    }

    public CompletableFuture<Void> getShutdownCompleteFuture() {
        return this.shutdownComplete;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public URI getUri() {
        return this.uri;
    }

    private static native long httpClientConnectionManagerNew(HttpClientConnectionManager var0, long var1, long var3, long var5, int var7, byte[] var8, int var9, int var10, int var11, byte[] var12, int var13, long var14, int var16, byte[] var17, byte[] var18, boolean var19, long var20, long var22, int var24) throws CrtRuntimeException;

    private static native void httpClientConnectionManagerRelease(long var0) throws CrtRuntimeException;

    private static native void httpClientConnectionManagerAcquireConnection(long var0, CompletableFuture<HttpClientConnection> var2) throws CrtRuntimeException;
}

