/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.processor.js;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.group.processor.Injector;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.processor.Destroyable;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.model.resource.processor.decorator.ProcessorDecorator;

public abstract class AbstractNodeWithFallbackProcessor
implements ResourcePreProcessor,
ResourcePostProcessor,
Destroyable {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractNodeWithFallbackProcessor.class);
    @Inject
    private Injector injector;
    private ResourcePreProcessor processor;

    private ResourcePreProcessor initializeProcessor() {
        ProcessorDecorator processor = new ProcessorDecorator((Object)this.createNodeProcessor());
        return processor.isSupported() ? processor : this.createFallbackProcessor();
    }

    protected abstract ResourcePreProcessor createNodeProcessor();

    public final void process(Resource resource, Reader reader, Writer writer) throws IOException {
        this.getProcessor().process(resource, reader, writer);
    }

    private ResourcePreProcessor getProcessor() {
        if (this.processor == null) {
            this.processor = this.initializeProcessor();
            LOG.debug("initialized processor: {}", (Object)this.processor);
            this.injector.inject((Object)this.processor);
        }
        return this.processor;
    }

    public final void process(Reader reader, Writer writer) throws IOException {
        this.process(null, reader, writer);
    }

    protected abstract ResourcePreProcessor createFallbackProcessor();

    public void destroy() throws Exception {
        if (this.getProcessor() instanceof Destroyable) {
            ((Destroyable)this.getProcessor()).destroy();
        }
    }
}

