/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.model.factory;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.model.WroModel;
import ro.isdc.wro.model.factory.AbstractWroModelFactory;
import ro.isdc.wro.util.StopWatch;

public class JsonModelFactory
extends AbstractWroModelFactory {
    private static final Logger LOG = LoggerFactory.getLogger(JsonModelFactory.class);
    private static final String DEFAULT_FILE_NAME = "wro.json";
    public static final String ALIAS = "json";

    public synchronized WroModel create() {
        StopWatch stopWatch = new StopWatch("Create Wro Model from Groovy");
        try {
            stopWatch.start("createModel");
            Type type = new TypeToken<WroModel>(){}.getType();
            InputStream is = this.getModelResourceAsStream();
            if (is == null) {
                throw new WroRuntimeException("Invalid model stream provided!");
            }
            WroModel model = (WroModel)new Gson().fromJson((Reader)new InputStreamReader(this.getModelResourceAsStream()), type);
            LOG.debug("json model: {}", (Object)model);
            if (model == null) {
                throw new WroRuntimeException("Invalid content provided, cannot build model!");
            }
            WroModel wroModel = model;
            return wroModel;
        }
        catch (Exception e) {
            throw new WroRuntimeException("Invalid model found!", (Throwable)e);
        }
        finally {
            stopWatch.stop();
            LOG.debug(stopWatch.prettyPrint());
        }
    }

    protected String getDefaultModelFilename() {
        return DEFAULT_FILE_NAME;
    }
}

