/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.processor.support.template;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;
import org.mozilla.javascript.ScriptableObject;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.extensions.script.RhinoScriptBuilder;
import ro.isdc.wro.util.WroUtil;

public abstract class AbstractJsTemplateCompiler {
    private ScriptableObject scope;

    public String compile(String content, String optionalArgument) {
        RhinoScriptBuilder builder = this.initScriptBuilder();
        String argStr = this.createArgStr(optionalArgument) + this.createArgStr(this.getArguments());
        String compileScript = String.format("%s(%s%s);", this.getCompileCommand(), WroUtil.toJSMultiLineString((String)content), argStr);
        return (String)builder.evaluate(compileScript, this.getCompileCommand());
    }

    protected abstract String getCompileCommand();

    protected String getArguments() {
        return null;
    }

    private String createArgStr(String argument) {
        return StringUtils.isNotBlank((CharSequence)argument) ? ", " + argument : "";
    }

    protected abstract InputStream getCompilerAsStream() throws IOException;

    private RhinoScriptBuilder initScriptBuilder() {
        try {
            RhinoScriptBuilder builder;
            if (this.scope == null) {
                builder = RhinoScriptBuilder.newChain().evaluateChain(this.getCompilerAsStream(), "templateCompiler.js");
                this.scope = builder.getScope();
            } else {
                builder = RhinoScriptBuilder.newChain(this.scope);
            }
            return builder;
        }
        catch (IOException ex) {
            throw new WroRuntimeException("Failed reading init script", (Throwable)ex);
        }
    }
}

