/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.processor.css;

import com.github.sommeri.less4j.Less4jException;
import com.github.sommeri.less4j.LessCompiler;
import com.github.sommeri.less4j.core.DefaultLessCompiler;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.SupportedResourceType;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;

@SupportedResourceType(value=ResourceType.CSS)
public class Less4jProcessor
implements ResourcePreProcessor,
ResourcePostProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(Less4jProcessor.class);
    public static final String ALIAS = "less4j";
    private final LessCompiler compiler = new DefaultLessCompiler();

    public void process(Reader reader, Writer writer) throws IOException {
        this.process(null, reader, writer);
    }

    public void process(Resource resource, Reader reader, Writer writer) throws IOException {
        try {
            LessCompiler.CompilationResult result = this.compiler.compile(IOUtils.toString((Reader)reader));
            if (!result.getWarnings().isEmpty()) {
                LOG.warn("Less warnings: {}", (Object)result.getWarnings());
            }
            writer.write(result.getCss());
        }
        catch (Less4jException e) {
            LOG.error("Failed to compile less. Errors are: ");
            for (LessCompiler.Problem problem : e.getErrors()) {
                LOG.error(ToStringBuilder.reflectionToString((Object)problem));
            }
            throw WroRuntimeException.wrap((Exception)((Object)e));
        }
    }
}

