/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.processor.support.cjson;

import java.io.InputStream;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.ScriptableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.extensions.script.RhinoScriptBuilder;
import ro.isdc.wro.extensions.script.RhinoUtils;
import ro.isdc.wro.util.StopWatch;
import ro.isdc.wro.util.WroUtil;

public class CJson {
    private static final Logger LOG = LoggerFactory.getLogger(CJson.class);
    private ScriptableObject scope;

    private RhinoScriptBuilder initScriptBuilder() {
        try {
            RhinoScriptBuilder builder = null;
            if (this.scope == null) {
                builder = RhinoScriptBuilder.newClientSideAwareChain().addJSON().evaluateChain(this.getScriptAsStream(), "cjson.js");
                this.scope = builder.getScope();
            } else {
                builder = RhinoScriptBuilder.newChain(this.scope);
            }
            return builder;
        }
        catch (Exception e) {
            LOG.error("Processing error:" + e.getMessage(), (Throwable)e);
            throw new WroRuntimeException("Processing error", (Throwable)e);
        }
    }

    protected InputStream getScriptAsStream() {
        return CJson.class.getResourceAsStream("cjson.min.js");
    }

    public String pack(String data) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start("initContext");
        RhinoScriptBuilder builder = this.initScriptBuilder();
        stopWatch.stop();
        stopWatch.start("cjson.pack");
        try {
            String execute = "CJSON.stringify(JSON.parse(" + WroUtil.toJSMultiLineString((String)data) + "));";
            Object result = builder.evaluate(execute, "pack");
            String string = String.valueOf(result);
            return string;
        }
        catch (RhinoException e) {
            throw new WroRuntimeException(RhinoUtils.createExceptionMessage(e), (Throwable)e);
        }
        finally {
            stopWatch.stop();
            LOG.debug(stopWatch.prettyPrint());
        }
    }

    public String unpack(String data) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start("initContext");
        RhinoScriptBuilder builder = this.initScriptBuilder();
        stopWatch.stop();
        stopWatch.start("json.unpack");
        try {
            String execute = "JSON.stringify(CJSON.parse(" + WroUtil.toJSMultiLineString((String)data) + "));";
            Object result = builder.evaluate(execute, "unpack");
            String string = String.valueOf(result);
            return string;
        }
        catch (RhinoException e) {
            throw new WroRuntimeException(RhinoUtils.createExceptionMessage(e), (Throwable)e);
        }
        finally {
            stopWatch.stop();
            LOG.debug(stopWatch.prettyPrint());
        }
    }
}

