/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.processor.js;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.extensions.processor.support.ObjectPoolHelper;
import ro.isdc.wro.extensions.processor.support.packer.PackerJs;
import ro.isdc.wro.model.group.processor.Minimize;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.SupportedResourceType;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.util.ObjectFactory;

@Minimize
@SupportedResourceType(value=ResourceType.JS)
public class PackerJsProcessor
implements ResourcePreProcessor,
ResourcePostProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(PackerJsProcessor.class);
    public static final String ALIAS = "packerJs";
    private ObjectPoolHelper<PackerJs> enginePool = new ObjectPoolHelper<PackerJs>(new ObjectFactory<PackerJs>(){

        public PackerJs create() {
            return PackerJsProcessor.this.newPackerJs();
        }
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Resource resource, Reader reader, Writer writer) throws IOException {
        String content = IOUtils.toString((Reader)reader);
        PackerJs packerJs = this.enginePool.getObject();
        try {
            writer.write(packerJs.pack(content));
        }
        catch (WroRuntimeException e) {
            this.onException(e);
            String resourceUri = resource == null ? "" : "[" + resource.getUri() + "]";
            LOG.warn("Exception while applying " + this.getClass().getSimpleName() + " processor on the " + resourceUri + " resource, no processing applied...", (Throwable)e);
        }
        finally {
            reader.close();
            writer.close();
            this.enginePool.returnObject(packerJs);
        }
    }

    protected void onException(WroRuntimeException e) {
        throw e;
    }

    protected PackerJs newPackerJs() {
        return new PackerJs();
    }

    public void process(Reader reader, Writer writer) throws IOException {
        this.process(null, reader, writer);
    }
}

